/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposeCommandLineProcessor;
import androidx.compose.compiler.plugins.kotlin.FeatureFlag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u001a\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0001\u00a8\u0006\u000e"}, d2={"featureFlagName", "", "useFeatureFlagInsteadMessage", "feature", "Landroidx/compose/compiler/plugins/kotlin/FeatureFlag;", "oldOptionDeprecationWarning", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "oldOption", "Lorg/jetbrains/kotlin/compiler/plugin/AbstractCliOption;", "newOption", "validateFeatureFlag", "value", "kotlin-compose-compiler-plugin"})
public final class ComposePluginKt {
    @NotNull
    public static final String featureFlagName() {
        return "plugin:" + ComposeCommandLineProcessor.Companion.getPLUGIN_ID() + ':' + ComposeCommandLineProcessor.Companion.getFEATURE_FLAG_OPTION().getOptionName();
    }

    @NotNull
    public static final String useFeatureFlagInsteadMessage(@NotNull FeatureFlag feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        return "Use " + ComposePluginKt.featureFlagName() + '=' + feature.getFeatureName() + " instead";
    }

    public static final void oldOptionDeprecationWarning(@NotNull CompilerConfiguration configuration, @NotNull AbstractCliOption oldOption, @NotNull FeatureFlag feature) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)oldOption, (String)"oldOption");
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        MessageCollector.report$default((MessageCollector)CommonConfigurationKeysKt.getMessageCollector((CompilerConfiguration)configuration), (CompilerMessageSeverity)CompilerMessageSeverity.WARNING, (String)(oldOption.getOptionName() + " is deprecated. " + ComposePluginKt.useFeatureFlagInsteadMessage(feature)), null, (int)4, null);
    }

    public static final void oldOptionDeprecationWarning(@NotNull CompilerConfiguration configuration, @NotNull AbstractCliOption oldOption, @NotNull AbstractCliOption newOption) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)oldOption, (String)"oldOption");
        Intrinsics.checkNotNullParameter((Object)newOption, (String)"newOption");
        MessageCollector.report$default((MessageCollector)CommonConfigurationKeysKt.getMessageCollector((CompilerConfiguration)configuration), (CompilerMessageSeverity)CompilerMessageSeverity.WARNING, (String)(oldOption.getOptionName() + " is deprecated. Use " + newOption.getOptionName() + " instead"), null, (int)4, null);
    }

    public static final void validateFeatureFlag(@NotNull CompilerConfiguration configuration, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        FeatureFlag feature = (FeatureFlag)((Object)FeatureFlag.Companion.fromString(value).component1());
        if (feature == null) {
            MessageCollector.report$default((MessageCollector)CommonConfigurationKeysKt.getMessageCollector((CompilerConfiguration)configuration), (CompilerMessageSeverity)CompilerMessageSeverity.WARNING, (String)(ComposePluginKt.featureFlagName() + " contains an unrecognized feature name: " + value + '.'), null, (int)4, null);
        }
    }
}

