/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.ide.common.resources.configuration;

import static com.google.common.truth.Truth.assertThat;

import com.android.resources.WideGamutColor;
import junit.framework.TestCase;

public class WideGamutColorQualifierTest extends TestCase {

    private WideGamutColorQualifier qual;
    private FolderConfiguration config;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        qual = new WideGamutColorQualifier();
        config = new FolderConfiguration();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        qual = null;
        config = null;
    }

    public void testWideGamut() {
        assertThat(qual.checkAndSet("widecg", config)).isTrue();
        final WideGamutColorQualifier configQual = config.getWideColorGamutQualifier();
        assertThat(configQual).isNotNull();
        assertThat(configQual.getValue()).isEqualTo(WideGamutColor.WIDECG);
        assertThat(configQual.toString()).isEqualTo("widecg");
    }

    public void testNarrowGamut() {
        assertThat(qual.checkAndSet("nowidecg", config)).isTrue();
        final WideGamutColorQualifier configQual = config.getWideColorGamutQualifier();
        assertThat(configQual).isNotNull();
        assertThat(configQual.getValue()).isEqualTo(WideGamutColor.NOWIDECG);
        assertThat(configQual.toString()).isEqualTo("nowidecg");
    }

    public void testFailures() {
        assertThat(qual.checkAndSet("", config)).named("qual test for <empty>").isFalse();
        assertThat(qual.checkAndSet("no-widecg", config))
                .named("qual test for no-widegc")
                .isFalse();
    }
}
