/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.gradle.integration.application

import com.android.build.gradle.integration.common.truth.TruthHelper.assertThat

import com.android.build.gradle.integration.common.category.SmokeTests
import com.android.build.gradle.integration.common.fixture.GradleTestProject
import org.junit.Rule
import org.junit.Test
import org.junit.experimental.categories.Category

/** Assemble tests for kotlin.  */
@Category(SmokeTests::class)
class KotlinWithEclipseSourceSetTest {
    @get:Rule
    var project: GradleTestProject =
        GradleTestProject.builder().fromTestProject("kotlinWithEclipseSourceSet")
            .create()

    @Test
    @Throws(Exception::class)
    fun apkContents() {
        project.executor().run("clean", "app:assembleDebug")
        val apk = project.getSubproject(":app").getApk(GradleTestProject.ApkType.DEBUG)
        assertThat(apk).isNotNull()
        assertThat(apk).doesNotContain("/com/sample/kotlin_source_leak/MainActivity.kt")
    }
}
