/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.builder.merge;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class DelegateIncrementalFileMergerOutputTest {
    private IncrementalFileMergerOutput mockOutput;

    private DelegateIncrementalFileMergerOutput delegate;

    @Before
    public final void before() {
        mockOutput = Mockito.mock(IncrementalFileMergerOutput.class);
        delegate = new DelegateIncrementalFileMergerOutput(mockOutput);
    }

    @After
    public final void after() {
        Mockito.verifyNoMoreInteractions(mockOutput);
    }

    @Test
    public void open() {
        delegate.open();
        Mockito.verify(mockOutput).open();
    }

    @Test
    public void close() throws IOException {
        delegate.close();
        Mockito.verify(mockOutput).close();
    }

    @Test
    public void remove() {
        delegate.remove("foo");
        Mockito.verify(mockOutput).remove(ArgumentMatchers.eq("foo"));
    }

    @Test
    public void create() {
        ImmutableList<IncrementalFileMergerInput> inputs = ImmutableList.of();

        delegate.create("foo", inputs, true);
        Mockito.verify(mockOutput)
                .create(
                        ArgumentMatchers.eq("foo"),
                        ArgumentMatchers.same(inputs),
                        ArgumentMatchers.eq(true));
    }

    @Test
    public void update() {
        ImmutableList<String> prevNames = ImmutableList.of();
        ImmutableList<IncrementalFileMergerInput> inputs = ImmutableList.of();

        delegate.update("foo", prevNames, inputs, true);
        Mockito.verify(mockOutput)
                .update(
                        ArgumentMatchers.eq("foo"),
                        ArgumentMatchers.same(prevNames),
                        ArgumentMatchers.same(inputs),
                        ArgumentMatchers.eq(true));
    }
}
