/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.test;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.agent.OrchestrationKt;
import org.jetbrains.compose.reload.agent.ReloadHooksKt;
import org.jetbrains.compose.reload.core.Disposable;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.core.TryKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.jetbrains.compose.reload.test.SystemPropertiesKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.CompilerRunnerUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\f"}, d2={"tempDir", "Ljava/nio/file/Path;", "getTempDir", "()Ljava/nio/file/Path;", "tempSourcesDir", "getTempSourcesDir", "tempClassesDir", "getTempClassesDir", "compileAndReload", "", "sourceCode", "", "hot-reload-test"})
@SourceDebugExtension(value={"SMAP\ncompileAndReload.kt\nKotlin\n*S Kotlin\n*F\n+ 1 compileAndReload.kt\norg/jetbrains/compose/reload/test/CompileAndReloadKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,137:1\n1563#2:138\n1634#2,3:139\n1563#2:142\n1634#2,3:143\n774#2:150\n865#2,2:151\n1563#2:153\n1634#2,3:154\n1285#2,2:157\n1299#2,2:159\n1302#2:162\n37#3:146\n36#3,3:147\n1#4:161\n15#5:163\n*S KotlinDebug\n*F\n+ 1 compileAndReload.kt\norg/jetbrains/compose/reload/test/CompileAndReloadKt\n*L\n69#1:138\n69#1:139,3\n70#1:142\n70#1:143,3\n90#1:150\n90#1:151,2\n91#1:153\n91#1:154,3\n92#1:157,2\n92#1:159,2\n92#1:162\n70#1:146\n70#1:147,3\n125#1:163\n*E\n"})
public final class CompileAndReloadKt {
    @NotNull
    private static final Path tempDir;
    @NotNull
    private static final Path tempSourcesDir;
    @NotNull
    private static final Path tempClassesDir;

    @NotNull
    public static final Path getTempDir() {
        return tempDir;
    }

    @NotNull
    public static final Path getTempSourcesDir() {
        return tempSourcesDir;
    }

    @NotNull
    public static final Path getTempClassesDir() {
        return tempClassesDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void compileAndReload(@NotNull String sourceCode) {
        void $this$associateWith$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Path it2;
        Collection<Object> collection;
        Object object;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
        PathsKt.deleteRecursively((Path)tempClassesDir);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(tempSourcesDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path sourceFile = tempDir.resolve("TestSources.kt");
        Intrinsics.checkNotNull((Object)sourceFile);
        PathsKt.writeText$default((Path)sourceFile, (CharSequence)sourceCode, null, (OpenOption[])new OpenOption[0], (int)2, null);
        K2JVMCompilerArguments arguments = new K2JVMCompilerArguments();
        arguments.setModuleName(SystemPropertiesKt.getCompileModuleName());
        arguments.setNoStdlib(true);
        arguments.setKotlinHome(null);
        File file = tempClassesDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        CompilerRunnerUtils.setDestinationAsFile((K2JVMCompilerArguments)arguments, (File)file);
        Iterable iterable = SystemPropertiesKt.getCompileClasspath();
        Object object2 = arguments;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            object = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.toFile().getAbsoluteFile());
        }
        CompilerRunnerUtils.setClasspathAsList((K2JVMCompilerArguments)object2, (List)((List)destination$iv$iv));
        $this$map$iv2 = SystemPropertiesKt.getCompilePluginClasspath();
        object2 = arguments;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it2 = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)it2.toAbsolutePath()).toString());
        }
        String[] $this$toTypedArray$iv = (String[])((List)destination$iv$iv);
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        object2.setPluginClasspaths(thisCollection$iv.toArray(new String[0]));
        $this$toTypedArray$iv = new String[]{"plugin:androidx.compose.compiler.plugins.kotlin:featureFlag=OptimizeNonSkippingGroups", "plugin:androidx.compose.compiler.plugins.kotlin:generateFunctionKeyMetaAnnotations=true", "plugin:androidx.compose.compiler.plugins.kotlin:sourceInformation=true"};
        arguments.setPluginOptions($this$toTypedArray$iv);
        arguments.setFreeArgs(CollectionsKt.listOf((Object)((Object)sourceFile.toAbsolutePath()).toString()));
        ExitCode result = new K2JVMCompiler().exec((MessageCollector)new PrintingMessageCollector(System.err, MessageRenderer.GRADLE_STYLE, false), Services.EMPTY, (CommonCompilerArguments)arguments);
        if (result.getCode() != 0) {
            throw new IllegalStateException(("Failed compiling code (" + result.getCode() + ")").toString());
        }
        thisCollection$iv = SequencesKt.toList((Sequence)PathsKt.walk((Path)tempClassesDir, (PathWalkOption[])new PathWalkOption[0]));
        boolean $i$f$filter = false;
        void $i$f$mapTo2 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Path)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it), (Object)"class")) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Path)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            object2.add(it.toFile());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            OrchestrationMessage.ReloadClassesRequest.ChangeType changeType;
            Object $i$a$-runCatching-CompileAndReloadKt$compileAndReload$classes$3$22;
            void file2;
            it = (File)element$iv$iv;
            collection = element$iv$iv;
            object2 = result$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)file2);
            ClassReader reader = new ClassReader(FilesKt.readBytes((File)file2));
            ClassNode node = new ClassNode(589824);
            reader.accept((ClassVisitor)node, 0);
            String string2 = node.name;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            String name = StringsKt.replace$default((String)string2, (String)"/", (String)".", (boolean)false, (int)4, null);
            try {
                boolean $i$a$-runCatching-CompileAndReloadKt$compileAndReload$classes$3$22 = false;
                $i$a$-runCatching-CompileAndReloadKt$compileAndReload$classes$3$22 = Result.constructor-impl(Thread.currentThread().getContextClassLoader().loadClass(name));
            }
            catch (Throwable throwable) {
                $i$a$-runCatching-CompileAndReloadKt$compileAndReload$classes$3$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (Result.isFailure-impl((Object)$i$a$-runCatching-CompileAndReloadKt$compileAndReload$classes$3$22)) {
                Path path;
                Path applicationClassesDir = SystemPropertiesKt.applicationClassesDir();
                Path targetFile = applicationClassesDir.resolve(node.name + ".class");
                Intrinsics.checkNotNull((Object)targetFile);
                PathsKt.createParentDirectories((Path)targetFile, (FileAttribute[])new FileAttribute[0]);
                Intrinsics.checkNotNullExpressionValue((Object)file2.toPath(), (String)"toPath(...)");
                Path path2 = targetFile;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                CopyOption[] copyOptionArray2 = copyOptionArray;
                Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, path2, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
                changeType = OrchestrationMessage.ReloadClassesRequest.ChangeType.Added;
            } else {
                changeType = OrchestrationMessage.ReloadClassesRequest.ChangeType.Modified;
            }
            OrchestrationMessage.ReloadClassesRequest.ChangeType changeType2 = changeType;
            object2.put(collection, changeType2);
        }
        Map classes = result$iv;
        OrchestrationMessage.ReloadClassesRequest request = new OrchestrationMessage.ReloadClassesRequest(classes);
        CompletableFuture future = new CompletableFuture();
        Disposable listener = ReloadHooksKt.invokeAfterHotReload((arg_0, arg_1) -> CompileAndReloadKt.compileAndReload$lambda$11(request, future, arg_0, arg_1));
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        logger.debug("Sending reload request (" + request.getMessageId() + ")");
        OrchestrationKt.send((OrchestrationMessage)((OrchestrationMessage)request));
        try {
            Unit cfr_ignored_0 = (Unit)future.get(30L, TimeUnit.SECONDS);
        }
        catch (ExecutionException t) {
            object = t.getCause();
            if (object != null) {
                it = object;
                boolean bl = false;
                throw it;
            }
            throw t;
        }
        finally {
            listener.dispose();
        }
    }

    private static final void tempDir$lambda$1$lambda$0(Path $this_apply) {
        Intrinsics.checkNotNull((Object)$this_apply);
        PathsKt.deleteRecursively((Path)$this_apply);
    }

    private static final void compileAndReload$lambda$11$lambda$10(Either $result, CompletableFuture $future) {
        if (TryKt.isSuccess((Either)$result)) {
            $future.complete(Unit.INSTANCE);
        }
        if (TryKt.isFailure((Either)$result)) {
            $future.completeExceptionally((Throwable)((Right)$result).getValue());
        }
    }

    private static final Unit compileAndReload$lambda$11(OrchestrationMessage.ReloadClassesRequest $request, CompletableFuture $future, UUID uuid, Either result) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (!Intrinsics.areEqual((Object)uuid, (Object)$request.getMessageId())) {
            return Unit.INSTANCE;
        }
        SwingUtilities.invokeLater(() -> CompileAndReloadKt.compileAndReload$lambda$11$lambda$10(result, $future));
        return Unit.INSTANCE;
    }

    static {
        Path path;
        Path $this$tempDir_u24lambda_u241 = path = Files.createTempDirectory("hot-reload-test", new FileAttribute[0]);
        boolean bl = false;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> CompileAndReloadKt.tempDir$lambda$1$lambda$0($this$tempDir_u24lambda_u241)));
        Path path2 = path;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"apply(...)");
        tempDir = path2;
        Path $this$tempSourcesDir_u24lambda_u242 = path = tempDir.resolve("sources");
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)$this$tempSourcesDir_u24lambda_u242);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories($this$tempSourcesDir_u24lambda_u242, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path path3 = path;
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"apply(...)");
        tempSourcesDir = path3;
        Path $this$tempClassesDir_u24lambda_u243 = path = tempDir.resolve("classes");
        boolean bl3 = false;
        Intrinsics.checkNotNull((Object)$this$tempClassesDir_u24lambda_u243);
        FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories($this$tempClassesDir_u24lambda_u243, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createDirectories(...)");
        Path path4 = path;
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"apply(...)");
        tempClassesDir = path4;
    }
}

