/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.orchestration;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0007\u001a\u00020\b\u001a\u0006\u0010\t\u001a\u00020\n\u001a\u001f\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\u0010\u000f\"\u0016\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"orchestrationThreadReference", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/Thread;", "orchestrationThread", "Ljava/util/concurrent/ExecutorService;", "getOrchestrationThread", "()Ljava/util/concurrent/ExecutorService;", "isOrchestrationThread", "", "checkIsOrchestrationThread", "", "runInOrchestrationThreadBlocking", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "hot-reload-orchestration"})
public final class OrchestrationExecutorKt {
    @NotNull
    private static final AtomicReference<Thread> orchestrationThreadReference = new AtomicReference<Object>(null);
    @NotNull
    private static final ExecutorService orchestrationThread;

    @NotNull
    public static final ExecutorService getOrchestrationThread() {
        return orchestrationThread;
    }

    public static final boolean isOrchestrationThread() {
        return Intrinsics.areEqual((Object)Thread.currentThread(), (Object)orchestrationThreadReference.get());
    }

    public static final void checkIsOrchestrationThread() {
        if (!OrchestrationExecutorKt.isOrchestrationThread()) {
            boolean bl = false;
            Thread thread = orchestrationThreadReference.get();
            String string = "Required Orchestration Thread '" + (thread != null ? thread.getName() : null) + "', but was called on " + Thread.currentThread().getName();
            throw new IllegalStateException(string.toString());
        }
    }

    public static final <T> T runInOrchestrationThreadBlocking(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (OrchestrationExecutorKt.isOrchestrationThread()) {
            return (T)action.invoke();
        }
        return (T)orchestrationThread.submit(() -> OrchestrationExecutorKt.runInOrchestrationThreadBlocking$lambda$3(action)).get();
    }

    private static final Unit orchestrationThread$lambda$1$lambda$0(Runnable $runnable) {
        $runnable.run();
        return Unit.INSTANCE;
    }

    private static final Thread orchestrationThread$lambda$1(Runnable runnable) {
        Thread newThread = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"Orchestration Main", (int)0, () -> OrchestrationExecutorKt.orchestrationThread$lambda$1$lambda$0(runnable), (int)20, null);
        if (!(orchestrationThreadReference.getAndSet(newThread) == null)) {
            throw new IllegalStateException("Check failed.");
        }
        return newThread;
    }

    private static final Object runInOrchestrationThreadBlocking$lambda$3(Function0 $tmp0) {
        return $tmp0.invoke();
    }

    static {
        ExecutorService executorService = Executors.newSingleThreadExecutor(OrchestrationExecutorKt::orchestrationThread$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        orchestrationThread = executorService;
    }
}

