/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.test;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.agent.OrchestrationKt;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientRole;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.jetbrains.compose.reload.test.ClassLoadingKt;
import org.jetbrains.compose.reload.test.ExitCode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010*\n\u0000\u001a\u001b\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0001\u00a2\u0006\u0002\u0010\u0007\u001a\u0016\u0010\b\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "main", "", "args", "", "", "([Ljava/lang/String;)V", "executeTest", "", "hot-reload-test"})
@JvmName(name="Main")
@SourceDebugExtension(value={"SMAP\nmain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 main.kt\norg/jetbrains/compose/reload/test/Main\n+ 2 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,72:1\n22#2:73\n*S KotlinDebug\n*F\n+ 1 main.kt\norg/jetbrains/compose/reload/test/Main\n*L\n19#1:73\n*E\n"})
public final class Main {
    @NotNull
    private static final Logger logger;

    @PublishedApi
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Main.executeTest(ArraysKt.asList((Object[])args).listIterator());
    }

    private static final void executeTest(ListIterator<String> args) {
        String className = null;
        String methodName = null;
        while (args.hasNext()) {
            String arg = args.next();
            if (Intrinsics.areEqual((Object)arg, (Object)"--class")) {
                className = args.next();
                continue;
            }
            if (Intrinsics.areEqual((Object)arg, (Object)"--method")) {
                methodName = args.next();
                continue;
            }
            throw new IllegalStateException(("Unknown argument: " + arg).toString());
        }
        if (className == null) {
            throw new IllegalStateException("Missing --class argument".toString());
        }
        if (methodName == null) {
            throw new IllegalStateException("Missing --method argument".toString());
        }
        try {
            Thread.currentThread().setContextClassLoader(ClassLoadingKt.getTestClassLoader());
            Class<?> clazz = ClassLoadingKt.getTestClassLoader().loadClass(className);
            Method method = clazz.getMethod(methodName, new Class[0]);
            method.invoke(null, new Object[0]);
            System.exit(ExitCode.Success.getValue());
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        catch (Throwable t) {
            Throwable targetException = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getTargetException() : t;
            LoggingKt.error((Logger)logger, (String)"Test failed", (Throwable)targetException);
            String string2 = targetException.getMessage();
            String string3 = targetException.getClass().getName();
            StackTraceElement[] stackTraceElementArray = targetException.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            OrchestrationKt.sendBlocking((OrchestrationMessage)((OrchestrationMessage)new OrchestrationMessage.CriticalException(OrchestrationClientRole.Application, string2, string3, ArraysKt.toList((Object[])stackTraceElementArray))));
            System.exit(targetException instanceof AssertionError ? ExitCode.AssertionError.getValue() : ExitCode.ExecutionError.getValue());
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string2 = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default((String)string2, null, null, (int)6, null);
    }
}

