/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.testing.DefaultTestOutputEvent;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.time.Time;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.core.Broadcast;
import org.jetbrains.compose.reload.core.BroadcastKt;
import org.jetbrains.compose.reload.core.DebuggerKt;
import org.jetbrains.compose.reload.core.Future;
import org.jetbrains.compose.reload.core.FutureKt;
import org.jetbrains.compose.reload.core.HotReloadProperty;
import org.jetbrains.compose.reload.core.ProcessUtilsKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.jetbrains.compose.reload.orchestration.OrchestrationServer;
import org.jetbrains.compose.reload.orchestration.OrchestrationServerKt;
import org.jetbrains.compose.reload.test.ClassDescriptor;
import org.jetbrains.compose.reload.test.HotReloadTestExecutionSpec;
import org.jetbrains.compose.reload.test.MethodDescriptor;
import org.jetbrains.compose.reload.test.TestMethodCoordinates;
import org.jetbrains.compose.reload.test.UnitTestDiscoveryKt;
import org.jetbrains.compose.reload.test.UnitTestFailureKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BY\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010\u001d\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010#\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/compose/reload/test/HotReloadUnitTestExecutor;", "Lorg/gradle/api/internal/tasks/testing/TestExecuter;", "Lorg/jetbrains/compose/reload/test/HotReloadTestExecutionSpec;", "javaExecutable", "Ljava/io/File;", "workingDir", "classpath", "Lorg/gradle/api/file/FileCollection;", "testClasses", "agentJar", "agentClasspath", "compileModuleName", "", "compileClasspath", "compilePluginClasspath", "intellijDebuggerDispatchPort", "", "<init>", "(Ljava/io/File;Ljava/io/File;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/file/FileCollection;Ljava/lang/String;Lorg/gradle/api/file/FileCollection;Lorg/gradle/api/file/FileCollection;Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "executionProcess", "Ljava/lang/Process;", "executionProcessLock", "Ljava/util/concurrent/locks/ReentrantLock;", "execute", "", "testExecutionSpec", "testResultProcessor", "Lorg/gradle/api/internal/tasks/testing/TestResultProcessor;", "launchTest", "processor", "testMethodDescriptor", "Lorg/jetbrains/compose/reload/test/MethodDescriptor;", "orchestrationServer", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationServer;", "stopNow", "gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nunitTestExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 unitTestExecutor.kt\norg/jetbrains/compose/reload/test/HotReloadUnitTestExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Broadcast.kt\norg/jetbrains/compose/reload/core/BroadcastKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1368#2:232\n1454#2,5:233\n774#2:238\n865#2,2:239\n1485#2:241\n1510#2,3:242\n1513#2,3:252\n1863#2,2:256\n381#3,7:245\n216#4:255\n217#4:258\n36#5:259\n1#6:260\n*S KotlinDebug\n*F\n+ 1 unitTestExecutor.kt\norg/jetbrains/compose/reload/test/HotReloadUnitTestExecutor\n*L\n67#1:232\n67#1:233,5\n68#1:238\n68#1:239,2\n84#1:241\n84#1:242,3\n84#1:252,3\n88#1:256,2\n84#1:245,7\n84#1:255\n84#1:258\n122#1:259\n*E\n"})
public final class HotReloadUnitTestExecutor
implements TestExecuter<HotReloadTestExecutionSpec> {
    @NotNull
    private final File javaExecutable;
    @NotNull
    private final File workingDir;
    @NotNull
    private final FileCollection classpath;
    @NotNull
    private final FileCollection testClasses;
    @NotNull
    private final FileCollection agentJar;
    @NotNull
    private final FileCollection agentClasspath;
    @NotNull
    private final String compileModuleName;
    @NotNull
    private final FileCollection compileClasspath;
    @NotNull
    private final FileCollection compilePluginClasspath;
    @Nullable
    private final Integer intellijDebuggerDispatchPort;
    @Nullable
    private Process executionProcess;
    @NotNull
    private final ReentrantLock executionProcessLock;

    public HotReloadUnitTestExecutor(@NotNull File javaExecutable2, @NotNull File workingDir, @NotNull FileCollection classpath, @NotNull FileCollection testClasses, @NotNull FileCollection agentJar, @NotNull FileCollection agentClasspath, @NotNull String compileModuleName, @NotNull FileCollection compileClasspath, @NotNull FileCollection compilePluginClasspath, @Nullable Integer intellijDebuggerDispatchPort) {
        Intrinsics.checkNotNullParameter((Object)javaExecutable2, (String)"javaExecutable");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)testClasses, (String)"testClasses");
        Intrinsics.checkNotNullParameter((Object)agentJar, (String)"agentJar");
        Intrinsics.checkNotNullParameter((Object)agentClasspath, (String)"agentClasspath");
        Intrinsics.checkNotNullParameter((Object)compileModuleName, (String)"compileModuleName");
        Intrinsics.checkNotNullParameter((Object)compileClasspath, (String)"compileClasspath");
        Intrinsics.checkNotNullParameter((Object)compilePluginClasspath, (String)"compilePluginClasspath");
        this.javaExecutable = javaExecutable2;
        this.workingDir = workingDir;
        this.classpath = classpath;
        this.testClasses = testClasses;
        this.agentJar = agentJar;
        this.agentClasspath = agentClasspath;
        this.compileModuleName = compileModuleName;
        this.compileClasspath = compileClasspath;
        this.compilePluginClasspath = compilePluginClasspath;
        this.intellijDebuggerDispatchPort = intellijDebuggerDispatchPort;
        this.executionProcessLock = new ReentrantLock();
    }

    /*
     * WARNING - void declaration
     */
    public void execute(@NotNull HotReloadTestExecutionSpec testExecutionSpec, @NotNull TestResultProcessor testResultProcessor) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)testExecutionSpec, (String)"testExecutionSpec");
        Intrinsics.checkNotNullParameter((Object)testResultProcessor, (String)"testResultProcessor");
        Set set = this.testClasses.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
        Iterable $this$flatMap$iv = set;
        boolean $i$f$flatMap = false;
        Object object = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File file = (File)element$iv$iv;
            boolean bl = false;
            Path path = file.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            list$iv$iv = UnitTestDiscoveryKt.findTestMethods(path);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestMethodCoordinates coordinates = (TestMethodCoordinates)element$iv$iv;
            boolean bl = false;
            if (!(testExecutionSpec.getClassName() != null && !Intrinsics.areEqual((Object)testExecutionSpec.getClassName(), (Object)coordinates.getClassName()) ? false : testExecutionSpec.getMethodName() == null || Intrinsics.areEqual((Object)testExecutionSpec.getMethodName(), (Object)coordinates.getMethodName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List methods = (List)destination$iv$iv;
        if (methods.isEmpty()) {
            throw new IllegalStateException("No test methods found".toString());
        }
        Object $this$groupBy$iv = methods;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            TestMethodCoordinates it = (TestMethodCoordinates)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getClassName();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String className = (String)entry.getKey();
            List methods2 = (List)entry.getValue();
            ClassDescriptor classDescriptor = new ClassDescriptor(className);
            testResultProcessor.started((TestDescriptorInternal)classDescriptor, new TestStartEvent(System.currentTimeMillis()));
            Iterable $this$forEach$iv2 = methods2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TestMethodCoordinates testMethod = (TestMethodCoordinates)element$iv2;
                boolean bl3 = false;
                MethodDescriptor methodDescriptor = new MethodDescriptor(classDescriptor, testMethod.getMethodName());
                testResultProcessor.started((TestDescriptorInternal)methodDescriptor, new TestStartEvent(System.currentTimeMillis(), classDescriptor.getId()));
                this.launchTest(testResultProcessor, methodDescriptor);
                testResultProcessor.completed(methodDescriptor.getId(), new TestCompleteEvent(System.currentTimeMillis()));
            }
            testResultProcessor.completed(classDescriptor.getId(), new TestCompleteEvent(System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void launchTest(TestResultProcessor processor, MethodDescriptor testMethodDescriptor) {
        AutoCloseable autoCloseable = (AutoCloseable)OrchestrationServerKt.startOrchestrationServer();
        Throwable throwable = null;
        try {
            OrchestrationServer server = (OrchestrationServer)autoCloseable;
            boolean bl = false;
            this.launchTest(server, processor, testMethodDescriptor);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void launchTest(OrchestrationServer orchestrationServer, TestResultProcessor processor, MethodDescriptor testMethodDescriptor) {
        Object object;
        Path applicationClassesDir = Files.createTempDirectory("reloadTest-applicationClasses", new FileAttribute[0]);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> HotReloadUnitTestExecutor.launchTest$lambda$1(applicationClassesDir)));
        Broadcast $this$withType$iv = orchestrationServer.getMessages();
        boolean $i$f$withType = false;
        BroadcastKt.invokeOnValue((Broadcast)((Broadcast)new Broadcast<OrchestrationMessage.CriticalException>($this$withType$iv){
            final /* synthetic */ Broadcast $this_withType;
            {
                this.$this_withType = $receiver;
            }

            public Object collect(Function2<? super OrchestrationMessage.CriticalException, ? super Continuation<? super Unit>, ? extends Object> action, Continuation<? super Unit> $completion) {
                Object object = this.$this_withType.collect((Function2)new Function2<Object, Continuation<? super Unit>, Object>(action, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ Function2 $action;
                    {
                        this.$action = $action;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Object it = this.L$0;
                                if (!(it instanceof OrchestrationMessage.CriticalException)) return Unit.INSTANCE;
                                this.label = 1;
                                Object object3 = this.$action.invoke(it, (Object)((Object)this));
                                Object object4 = object3;
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object4 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(Object p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }), arg_0 -> HotReloadUnitTestExecutor.launchTest$lambda$2(processor, testMethodDescriptor, arg_0));
        Lock lock = this.executionProcessLock;
        lock.lock();
        try {
            boolean bl = false;
            Object object2 = new SpreadBuilder(22);
            object2.add((Object)this.javaExecutable.getAbsolutePath());
            object2.add((Object)"-cp");
            object2.add((Object)(this.classpath.filter(arg_0 -> HotReloadUnitTestExecutor.launchTest$lambda$3$1(HotReloadUnitTestExecutor::launchTest$lambda$3$0, arg_0)).getAsPath() + File.pathSeparator + this.agentClasspath.getAsPath()));
            object2.addSpread((Object)DebuggerKt.issueNewDebugSessionJvmArguments((String)"Hot Reload Test", (Integer)this.intellijDebuggerDispatchPort));
            object2.add((Object)("-javaagent:" + this.agentJar.getAsPath()));
            object2.add((Object)"-XX:+AllowEnhancedClassRedefinition");
            object2.add((Object)"-Xms64M");
            object2.add((Object)"-Xmx256M");
            object2.add((Object)"-Xlog:redefine+class*=trace");
            object2.add((Object)"-Dapple.awt.UIElement=true");
            Intrinsics.checkNotNull((Object)applicationClassesDir);
            object2.add((Object)("-DapplicationClassesDir=" + ((Object)applicationClassesDir.toAbsolutePath()).toString()));
            object2.add((Object)("-DtestClasses=" + this.testClasses.getAsPath() + File.pathSeparator + applicationClassesDir));
            object2.add((Object)("-D" + HotReloadProperty.IsHotReloadActive.getKey() + "=true"));
            object2.add((Object)("-D" + HotReloadProperty.IsHeadless.getKey() + "=true"));
            object2.add((Object)("-D" + HotReloadProperty.ReloadEffectsEnabled.getKey() + "=false"));
            object2.add((Object)("-D" + HotReloadProperty.DevToolsEnabled.getKey() + "=false"));
            object2.add((Object)("-D" + HotReloadProperty.OrchestrationPort.getKey() + "=" + FutureKt.getBlocking((Future)orchestrationServer.getPort())));
            object2.add((Object)"org.jetbrains.compose.reload.test.Main");
            object2.add((Object)"--class");
            object2.add((Object)testMethodDescriptor.getClassName());
            object2.add((Object)"--method");
            object2.add((Object)testMethodDescriptor.getMethodName());
            Object $this$launchTest_u24lambda_u243_u242 = object2 = new ProcessBuilder((String[])object2.toArray((Object[])new String[object2.size()]));
            boolean bl2 = false;
            Map<String, String> map = ((ProcessBuilder)$this$launchTest_u24lambda_u243_u242).environment();
            Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
            Map<String, String> map2 = map;
            String string = "chr.compileModuleName";
            String string2 = this.compileModuleName;
            map2.put(string, string2);
            Map<String, String> map3 = ((ProcessBuilder)$this$launchTest_u24lambda_u243_u242).environment();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"environment(...)");
            map2 = map3;
            string = "chr.compilePath";
            string2 = this.compileClasspath.getAsPath();
            map2.put(string, string2);
            Map<String, String> map4 = ((ProcessBuilder)$this$launchTest_u24lambda_u243_u242).environment();
            Intrinsics.checkNotNullExpressionValue(map4, (String)"environment(...)");
            map2 = map4;
            string = "chr.compilePluginPath";
            string2 = this.compilePluginClasspath.getAsPath();
            map2.put(string, string2);
            Object process = object2 = ((ProcessBuilder)object2).directory(this.workingDir).start();
            boolean bl3 = false;
            this.executionProcess = process;
            object = object2;
        }
        finally {
            lock.unlock();
        }
        Object process = object;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> HotReloadUnitTestExecutor.launchTest$lambda$4((Process)process)));
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> HotReloadUnitTestExecutor.launchTest$lambda$5((Process)process, processor, testMethodDescriptor), (int)31, null);
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> HotReloadUnitTestExecutor.launchTest$lambda$6((Process)process, processor, testMethodDescriptor), (int)31, null);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> HotReloadUnitTestExecutor.launchTest$lambda$7((Process)process)));
        if (!((Process)process).waitFor(5L, TimeUnit.MINUTES)) {
            Intrinsics.checkNotNull((Object)process);
            ProcessUtilsKt.destroyWithDescendants((Process)process);
            processor.failure(testMethodDescriptor.getId(), TestFailure.fromTestFrameworkFailure((Throwable)new TimeoutException("Test '" + testMethodDescriptor + "' timed out")));
        }
        if (((Process)process).exitValue() != 0) {
            processor.failure(testMethodDescriptor.getId(), TestFailure.fromTestFrameworkFailure((Throwable)new Exception("Test '" + testMethodDescriptor + "' exitCode = " + ((Process)process).exitValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopNow() {
        Lock lock = this.executionProcessLock;
        lock.lock();
        try {
            boolean bl = false;
            Process process = this.executionProcess;
            Boolean bl2 = process != null ? Boolean.valueOf(ProcessUtilsKt.destroyWithDescendants((Process)process)) : null;
        }
        finally {
            lock.unlock();
        }
    }

    private static final void launchTest$lambda$1(Path $applicationClassesDir) {
        Intrinsics.checkNotNull((Object)$applicationClassesDir);
        PathsKt.deleteRecursively((Path)$applicationClassesDir);
    }

    private static final Unit launchTest$lambda$2(TestResultProcessor $processor, MethodDescriptor $testMethodDescriptor, OrchestrationMessage.CriticalException exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        $processor.failure($testMethodDescriptor.getId(), UnitTestFailureKt.createTestFailure(exception));
        return Unit.INSTANCE;
    }

    private static final boolean launchTest$lambda$3$0(File it) {
        return it.exists();
    }

    private static final boolean launchTest$lambda$3$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void launchTest$lambda$4(Process $process) {
        Intrinsics.checkNotNull((Object)$process);
        ProcessUtilsKt.destroyWithDescendants((Process)$process);
    }

    private static final Unit launchTest$lambda$5(Process $process, TestResultProcessor $processor, MethodDescriptor $testMethodDescriptor) {
        InputStream inputStream = $process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        TextStreamsKt.forEachLine((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)), arg_0 -> HotReloadUnitTestExecutor.launchTest$lambda$5$0($processor, $testMethodDescriptor, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit launchTest$lambda$5$0(TestResultProcessor $processor, MethodDescriptor $testMethodDescriptor, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        $processor.output($testMethodDescriptor.getId(), (TestOutputEvent)new DefaultTestOutputEvent(Time.currentTimeMillis(), TestOutputEvent.Destination.StdOut, line + System.lineSeparator()));
        return Unit.INSTANCE;
    }

    private static final Unit launchTest$lambda$6(Process $process, TestResultProcessor $processor, MethodDescriptor $testMethodDescriptor) {
        InputStream inputStream = $process.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        TextStreamsKt.forEachLine((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)), arg_0 -> HotReloadUnitTestExecutor.launchTest$lambda$6$0($processor, $testMethodDescriptor, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit launchTest$lambda$6$0(TestResultProcessor $processor, MethodDescriptor $testMethodDescriptor, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        $processor.output($testMethodDescriptor.getId(), (TestOutputEvent)new DefaultTestOutputEvent(Time.currentTimeMillis(), TestOutputEvent.Destination.StdErr, line + System.lineSeparator()));
        return Unit.INSTANCE;
    }

    private static final void launchTest$lambda$7(Process $process) {
        Intrinsics.checkNotNull((Object)$process);
        ProcessUtilsKt.destroyWithDescendants((Process)$process);
    }
}

