/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.test;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.gradle.ComposeHotReloadAgent;
import org.jetbrains.compose.reload.gradle.DebuggingKt;
import org.jetbrains.compose.reload.gradle.JetbrainsRuntimeKt;
import org.jetbrains.compose.reload.gradle.UtilsKt;
import org.jetbrains.compose.reload.test.HotReloadTestExecutionSpec;
import org.jetbrains.compose.reload.test.HotReloadUnitTestExecutor;
import org.jetbrains.compose.reload.test.HotReloadUnitTestTask;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010-\u001a\u00020.2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030/J\u0014\u00100\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u000102\u0018\u000101H\u0014J\n\u00103\u001a\u0004\u0018\u000102H\u0014R\u001e\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR:\u0010\u000b\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\r0\r \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\u00118AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00020\u00118AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0016\u0010\u0016\u001a\u00020\u00058AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u0016\u0010\u0018\u001a\u00020\u00058AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\bR:\u0010\u001a\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\r0\r \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000fR:\u0010\u001c\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\r0\r \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000fR\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R:\u0010#\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010$0$ \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010$0$\u0018\u00010\u001f0\u001f8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\"R\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001f8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\"R\u0013\u0010)\u001a\u00020*8G\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u00064"}, d2={"Lorg/jetbrains/compose/reload/test/HotReloadUnitTestTask;", "Lorg/gradle/api/tasks/testing/AbstractTestTask;", "<init>", "()V", "compileClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "kotlin.jvm.PlatformType", "getCompileClasspath$gradle_plugin", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "compilePluginClasspath", "getCompilePluginClasspath$gradle_plugin", "moduleName", "Lorg/gradle/api/provider/Property;", "", "getModuleName$gradle_plugin", "()Lorg/gradle/api/provider/Property;", "agentClasspath", "Lorg/gradle/api/file/FileCollection;", "getAgentClasspath$gradle_plugin", "()Lorg/gradle/api/file/FileCollection;", "agentJar", "getAgentJar$gradle_plugin", "classpath", "getClasspath$gradle_plugin", "testClasses", "getTestClasses$gradle_plugin", "className", "getClassName$gradle_plugin", "methodName", "getMethodName$gradle_plugin", "launcher", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "getLauncher$gradle_plugin", "()Lorg/gradle/api/provider/Provider;", "javaExecutable", "Ljava/io/File;", "getJavaExecutable$gradle_plugin", "intellijDebuggerDispatchPort", "", "getIntellijDebuggerDispatchPort$gradle_plugin", "workingDir", "Lorg/gradle/api/file/DirectoryProperty;", "getWorkingDir", "()Lorg/gradle/api/file/DirectoryProperty;", "compilation", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "createTestExecuter", "Lorg/gradle/api/internal/tasks/testing/TestExecuter;", "Lorg/jetbrains/compose/reload/test/HotReloadTestExecutionSpec;", "createTestExecutionSpec", "gradle-plugin"})
public class HotReloadUnitTestTask
extends AbstractTestTask {
    private final ConfigurableFileCollection compileClasspath = this.getProject().getObjects().fileCollection();
    private final ConfigurableFileCollection compilePluginClasspath = this.getProject().getObjects().fileCollection();
    private final Property<String> moduleName = this.getProject().getObjects().property(String.class);
    @NotNull
    private final FileCollection agentClasspath;
    @NotNull
    private final FileCollection agentJar;
    @NotNull
    private final ConfigurableFileCollection classpath;
    @NotNull
    private final ConfigurableFileCollection testClasses;
    private final Property<String> className;
    private final Property<String> methodName;
    @NotNull
    private final Provider<JavaLauncher> launcher;
    private final Provider<File> javaExecutable;
    @NotNull
    private final Provider<Integer> intellijDebuggerDispatchPort;
    @NotNull
    private final DirectoryProperty workingDir;

    public HotReloadUnitTestTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.agentClasspath = ComposeHotReloadAgent.getComposeHotReloadAgentClasspath((Project)project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.agentJar = ComposeHotReloadAgent.getComposeHotReloadAgentJar((Project)project2);
        ConfigurableFileCollection configurableFileCollection = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"fileCollection(...)");
        this.classpath = configurableFileCollection;
        ConfigurableFileCollection configurableFileCollection2 = this.getProject().getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection2, (String)"fileCollection(...)");
        this.testClasses = configurableFileCollection2;
        this.className = this.getProject().getObjects().property(String.class).convention(this.getProject().getProviders().systemProperty("reloadTest.className"));
        this.methodName = this.getProject().getObjects().property(String.class).convention(this.getProject().getProviders().systemProperty("reloadTest.methodName"));
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        this.launcher = JetbrainsRuntimeKt.jetbrainsRuntimeLauncher((Project)project3);
        this.javaExecutable = this.getProject().getProviders().environmentVariable("COMPOSE_RELOAD_JBR_BINARY").map(arg_0 -> HotReloadUnitTestTask.javaExecutable$lambda$0(javaExecutable.1.INSTANCE, arg_0)).orElse(this.launcher.map(arg_0 -> HotReloadUnitTestTask.javaExecutable$lambda$2(HotReloadUnitTestTask::javaExecutable$lambda$1, arg_0)));
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
        this.intellijDebuggerDispatchPort = DebuggingKt.getIntellijDebuggerDispatchPort((Project)project4);
        DirectoryProperty directoryProperty = this.getProject().getObjects().directoryProperty().convention(this.getProject().getLayout().getProjectDirectory());
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"convention(...)");
        this.workingDir = directoryProperty;
    }

    @Classpath
    public final ConfigurableFileCollection getCompileClasspath$gradle_plugin() {
        return this.compileClasspath;
    }

    @Classpath
    public final ConfigurableFileCollection getCompilePluginClasspath$gradle_plugin() {
        return this.compilePluginClasspath;
    }

    @Input
    public final Property<String> getModuleName$gradle_plugin() {
        return this.moduleName;
    }

    @Classpath
    @NotNull
    public final FileCollection getAgentClasspath$gradle_plugin() {
        return this.agentClasspath;
    }

    @Classpath
    @NotNull
    public final FileCollection getAgentJar$gradle_plugin() {
        return this.agentJar;
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getClasspath$gradle_plugin() {
        return this.classpath;
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getTestClasses$gradle_plugin() {
        return this.testClasses;
    }

    @Input
    @Optional
    public final Property<String> getClassName$gradle_plugin() {
        return this.className;
    }

    @Input
    @Optional
    public final Property<String> getMethodName$gradle_plugin() {
        return this.methodName;
    }

    @Nested
    @NotNull
    public final Provider<JavaLauncher> getLauncher$gradle_plugin() {
        return this.launcher;
    }

    @InputFile
    public final Provider<File> getJavaExecutable$gradle_plugin() {
        return this.javaExecutable;
    }

    @Internal
    @NotNull
    public final Provider<Integer> getIntellijDebuggerDispatchPort$gradle_plugin() {
        return this.intellijDebuggerDispatchPort;
    }

    @Internal
    @NotNull
    public final DirectoryProperty getWorkingDir() {
        return this.workingDir;
    }

    public final void compilation(@NotNull KotlinCompilation<?> compilation2) {
        Intrinsics.checkNotNullParameter(compilation2, (String)"compilation");
        Object[] objectArray = new Object[1];
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[0] = UtilsKt.files((Project)project, () -> HotReloadUnitTestTask.compilation$lambda$3(compilation2));
        this.compileClasspath.from(objectArray);
        objectArray = new Object[1];
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        objectArray[0] = UtilsKt.files((Project)project2, () -> HotReloadUnitTestTask.compilation$lambda$4(compilation2));
        this.compileClasspath.from(objectArray);
        String string = compilation2.getRuntimeDependencyConfigurationName();
        if (string == null) {
            throw new IllegalStateException("Missing 'runtimeDependencyConfigurationName'".toString());
        }
        String runtimeDependencyConfigurationName = string;
        Object[] objectArray2 = new Object[]{this.getProject().getConfigurations().getByName(runtimeDependencyConfigurationName)};
        this.classpath.from(objectArray2);
        objectArray2 = new Object[1];
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        objectArray2[0] = UtilsKt.files((Project)project3, () -> HotReloadUnitTestTask.compilation$lambda$5(compilation2));
        this.testClasses.from(objectArray2);
        this.moduleName.set(compilation2.getCompileTaskProvider().flatMap(arg_0 -> HotReloadUnitTestTask.compilation$lambda$6(compilation.4.INSTANCE, arg_0)));
        objectArray2 = new Object[]{compilation2.getCompileTaskProvider().map(arg_0 -> HotReloadUnitTestTask.compilation$lambda$7(compilation.5.INSTANCE, arg_0))};
        this.compilePluginClasspath.from(objectArray2);
    }

    @Nullable
    protected TestExecuter<? extends HotReloadTestExecutionSpec> createTestExecuter() {
        Object object = this.javaExecutable.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        File file = (File)object;
        Object object2 = this.workingDir.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        File file2 = (File)object2;
        FileCollection fileCollection = (FileCollection)this.classpath;
        FileCollection fileCollection2 = (FileCollection)this.testClasses;
        Object object3 = this.moduleName.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        String string = (String)object3;
        ConfigurableFileCollection configurableFileCollection = this.compileClasspath;
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"compileClasspath");
        FileCollection fileCollection3 = (FileCollection)configurableFileCollection;
        ConfigurableFileCollection configurableFileCollection2 = this.compilePluginClasspath;
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection2, (String)"compilePluginClasspath");
        return new HotReloadUnitTestExecutor(file, file2, fileCollection, fileCollection2, this.agentJar, this.agentClasspath, string, fileCollection3, (FileCollection)configurableFileCollection2, (Integer)this.intellijDebuggerDispatchPort.getOrNull());
    }

    @Nullable
    protected HotReloadTestExecutionSpec createTestExecutionSpec() {
        return new HotReloadTestExecutionSpec((String)this.className.getOrNull(), (String)this.methodName.getOrNull());
    }

    private static final File javaExecutable$lambda$0(Function1 $tmp0, Object in) {
        return (File)$tmp0.invoke(in);
    }

    private static final File javaExecutable$lambda$1(JavaLauncher it) {
        return it.getExecutablePath().getAsFile();
    }

    private static final File javaExecutable$lambda$2(Function1 $tmp0, Object in) {
        return (File)$tmp0.invoke(in);
    }

    private static final Object compilation$lambda$3(KotlinCompilation $compilation) {
        return $compilation.getCompileDependencyFiles();
    }

    private static final Object compilation$lambda$4(KotlinCompilation $compilation) {
        return $compilation.getOutput().getClassesDirs();
    }

    private static final Object compilation$lambda$5(KotlinCompilation $compilation) {
        return $compilation.getOutput().getAllOutputs();
    }

    private static final Provider compilation$lambda$6(Function1 $tmp0, Object in) {
        return (Provider)$tmp0.invoke(in);
    }

    private static final Iterable compilation$lambda$7(Function1 $tmp0, Object in) {
        return (Iterable)$tmp0.invoke(in);
    }
}

