/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.jvm.effects;

import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.skia.RuntimeEffect;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "loadRuntimeEffect", "Lorg/jetbrains/skia/RuntimeEffect;", "path", "", "hot-reload-runtime-jvm"})
@SourceDebugExtension(value={"SMAP\nshaderUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 shaderUtils.kt\norg/jetbrains/compose/reload/jvm/effects/ShaderUtilsKt\n+ 2 Try.kt\norg/jetbrains/compose/reload/core/TryKt\n+ 3 Either.kt\norg/jetbrains/compose/reload/core/EitherKt\n+ 4 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,25:1\n16#2,4:26\n38#3,3:30\n22#4:33\n*S KotlinDebug\n*F\n+ 1 shaderUtils.kt\norg/jetbrains/compose/reload/jvm/effects/ShaderUtilsKt\n*L\n18#1:26,4\n21#1:30,3\n15#1:33\n*E\n"})
public final class ShaderUtilsKt {
    @NotNull
    private static final Logger logger;

    @Nullable
    public static final RuntimeEffect loadRuntimeEffect(@NotNull String path) {
        Object object;
        Either either;
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean $i$f$Try = false;
        try {
            boolean bl = false;
            URL uRL2 = MethodHandles.lookup().lookupClass().getClassLoader().getResource(path);
            Intrinsics.checkNotNull((Object)uRL2);
            uRL = uRL2;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
            String text = new String(byArray, charset);
            either = (Either)EitherKt.toLeft((Object)RuntimeEffect.Companion.makeForShader(text));
        }
        catch (Throwable t$iv) {
            either = (Either)EitherKt.toRight((Object)t$iv);
        }
        Either $this$leftOr$iv = either;
        boolean $i$f$leftOr = false;
        uRL = $this$leftOr$iv;
        if (uRL instanceof Left) {
            object = ((Left)$this$leftOr$iv).getValue();
        } else if (uRL instanceof Right) {
            Right e = (Right)$this$leftOr$iv;
            boolean bl = false;
            LoggingKt.error((Logger)logger, (String)("Error loading \"" + path + "\" runtime effect: "), (Throwable)((Throwable)e.getValue()));
            object = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (RuntimeEffect)object;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default((String)string, null, null, (int)6, null);
    }
}

