/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.jvm;

import java.util.UUID;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.agent.ReloadHooksKt;
import org.jetbrains.compose.reload.core.Disposable;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.TryKt;
import org.jetbrains.compose.reload.jvm.InvokeAfterHotReloadException;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"enableInvokeAfterHotReloadStackTrace", "", "invokeAfterHotReload", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "block", "Lkotlin/Function0;", "", "hot-reload-runtime-jvm_dev"})
@JvmName(name="JvmInvokeAfterHotReload")
public final class JvmInvokeAfterHotReload {
    private static final boolean enableInvokeAfterHotReloadStackTrace = Intrinsics.areEqual((Object)System.getProperty("compose.reload.invokeAfterHotReloadStackTraceEnabled"), (Object)"true");

    @NotNull
    public static final AutoCloseable invokeAfterHotReload(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        StackTraceElement[] registrationTrace = enableInvokeAfterHotReloadStackTrace ? Thread.currentThread().getStackTrace() : null;
        Ref.ObjectRef disposable = new Ref.ObjectRef();
        disposable.element = ReloadHooksKt.invokeAfterHotReload((arg_0, arg_1) -> JvmInvokeAfterHotReload.invokeAfterHotReload$lambda$1(block, disposable, registrationTrace, arg_0, arg_1));
        return () -> JvmInvokeAfterHotReload.invokeAfterHotReload$lambda$2(disposable);
    }

    private static final void invokeAfterHotReload$lambda$1$lambda$0(InvokeAfterHotReloadException $exception) {
        throw $exception;
    }

    private static final Unit invokeAfterHotReload$lambda$1(Function0 $block, Ref.ObjectRef $disposable, StackTraceElement[] $registrationTrace, UUID uUID, Either result) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (TryKt.isSuccess((Either)result)) {
            try {
                $block.invoke();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Disposable disposable = (Disposable)$disposable.element;
                if (disposable != null) {
                    disposable.dispose();
                }
            }
            catch (Throwable t) {
                InvokeAfterHotReloadException exception = new InvokeAfterHotReloadException("Exception in 'invokeAfterHotReload' block", t);
                if ($registrationTrace != null) {
                    exception.setStackTrace($registrationTrace);
                }
                SwingUtilities.invokeLater(() -> JvmInvokeAfterHotReload.invokeAfterHotReload$lambda$1$lambda$0(exception));
            }
        }
        return Unit.INSTANCE;
    }

    private static final void invokeAfterHotReload$lambda$2(Ref.ObjectRef $disposable) {
        ((Disposable)$disposable.element).dispose();
    }
}

