/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.jvm;

import androidx.compose.ui.Alignment;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpKt;
import androidx.compose.ui.unit.DpSize;
import androidx.compose.ui.window.WindowPosition;
import androidx.compose.ui.window.WindowPosition_desktopKt;
import androidx.compose.ui.window.WindowState;
import androidx.compose.ui.window.WindowState_desktopKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.encoding.Base64;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.DevelopmentEntryPoint;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a \u0010\t\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"logger", "Lorg/slf4j/Logger;", "persistentWindowState", "Landroidx/compose/ui/window/WindowState;", "annotation", "Lorg/jetbrains/compose/reload/DevelopmentEntryPoint;", "className", "", "functionName", "persistentWindowStateKey", "deserializeWindowState", "path", "Ljava/nio/file/Path;", "serializeWindowState", "", "state", "defaultWindowState", "hot-reload-runtime-jvm_dev"})
@SourceDebugExtension(value={"SMAP\nwindowState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 windowState.kt\norg/jetbrains/compose/reload/jvm/WindowStateKt\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,116:1\n169#2:117\n169#2:118\n125#2:120\n125#2:121\n125#2:122\n125#2:123\n149#2:124\n1#3:119\n15#4:125\n*S KotlinDebug\n*F\n+ 1 windowState.kt\norg/jetbrains/compose/reload/jvm/WindowStateKt\n*L\n88#1:117\n89#1:118\n97#1:120\n98#1:121\n99#1:122\n100#1:123\n114#1:124\n29#1:125\n*E\n"})
public final class WindowStateKt {
    @NotNull
    private static final Logger logger;

    @NotNull
    public static final WindowState persistentWindowState(@NotNull DevelopmentEntryPoint annotation, @NotNull String className, @NotNull String functionName) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        String key = WindowStateKt.persistentWindowStateKey(annotation, className, functionName);
        Path path = HotReloadEnvironment.INSTANCE.getPidFile();
        if (path == null || (path = path.resolveSibling(key + ".windowState")) == null) {
            return WindowStateKt.defaultWindowState(annotation);
        }
        Path windowStateFile = path;
        WindowState windowState = WindowStateKt.deserializeWindowState(windowStateFile);
        if (windowState == null) {
            windowState = WindowStateKt.defaultWindowState(annotation);
        }
        WindowState windowState2 = windowState;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> WindowStateKt.persistentWindowState$lambda$0(windowStateFile, windowState2)));
        return windowState2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String persistentWindowStateKey(DevelopmentEntryPoint annotation, String className, String functionName) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Object object = new DataOutputStream(baos);
        Throwable throwable = null;
        try {
            DataOutputStream dos = (DataOutputStream)object;
            boolean bl = false;
            dos.writeInt(annotation.windowWidth());
            dos.writeInt(annotation.windowHeight());
            dos.writeUTF(className);
            dos.writeUTF(functionName);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        digest.update(baos.toByteArray());
        Base64 base64 = Base64.Default.getUrlSafe();
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        object = byArray;
        int n = 8;
        byte[] byArray2 = Arrays.copyOf((byte[])object, n);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        return Base64.encode$default((Base64)base64, (byte[])byArray2, (int)0, (int)0, (int)6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final WindowState deserializeWindowState(Path path) {
        Object object;
        block9: {
            Object object2;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isRegularFile(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return null;
            }
            try {
                DataInputStream input;
                boolean bl = false;
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                object2 = new DataInputStream(inputStream);
                Throwable throwable = null;
                try {
                    input = (DataInputStream)object2;
                    boolean bl2 = false;
                    input.readUTF();
                    float x = input.readFloat();
                    float y = input.readFloat();
                    float width = input.readFloat();
                    float height = input.readFloat();
                    float $this$dp$iv = x;
                    boolean $i$f$getDp = false;
                    float f = Dp.constructor-impl((float)$this$dp$iv);
                    $this$dp$iv = y;
                    $i$f$getDp = false;
                    WindowPosition windowPosition = (WindowPosition)WindowPosition_desktopKt.WindowPosition-YgX7TsA((float)f, (float)Dp.constructor-impl((float)$this$dp$iv));
                    $this$dp$iv = width;
                    $i$f$getDp = false;
                    float f2 = Dp.constructor-impl((float)$this$dp$iv);
                    $this$dp$iv = height;
                    $i$f$getDp = false;
                    input = WindowState_desktopKt.WindowState-aAmSZ4M$default(null, (boolean)false, (WindowPosition)windowPosition, (long)DpKt.DpSize-YgX7TsA((float)f2, (float)Dp.constructor-impl((float)$this$dp$iv)), (int)3, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
                object = Result.constructor-impl((Object)input);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block9;
            object2 = throwable;
            Throwable exception = object2;
            boolean bl = false;
            logger.error("Failed to deserialize window state", exception);
        }
        return (WindowState)(Result.isFailure-impl((Object)object) ? null : object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void serializeWindowState(Path path, WindowState state) {
        Dp dp = Dp.box-impl((float)state.getPosition().getX-D9Ej5fM());
        float it22 = dp.unbox-impl();
        boolean bl = false;
        float $this$isSpecified$iv = it22;
        boolean bl2 = false;
        Object object = !Float.isNaN($this$isSpecified$iv) ? dp : null;
        if (object == null) {
            return;
        }
        float x = object.unbox-impl();
        Dp it22 = Dp.box-impl((float)state.getPosition().getY-D9Ej5fM());
        float it = it22.unbox-impl();
        boolean bl3 = false;
        float $this$isSpecified$iv2 = it;
        $i$f$isSpecified-0680j_4 = false;
        Object object2 = !Float.isNaN($this$isSpecified$iv2) ? it22 : null;
        if (object2 == null) {
            return;
        }
        float y = object2.unbox-impl();
        Object object3 = Dp.box-impl((float)DpSize.getWidth-D9Ej5fM((long)state.getSize-MYxV2XQ()));
        float it3 = object3.unbox-impl();
        boolean bl4 = false;
        float $this$isSpecified$iv3 = it3;
        $i$f$isSpecified-0680j_4 = false;
        Object object4 = !Float.isNaN($this$isSpecified$iv3) ? object3 : null;
        if (object4 == null) {
            return;
        }
        float width = object4.unbox-impl();
        Object object5 = Dp.box-impl((float)DpSize.getHeight-D9Ej5fM((long)state.getSize-MYxV2XQ()));
        float it4 = object5.unbox-impl();
        boolean bl5 = false;
        float $this$isSpecified$iv4 = it4;
        $i$f$isSpecified-0680j_4 = false;
        Object object6 = !Float.isNaN($this$isSpecified$iv4) ? object5 : null;
        if (object6 == null) {
            return;
        }
        float height = object6.unbox-impl();
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]), Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        object3 = new DataOutputStream(outputStream);
        object5 = null;
        try {
            DataOutputStream dos = (DataOutputStream)object3;
            boolean bl6 = false;
            dos.writeUTF("(x=" + Dp.toString-impl((float)x) + ", y=" + Dp.toString-impl((float)y) + ", width=" + Dp.toString-impl((float)width) + ", height=" + Dp.toString-impl((float)height) + ")");
            dos.writeFloat(x);
            dos.writeFloat(y);
            dos.writeFloat(width);
            dos.writeFloat(height);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object5 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)object5);
        }
    }

    private static final WindowState defaultWindowState(DevelopmentEntryPoint annotation) {
        int $this$dp$iv = annotation.windowWidth();
        boolean $i$f$getDp = false;
        float f = Dp.constructor-impl((float)$this$dp$iv);
        $this$dp$iv = annotation.windowHeight();
        $i$f$getDp = false;
        return WindowState_desktopKt.WindowState-aAmSZ4M$default(null, (boolean)false, (WindowPosition)((WindowPosition)new WindowPosition.Aligned(Alignment.Companion.getTopEnd())), (long)DpKt.DpSize-YgX7TsA((float)f, (float)Dp.constructor-impl((float)$this$dp$iv)), (int)3, null);
    }

    private static final void persistentWindowState$lambda$0(Path $windowStateFile, WindowState $windowState) {
        WindowStateKt.serializeWindowState($windowStateFile, $windowState);
    }

    static {
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        WindowStateKt.logger = logger;
    }
}

