/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.orchestration;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EncodeUtilsKt;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.core.SerializableKt;
import org.jetbrains.compose.reload.core.TryKt;
import org.jetbrains.compose.reload.core.Type;
import org.jetbrains.compose.reload.orchestration.OpaqueOrchestrationMessage;
import org.jetbrains.compose.reload.orchestration.OrchestrationFrame;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessageClassifier;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessageEncoder;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessageId;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessageKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationPackage;
import org.jetbrains.compose.reload.orchestration.OrchestrationPackageType;
import org.jetbrains.compose.reload.orchestration.OrchestrationProtocolVersionKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationVersion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a+\u0010\u0015\u001a\n\u0012\u0004\u0012\u0002H\u0016\u0018\u00010\u0004\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0011H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0018\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\fH\u0000\u001a#\u0010\u001d\u001a\u00020\u001e\"\b\b\u0000\u0010\u0016*\u00020\u001f*\u0002H\u00162\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\u0010\"\u001a\u0016\u0010#\u001a\u00020$*\u00020\u001e2\b\b\u0002\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\f\u0010%\u001a\u00020$*\u00020\u001eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"1\u0010\u0002\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0005*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u00040\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\"7\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0005*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u00040\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\t\u001a\u0004\b\r\u0010\u000e\"A\u0010\u0010\u001a(\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00120\u0011\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0005*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u00040\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\t\u001a\u0004\b\u0013\u0010\u000e\"\u000e\u0010\u001b\u001a\u00020\u001cX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "encoders", "", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessageEncoder;", "kotlin.jvm.PlatformType", "getEncoders", "()Ljava/util/List;", "encoders$delegate", "Lkotlin/Lazy;", "encodersByClassifier", "", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessageClassifier;", "getEncodersByClassifier", "()Ljava/util/Map;", "encodersByClassifier$delegate", "encodersByMessageType", "Lorg/jetbrains/compose/reload/core/Type;", "", "getEncodersByMessageType", "encodersByMessageType$delegate", "messageEncoderOf", "T", "type", "messageEncoderOf-MWpZpg4", "(Ljava/lang/String;)Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessageEncoder;", "classifier", "currentEncodingSchemaVersion", "", "encodeToFrame", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationFrame;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage;", "version", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationVersion;", "(Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage;Lorg/jetbrains/compose/reload/orchestration/OrchestrationVersion;)Lorg/jetbrains/compose/reload/orchestration/OrchestrationFrame;", "decodeOrchestrationMessage", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationPackage;", "decodeSerializableOrchestrationMessage", "hot-reload-orchestration"})
@SourceDebugExtension(value={"SMAP\nOrchestrationMessageEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrchestrationMessageEncoder.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationMessageEncoderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,159:1\n1208#2,2:160\n1236#2,4:162\n1208#2,2:166\n1236#2,4:168\n112#3,4:172\n22#3:176\n*S KotlinDebug\n*F\n+ 1 OrchestrationMessageEncoder.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationMessageEncoderKt\n*L\n61#1:160,2\n61#1:162,4\n65#1:166,2\n65#1:168,4\n131#1:172,4\n27#1:176\n*E\n"})
public final class OrchestrationMessageEncoderKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Lazy encoders$delegate;
    @NotNull
    private static final Lazy encodersByClassifier$delegate;
    @NotNull
    private static final Lazy encodersByMessageType$delegate;
    private static final int currentEncodingSchemaVersion = 1;

    private static final List<OrchestrationMessageEncoder<?>> getEncoders() {
        Lazy lazy = encoders$delegate;
        return (List)lazy.getValue();
    }

    private static final Map<OrchestrationMessageClassifier, OrchestrationMessageEncoder<?>> getEncodersByClassifier() {
        Lazy lazy = encodersByClassifier$delegate;
        return (Map)lazy.getValue();
    }

    private static final Map<Type<? extends Object>, OrchestrationMessageEncoder<?>> getEncodersByMessageType() {
        Lazy lazy = encodersByMessageType$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public static final <T> OrchestrationMessageEncoder<T> messageEncoderOf-MWpZpg4(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$org-jetbrains-compose-reload-core-Type$-type$0");
        return OrchestrationMessageEncoderKt.getEncodersByMessageType().get(Type.box-impl((String)string));
    }

    @Nullable
    public static final OrchestrationMessageEncoder<Object> messageEncoderOf(@NotNull OrchestrationMessageClassifier classifier) {
        Intrinsics.checkNotNullParameter((Object)classifier, (String)"classifier");
        return OrchestrationMessageEncoderKt.getEncodersByClassifier().get(classifier);
    }

    @NotNull
    public static final <T extends OrchestrationMessage> OrchestrationFrame encodeToFrame(@NotNull T $this$encodeToFrame, @NotNull OrchestrationVersion version) {
        Intrinsics.checkNotNullParameter($this$encodeToFrame, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Map<Type<Object>, OrchestrationMessageEncoder<?>> map = OrchestrationMessageEncoderKt.getEncodersByMessageType();
        String string = $this$encodeToFrame.getClass().getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        OrchestrationMessageEncoder<?> encoder = map.get(Type.box-impl((String)Type.constructor-impl((String)string)));
        if (!OrchestrationProtocolVersionKt.getSupportsEncodedMessages(version) || encoder == null) {
            return new OrchestrationFrame(OrchestrationPackageType.JavaSerializableMessage, SerializableKt.encodeSerializableObject((Serializable)$this$encodeToFrame));
        }
        return new OrchestrationFrame(OrchestrationPackageType.Message, EncodeUtilsKt.encodeByteArray$default((int)0, arg_0 -> OrchestrationMessageEncoderKt.encodeToFrame$lambda$0($this$encodeToFrame, encoder, arg_0), (int)1, null));
    }

    @NotNull
    public static final OrchestrationPackage decodeOrchestrationMessage(@NotNull OrchestrationFrame $this$decodeOrchestrationMessage, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeOrchestrationMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if ($this$decodeOrchestrationMessage.getType() != OrchestrationPackageType.Message) {
            LoggingKt.error$default((Logger)logger, (String)("Expected " + OrchestrationPackageType.Message + ", got " + $this$decodeOrchestrationMessage.getType()), null, (int)2, null);
            return new OpaqueOrchestrationMessage($this$decodeOrchestrationMessage);
        }
        Either result = EncodeUtilsKt.tryDecode((byte[])$this$decodeOrchestrationMessage.getData(), arg_0 -> OrchestrationMessageEncoderKt.decodeOrchestrationMessage$lambda$0(logger, arg_0));
        if (TryKt.isFailure((Either)result)) {
            LoggingKt.error((Logger)logger, (String)"Failed to decode encoded message", (Throwable)TryKt.exceptionOrNull((Either)result));
            return new OpaqueOrchestrationMessage($this$decodeOrchestrationMessage);
        }
        OrchestrationMessage orchestrationMessage = (OrchestrationMessage)((Left)result).getValue();
        return orchestrationMessage != null ? (OrchestrationPackage)orchestrationMessage : (OrchestrationPackage)new OpaqueOrchestrationMessage($this$decodeOrchestrationMessage);
    }

    public static /* synthetic */ OrchestrationPackage decodeOrchestrationMessage$default(OrchestrationFrame orchestrationFrame, Logger logger, int n, Object object) {
        if ((n & 1) != 0) {
            logger = OrchestrationMessageEncoderKt.logger;
        }
        return OrchestrationMessageEncoderKt.decodeOrchestrationMessage(orchestrationFrame, logger);
    }

    @NotNull
    public static final OrchestrationPackage decodeSerializableOrchestrationMessage(@NotNull OrchestrationFrame $this$decodeSerializableOrchestrationMessage) {
        OrchestrationPackage orchestrationPackage;
        Intrinsics.checkNotNullParameter((Object)$this$decodeSerializableOrchestrationMessage, (String)"<this>");
        if (!($this$decodeSerializableOrchestrationMessage.getType() == OrchestrationPackageType.JavaSerializableMessage)) {
            boolean $i$a$-require-OrchestrationMessageEncoderKt$decodeSerializableOrchestrationMessage$22 = false;
            String $i$a$-require-OrchestrationMessageEncoderKt$decodeSerializableOrchestrationMessage$22 = "Expected " + OrchestrationPackageType.JavaSerializableMessage + ", got " + $this$decodeSerializableOrchestrationMessage.getType();
            throw new IllegalArgumentException($i$a$-require-OrchestrationMessageEncoderKt$decodeSerializableOrchestrationMessage$22.toString());
        }
        try {
            Object object = SerializableKt.decodeSerializableObject((byte[])$this$decodeSerializableOrchestrationMessage.getData());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.compose.reload.orchestration.OrchestrationMessage");
            orchestrationPackage = (OrchestrationMessage)object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            orchestrationPackage = new OpaqueOrchestrationMessage($this$decodeSerializableOrchestrationMessage);
        }
        return orchestrationPackage;
    }

    private static final List encoders_delegate$lambda$0() {
        ServiceLoader<OrchestrationMessageEncoder> serviceLoader = ServiceLoader.load(OrchestrationMessageEncoder.class, OrchestrationMessageEncoder.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        return CollectionsKt.toList((Iterable)serviceLoader);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map encodersByClassifier_delegate$lambda$0() {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = OrchestrationMessageEncoderKt.getEncoders();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            OrchestrationMessageEncoder orchestrationMessageEncoder = (OrchestrationMessageEncoder)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getMessageClassifier(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map encodersByMessageType_delegate$lambda$0() {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = OrchestrationMessageEncoderKt.getEncoders();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            OrchestrationMessageEncoder orchestrationMessageEncoder = (OrchestrationMessageEncoder)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(Type.box-impl((String)it.getMessageType-cAobLks()), element$iv$iv);
        }
        return destination$iv$iv;
    }

    private static final Unit encodeToFrame$lambda$0(OrchestrationMessage $this_encodeToFrame, OrchestrationMessageEncoder $encoder, DataOutputStream $this$encodeByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeByteArray, (String)"$this$encodeByteArray");
        $this$encodeByteArray.writeShort(1);
        EncodeUtilsKt.writeFrame((DataOutputStream)$this$encodeByteArray, (byte[])$this_encodeToFrame.getMessageId().encodeToByteArray());
        EncodeUtilsKt.writeString((DataOutputStream)$this$encodeByteArray, (String)$encoder.getMessageClassifier().getNamespace$hot_reload_orchestration());
        EncodeUtilsKt.writeString((DataOutputStream)$this$encodeByteArray, (String)$encoder.getMessageClassifier().getType$hot_reload_orchestration());
        EncodeUtilsKt.writeFrame((DataOutputStream)$this$encodeByteArray, (byte[])$encoder.encode($this_encodeToFrame));
        return Unit.INSTANCE;
    }

    private static final OrchestrationMessage decodeOrchestrationMessage$lambda$0(Logger $logger, DataInputStream $this$tryDecode) {
        Intrinsics.checkNotNullParameter((Object)$this$tryDecode, (String)"$this$tryDecode");
        short messageEncodingSchemaVersion = $this$tryDecode.readShort();
        if (messageEncodingSchemaVersion > 1) {
            LoggingKt.error$default((Logger)$logger, (String)("Unknown 'message encoding schema version': " + messageEncodingSchemaVersion + "; Highest known version is 1"), null, (int)2, null);
            return null;
        }
        OrchestrationMessageId messageId = OrchestrationMessageKt.OrchestrationMessageId(EncodeUtilsKt.readFrame((DataInputStream)$this$tryDecode));
        OrchestrationMessageClassifier messageClassifier = new OrchestrationMessageClassifier(EncodeUtilsKt.readString((DataInputStream)$this$tryDecode), EncodeUtilsKt.readString((DataInputStream)$this$tryDecode));
        OrchestrationMessageEncoder<?> encoder = OrchestrationMessageEncoderKt.getEncodersByClassifier().get(messageClassifier);
        if (encoder == null) {
            Logger $this$debug$iv = $logger;
            boolean $i$f$debug = false;
            if ($this$debug$iv.getLevel().compareTo((Enum)Logger.Level.Debug) <= 0) {
                Logger.Level level = Logger.Level.Debug;
                Logger logger = $this$debug$iv;
                boolean bl = false;
                String string = "No encoder/decoder for classifier '" + messageClassifier + "'";
                Logger.DefaultImpls.log$default((Logger)logger, (Logger.Level)level, (String)string, null, (int)4, null);
            }
            return null;
        }
        Object object = TryKt.getOrThrow(encoder.decode(EncodeUtilsKt.readFrame((DataInputStream)$this$tryDecode)));
        OrchestrationMessage message = (OrchestrationMessage)object;
        boolean bl = false;
        message.setMessageId$hot_reload_orchestration(messageId);
        return (OrchestrationMessage)object;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default((String)string, null, null, (int)6, null);
        encoders$delegate = LazyKt.lazy(OrchestrationMessageEncoderKt::encoders_delegate$lambda$0);
        encodersByClassifier$delegate = LazyKt.lazy(OrchestrationMessageEncoderKt::encodersByClassifier_delegate$lambda$0);
        encodersByMessageType$delegate = LazyKt.lazy(OrchestrationMessageEncoderKt::encodersByMessageType_delegate$lambda$0);
    }
}

