/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.orchestration;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.core.MutableState;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.core.State;
import org.jetbrains.compose.reload.core.StateKt;
import org.jetbrains.compose.reload.core.TryKt;
import org.jetbrains.compose.reload.core.Type;
import org.jetbrains.compose.reload.core.Update;
import org.jetbrains.compose.reload.orchestration.Binary;
import org.jetbrains.compose.reload.orchestration.OrchestrationState;
import org.jetbrains.compose.reload.orchestration.OrchestrationStateEncoder;
import org.jetbrains.compose.reload.orchestration.OrchestrationStateEncoderKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationStateId;
import org.jetbrains.compose.reload.orchestration.OrchestrationStateKey;
import org.jetbrains.compose.reload.orchestration.OrchestrationStates;
import org.jetbrains.compose.reload.orchestration.OrchestrationStatesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\n\b\u0000\u0010\u0010*\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00132\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00100\u0014J$\u0010\u000e\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\bJ%\u0010\u0019\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00100\u001bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ.\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00100\u001e\"\n\b\u0000\u0010\u0010*\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0013H\u0096@\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001e2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0006RB\u0010\u0004\u001a6\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070\u0005j\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\n\u001a6\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00070\u0005j\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0007`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\""}, d2={"Lorg/jetbrains/compose/reload/orchestration/OrchestrationServerStates;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationStates;", "<init>", "()V", "encodedStates", "Ljava/util/HashMap;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateId;", "Lorg/jetbrains/compose/reload/core/MutableState;", "Lorg/jetbrains/compose/reload/orchestration/Binary;", "Lkotlin/collections/HashMap;", "decodedStates", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "update", "Lorg/jetbrains/compose/reload/core/Update;", "T", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;", "key", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateKey;", "Lkotlin/Function1;", "", "id", "expectedValue", "newValue", "withLock", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "get", "Lorg/jetbrains/compose/reload/core/State;", "(Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateKey;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getEncodedState", "StateUpdate", "hot-reload-orchestration"})
@SourceDebugExtension(value={"SMAP\nOrchestrationStates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrchestrationStates.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationServerStates\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n384#2,7:191\n384#2,7:198\n384#2,7:205\n384#2,7:212\n384#2,7:220\n384#2,7:227\n1#3:219\n*S KotlinDebug\n*F\n+ 1 OrchestrationStates.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationServerStates\n*L\n52#1:191,7\n53#1:198,7\n70#1:205,7\n78#1:212,7\n93#1:220,7\n101#1:227,7\n*E\n"})
public final class OrchestrationServerStates
implements OrchestrationStates {
    @NotNull
    private final HashMap<OrchestrationStateId<?>, MutableState<Binary>> encodedStates = new HashMap();
    @NotNull
    private final HashMap<OrchestrationStateId<?>, MutableState<Object>> decodedStates = new HashMap();
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends OrchestrationState> Update<T> update(@NotNull OrchestrationStateKey<T> key, @NotNull Function1<? super T, ? extends T> update2) {
        Update update3;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(update2, (String)"update");
        Lock lock = this.lock;
        lock.lock();
        try {
            MutableState decodedState;
            Object currentDecoded;
            Object object;
            void $this$getOrPut$iv;
            Object object2;
            void $this$getOrPut$iv2;
            boolean bl = false;
            OrchestrationStateEncoder<OrchestrationState> orchestrationStateEncoder = OrchestrationStateEncoderKt.encoderOf-MWpZpg4(key.getId().getType-cAobLks());
            if (orchestrationStateEncoder == null) {
                throw new IllegalStateException(("No encoder for '" + Type.toString-impl((String)key.getId().getType-cAobLks()) + "'").toString());
            }
            OrchestrationStateEncoder<OrchestrationState> encoder = orchestrationStateEncoder;
            Map map = this.encodedStates;
            Object key$iv = key.getId();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv2.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                MutableState answer$iv = new MutableState(null);
                $this$getOrPut$iv2.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            MutableState encodedState = (MutableState)object2;
            key$iv = this.decodedStates;
            OrchestrationStateId<T> key$iv2 = key.getId();
            boolean $i$f$getOrPut2 = false;
            Object value$iv2 = $this$getOrPut$iv.get(key$iv2);
            if (value$iv2 == null) {
                boolean bl3 = false;
                MutableState answer$iv = new MutableState(OrchestrationStatesKt.access$getNone$p());
                $this$getOrPut$iv.put(key$iv2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv2;
            }
            Object currentState = Intrinsics.areEqual((Object)(currentDecoded = (decodedState = (MutableState)object).getValue()), (Object)OrchestrationStatesKt.access$getNone$p()) ? key.getDefault() : (OrchestrationState)currentDecoded;
            OrchestrationState nextState = (OrchestrationState)update2.invoke(currentState);
            Binary nextStateEncoded = new Binary(encoder.encode(nextState));
            encodedState.update(arg_0 -> OrchestrationServerStates.update$lambda$4$lambda$2(nextStateEncoded, arg_0));
            decodedState.update(arg_0 -> OrchestrationServerStates.update$lambda$4$lambda$3(nextState, arg_0));
            update3 = new Update(currentState, (Object)nextState);
        }
        finally {
            lock.unlock();
        }
        return update3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean update(@NotNull OrchestrationStateId<?> id, @Nullable Binary expectedValue, @NotNull Binary newValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl2;
            MutableState encodedState;
            Object object;
            void $this$getOrPut$iv;
            boolean bl3 = false;
            Map map = this.encodedStates;
            OrchestrationStateId<?> key$iv = id;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl4 = false;
                MutableState answer$iv = new MutableState(null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            if (!Intrinsics.areEqual((Object)(encodedState = (MutableState)object).getValue(), (Object)expectedValue)) {
                bl2 = false;
            } else {
                encodedState.update(arg_0 -> OrchestrationServerStates.update$lambda$10$lambda$6(newValue, arg_0));
                OrchestrationStateEncoder orchestrationStateEncoder = OrchestrationStateEncoderKt.encoderOf-MWpZpg4(id.getType-cAobLks());
                if (orchestrationStateEncoder != null) {
                    OrchestrationStateEncoder encoder = orchestrationStateEncoder;
                    boolean bl5 = false;
                    Either decode = encoder.decode(newValue.getBytes());
                    if (TryKt.isSuccess(decode)) {
                        Object object2;
                        void $this$getOrPut$iv2;
                        Map map2 = this.decodedStates;
                        OrchestrationStateId<?> key$iv2 = id;
                        boolean $i$f$getOrPut2 = false;
                        Object value$iv2 = $this$getOrPut$iv2.get(key$iv2);
                        if (value$iv2 == null) {
                            boolean bl6 = false;
                            MutableState answer$iv = new MutableState(OrchestrationStatesKt.access$getNone$p());
                            $this$getOrPut$iv2.put(key$iv2, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv2;
                        }
                        ((MutableState)object2).update(arg_0 -> OrchestrationServerStates.update$lambda$10$lambda$9$lambda$8(decode, arg_0));
                    } else {
                        LoggingKt.error((Logger)OrchestrationStatesKt.access$getLogger$p(), (String)("Failed to decode state '" + id + "'"), (Throwable)TryKt.getException((Right)((Right)decode)));
                    }
                }
                bl2 = true;
            }
            bl = bl2;
        }
        finally {
            lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withLock(@NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$withLock = false;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            object = action.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            lock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public <T extends OrchestrationState> Object get(@NotNull OrchestrationStateKey<T> key, @NotNull Continuation<? super State<T>> $completion) {
        State state;
        Lock lock = this.lock;
        lock.lock();
        try {
            Object object;
            void $this$getOrPut$iv;
            boolean bl = false;
            Map map = this.decodedStates;
            OrchestrationStateId<T> key$iv = key.getId();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                MutableState answer$iv = new MutableState(OrchestrationStatesKt.access$getNone$p());
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            MutableState decodedState = (MutableState)object;
            state = StateKt.map((State)((State)decodedState), arg_0 -> OrchestrationServerStates.get$lambda$14$lambda$13(key, arg_0));
        }
        finally {
            lock.unlock();
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final State<Binary> getEncodedState(@NotNull OrchestrationStateId<?> id) {
        MutableState mutableState;
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Lock lock = this.lock;
        lock.lock();
        try {
            Object object;
            void $this$getOrPut$iv;
            boolean bl = false;
            Map map = this.encodedStates;
            OrchestrationStateId<?> key$iv = id;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                MutableState answer$iv = new MutableState(null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            mutableState = (MutableState)object;
        }
        finally {
            lock.unlock();
        }
        return (State)mutableState;
    }

    private static final Binary update$lambda$4$lambda$2(Binary $nextStateEncoded, Binary it) {
        return $nextStateEncoded;
    }

    private static final Object update$lambda$4$lambda$3(OrchestrationState $nextState, Object it) {
        return $nextState;
    }

    private static final Binary update$lambda$10$lambda$6(Binary $newValue, Binary it) {
        return $newValue;
    }

    private static final Object update$lambda$10$lambda$9$lambda$8(Either $decode, Object it) {
        return ((Left)$decode).getValue();
    }

    private static final OrchestrationState get$lambda$14$lambda$13(OrchestrationStateKey $key, Object value) {
        return Intrinsics.areEqual((Object)value, (Object)OrchestrationStatesKt.access$getNone$p()) ? $key.getDefault() : (OrchestrationState)value;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B7\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000e\u0010\u0017\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0018\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003JN\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\b\b\u0002\u0010\u0006\u001a\u00028\u00002\b\b\u0002\u0010\u0007\u001a\u00028\u00002\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006$"}, d2={"Lorg/jetbrains/compose/reload/orchestration/OrchestrationServerStates$StateUpdate;", "T", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;", "", "id", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateId;", "previousState", "updatedState", "previousStateEncoded", "Lorg/jetbrains/compose/reload/orchestration/Binary;", "updatedStateEncoded", "<init>", "(Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateId;Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;Lorg/jetbrains/compose/reload/orchestration/Binary;Lorg/jetbrains/compose/reload/orchestration/Binary;)V", "getId", "()Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateId;", "getPreviousState", "()Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;", "getUpdatedState", "getPreviousStateEncoded", "()Lorg/jetbrains/compose/reload/orchestration/Binary;", "getUpdatedStateEncoded", "component1", "component2", "component3", "component4", "component5", "copy", "(Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateId;Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;Lorg/jetbrains/compose/reload/orchestration/Binary;Lorg/jetbrains/compose/reload/orchestration/Binary;)Lorg/jetbrains/compose/reload/orchestration/OrchestrationServerStates$StateUpdate;", "equals", "", "other", "hashCode", "", "toString", "", "hot-reload-orchestration"})
    public static final class StateUpdate<T extends OrchestrationState> {
        @NotNull
        private final OrchestrationStateId<T> id;
        private final T previousState;
        private final T updatedState;
        @Nullable
        private final Binary previousStateEncoded;
        @NotNull
        private final Binary updatedStateEncoded;

        public StateUpdate(@NotNull OrchestrationStateId<T> id, T previousState, T updatedState, @Nullable Binary previousStateEncoded, @NotNull Binary updatedStateEncoded) {
            Intrinsics.checkNotNullParameter(id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)updatedStateEncoded, (String)"updatedStateEncoded");
            this.id = id;
            this.previousState = previousState;
            this.updatedState = updatedState;
            this.previousStateEncoded = previousStateEncoded;
            this.updatedStateEncoded = updatedStateEncoded;
        }

        @NotNull
        public final OrchestrationStateId<T> getId() {
            return this.id;
        }

        public final T getPreviousState() {
            return this.previousState;
        }

        public final T getUpdatedState() {
            return this.updatedState;
        }

        @Nullable
        public final Binary getPreviousStateEncoded() {
            return this.previousStateEncoded;
        }

        @NotNull
        public final Binary getUpdatedStateEncoded() {
            return this.updatedStateEncoded;
        }

        @NotNull
        public final OrchestrationStateId<T> component1() {
            return this.id;
        }

        public final T component2() {
            return this.previousState;
        }

        public final T component3() {
            return this.updatedState;
        }

        @Nullable
        public final Binary component4() {
            return this.previousStateEncoded;
        }

        @NotNull
        public final Binary component5() {
            return this.updatedStateEncoded;
        }

        @NotNull
        public final StateUpdate<T> copy(@NotNull OrchestrationStateId<T> id, T previousState, T updatedState, @Nullable Binary previousStateEncoded, @NotNull Binary updatedStateEncoded) {
            Intrinsics.checkNotNullParameter(id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)updatedStateEncoded, (String)"updatedStateEncoded");
            return new StateUpdate<T>(id, previousState, updatedState, previousStateEncoded, updatedStateEncoded);
        }

        public static /* synthetic */ StateUpdate copy$default(StateUpdate stateUpdate, OrchestrationStateId orchestrationStateId, OrchestrationState orchestrationState, OrchestrationState orchestrationState2, Binary binary, Binary binary2, int n, Object object) {
            if ((n & 1) != 0) {
                orchestrationStateId = stateUpdate.id;
            }
            if ((n & 2) != 0) {
                orchestrationState = stateUpdate.previousState;
            }
            if ((n & 4) != 0) {
                orchestrationState2 = stateUpdate.updatedState;
            }
            if ((n & 8) != 0) {
                binary = stateUpdate.previousStateEncoded;
            }
            if ((n & 0x10) != 0) {
                binary2 = stateUpdate.updatedStateEncoded;
            }
            return stateUpdate.copy(orchestrationStateId, orchestrationState, orchestrationState2, binary, binary2);
        }

        @NotNull
        public String toString() {
            return "StateUpdate(id=" + this.id + ", previousState=" + this.previousState + ", updatedState=" + this.updatedState + ", previousStateEncoded=" + this.previousStateEncoded + ", updatedStateEncoded=" + this.updatedStateEncoded + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + (this.previousState == null ? 0 : this.previousState.hashCode());
            result = result * 31 + (this.updatedState == null ? 0 : this.updatedState.hashCode());
            result = result * 31 + (this.previousStateEncoded == null ? 0 : this.previousStateEncoded.hashCode());
            result = result * 31 + this.updatedStateEncoded.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StateUpdate)) {
                return false;
            }
            StateUpdate stateUpdate = (StateUpdate)other;
            if (!Intrinsics.areEqual(this.id, stateUpdate.id)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.previousState, stateUpdate.previousState)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.updatedState, stateUpdate.updatedState)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.previousStateEncoded, (Object)stateUpdate.previousStateEncoded)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.updatedStateEncoded, (Object)stateUpdate.updatedStateEncoded);
        }
    }
}

