/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.test.gradle;

import java.awt.image.BufferedImage;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.InternalHotReloadApi;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Codec;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.RuntimeEffect;
import org.jetbrains.skia.RuntimeShaderBuilder;
import org.jetbrains.skiko.Convertors_jvmKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a#\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\b\u0006\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0001H\u0002\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\u001a*\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00012\b\b\u0002\u0010\u0016\u001a\u00020\r2\b\b\u0002\u0010\u0017\u001a\u00020\u0011\u001a\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0011H\u0003\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020\u001f\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020 \u001a\u0012\u0010!\u001a\u00020\u0005*\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0001\"\u0016\u0010\f\u001a\u00020\r8\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u000f\"\u0016\u0010\u0010\u001a\u00020\u00118\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u000f\"*\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001a0\u0019j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001a`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"withPaint", "Lorg/jetbrains/skia/Image;", "paint", "Lorg/jetbrains/skia/Paint;", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "toBufferedImage", "Ljava/awt/image/BufferedImage;", "diff", "first", "second", "COMPARE_DEFAULT_COLOR_TOLERANCE", "", "getCOMPARE_DEFAULT_COLOR_TOLERANCE$annotations", "()V", "COMPARE_DEFAULT_RADIUS", "", "getCOMPARE_DEFAULT_RADIUS$annotations", "compare", "expect", "actual", "colorTolerance", "radius", "compareShaders", "Ljava/util/HashMap;", "Lorg/jetbrains/skia/RuntimeEffect;", "Lkotlin/collections/HashMap;", "compareShader", "newCompareShader", "readImage", "Ljava/nio/file/Path;", "", "writeImage", "image", "gradle-testFixtures"})
@SourceDebugExtension(value={"SMAP\nskikoUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 skikoUtils.kt\norg/jetbrains/compose/reload/test/gradle/SkikoUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,204:1\n1#2:205\n382#3,7:206\n*S KotlinDebug\n*F\n+ 1 skikoUtils.kt\norg/jetbrains/compose/reload/test/gradle/SkikoUtilsKt\n*L\n132#1:206,7\n*E\n"})
public final class SkikoUtilsKt {
    public static final float COMPARE_DEFAULT_COLOR_TOLERANCE = 0.01f;
    public static final int COMPARE_DEFAULT_RADIUS = 3;
    @NotNull
    private static final HashMap<Integer, RuntimeEffect> compareShaders = new HashMap();

    @NotNull
    public static final Image withPaint(@NotNull Image $this$withPaint, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)$this$withPaint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Bitmap resultBitmap = new Bitmap();
        Bitmap.allocN32Pixels$default((Bitmap)resultBitmap, (int)$this$withPaint.getWidth(), (int)$this$withPaint.getHeight(), (boolean)false, (int)4, null);
        Canvas resultCanvas = new Canvas(resultBitmap, null, 2, null);
        resultCanvas.drawImage($this$withPaint, 0.0f, 0.0f, paint);
        resultCanvas.close();
        return Image.Companion.makeFromBitmap(resultBitmap);
    }

    @NotNull
    public static final Image withPaint(@NotNull Image $this$withPaint, @NotNull Function1<? super Paint, Unit> paint) {
        Intrinsics.checkNotNullParameter((Object)$this$withPaint, (String)"<this>");
        Intrinsics.checkNotNullParameter(paint, (String)"paint");
        Paint paint2 = new Paint();
        paint.invoke((Object)paint2);
        return SkikoUtilsKt.withPaint($this$withPaint, paint2);
    }

    private static final BufferedImage toBufferedImage(Image $this$toBufferedImage) {
        return Convertors_jvmKt.toBufferedImage((Bitmap)Bitmap.Companion.makeFromImage($this$toBufferedImage));
    }

    @NotNull
    public static final Image diff(@NotNull Image first, @NotNull Image second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        String diffShader = "uniform shader a;\nuniform shader b;\n\nhalf4 main(float2 coord) {\n    half4 aColor = a.eval(coord);\n    half4 bColor = b.eval(coord);\n    return half4(abs(aColor.r - bColor.r), abs(aColor.g - bColor.g), abs(aColor.b - bColor.b), 1.0);\n}";
        RuntimeShaderBuilder shaderBuilder = new RuntimeShaderBuilder(RuntimeEffect.Companion.makeForShader(diffShader));
        shaderBuilder.child("a", Image.makeShader$default((Image)first, null, null, null, null, (int)15, null));
        shaderBuilder.child("b", Image.makeShader$default((Image)second, null, null, null, null, (int)15, null));
        Bitmap resultBitmap = new Bitmap();
        Bitmap.allocN32Pixels$default((Bitmap)resultBitmap, (int)first.getWidth(), (int)first.getHeight(), (boolean)false, (int)4, null);
        Canvas resultCanvas = new Canvas(resultBitmap, null, 2, null);
        Paint paint = new Paint();
        paint.setShader(RuntimeShaderBuilder.makeShader$default((RuntimeShaderBuilder)shaderBuilder, null, (int)1, null));
        resultCanvas.drawPaint(paint);
        resultCanvas.close();
        return Image.Companion.makeFromBitmap(resultBitmap);
    }

    @InternalHotReloadApi
    public static /* synthetic */ void getCOMPARE_DEFAULT_COLOR_TOLERANCE$annotations() {
    }

    @InternalHotReloadApi
    public static /* synthetic */ void getCOMPARE_DEFAULT_RADIUS$annotations() {
    }

    @NotNull
    public static final Image compare(@NotNull Image expect, @NotNull Image actual, float colorTolerance, int radius) {
        Intrinsics.checkNotNullParameter((Object)expect, (String)"expect");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        int width = expect.getWidth();
        if (!(actual.getWidth() == width)) {
            boolean $i$a$-require-SkikoUtilsKt$compare$32 = false;
            String $i$a$-require-SkikoUtilsKt$compare$32 = "actual image width must be equal to expect image width";
            throw new IllegalArgumentException($i$a$-require-SkikoUtilsKt$compare$32.toString());
        }
        int height = expect.getHeight();
        if (!(actual.getHeight() == height)) {
            boolean $i$a$-require-SkikoUtilsKt$compare$42 = false;
            String $i$a$-require-SkikoUtilsKt$compare$42 = "actual image height must be equal to expect image height";
            throw new IllegalArgumentException($i$a$-require-SkikoUtilsKt$compare$42.toString());
        }
        RuntimeShaderBuilder builder = new RuntimeShaderBuilder(SkikoUtilsKt.compareShader(radius));
        builder.uniform("size", (float)expect.getWidth(), (float)expect.getHeight());
        builder.child("expect", Image.makeShader$default((Image)expect, null, null, null, null, (int)15, null));
        builder.child("actual", Image.makeShader$default((Image)actual, null, null, null, null, (int)15, null));
        builder.uniform("colorTolerance", colorTolerance);
        Bitmap resultBitmap = new Bitmap();
        Bitmap.allocN32Pixels$default((Bitmap)resultBitmap, (int)width, (int)height, (boolean)false, (int)4, null);
        Canvas resultCanvas = new Canvas(resultBitmap, null, 2, null);
        Paint paint = new Paint();
        paint.setShader(RuntimeShaderBuilder.makeShader$default((RuntimeShaderBuilder)builder, null, (int)1, null));
        resultCanvas.drawPaint(paint);
        resultCanvas.close();
        return Image.Companion.makeFromBitmap(resultBitmap);
    }

    public static /* synthetic */ Image compare$default(Image image, Image image2, float f, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            f = 0.01f;
        }
        if ((n2 & 8) != 0) {
            n = 3;
        }
        return SkikoUtilsKt.compare(image, image2, f, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final RuntimeEffect compareShader(int radius) {
        Object object;
        void $this$getOrPut$iv;
        Map map = compareShaders;
        Integer key$iv = radius;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            RuntimeEffect answer$iv = SkikoUtilsKt.newCompareShader(radius);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (RuntimeEffect)object;
    }

    @Language(value="GLSL")
    private static final RuntimeEffect newCompareShader(int radius) {
        return RuntimeEffect.Companion.makeForShader(StringsKt.trimIndent((String)("\n    uniform float2 size;\n    uniform shader expect;\n    uniform shader actual;\n    uniform float colorTolerance;\n    const int radius = " + radius + ";\n    \n    half4 main(float2 coord) {\n        half4 actualColor = actual.eval(coord);\n        \n        half4 lowerBound = actualColor - colorTolerance;\n        half4 upperBound = actualColor + colorTolerance;\n        \n        half4 lowColor = half4(1.0, 1.0, 1.0, 1.0);\n        half4 highColor = half4(0.0, 0.0, 0.0, 1.0);\n        \n        for(int dx = -radius; dx <= radius; dx++) {\n            for(int dy  = -radius; dy <= radius; dy++) {\n                float2 targetCoord = coord + half2(dx, dy);\n                if(targetCoord.x <= 0 || targetCoord.x >= size.x || targetCoord.y <= 0 || targetCoord.y >= size.y) {\n                    continue;\n                }\n                \n                half4 expectColor = expect.eval(targetCoord);\n                \n                lowColor = half4(\n                    min(lowColor.r, expectColor.r),\n                    min(lowColor.g, expectColor.g),\n                    min(lowColor.b, expectColor.b),\n                    min(lowColor.a, expectColor.a)\n                );\n                \n                highColor = half4(\n                    max(highColor.r, expectColor.r),\n                    max(highColor.g, expectColor.g),\n                    max(highColor.b, expectColor.b),\n                    max(highColor.a, expectColor.a)\n                );\n                \n                if(all(greaterThanEqual(highColor, lowerBound)) && all(lessThanEqual(lowColor, upperBound))) {\n                    return half4(0, 0, 0, 1.0);\n                }\n            }\n        }\n\n        return half4(1.0, 1.0, 1.0, 1.0);\n    }\n")));
    }

    @NotNull
    public static final Image readImage(@NotNull Path $this$readImage) {
        Intrinsics.checkNotNullParameter((Object)$this$readImage, (String)"<this>");
        byte[] byArray = Files.readAllBytes($this$readImage);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        return SkikoUtilsKt.readImage(byArray);
    }

    @NotNull
    public static final Image readImage(@NotNull byte[] $this$readImage) {
        Intrinsics.checkNotNullParameter((Object)$this$readImage, (String)"<this>");
        Codec codec = Codec.Companion.makeFromData(Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])$this$readImage, (int)0, (int)0, (int)6, null));
        Bitmap bitmap = new Bitmap();
        Bitmap.allocN32Pixels$default((Bitmap)bitmap, (int)codec.getWidth(), (int)codec.getHeight(), (boolean)false, (int)4, null);
        codec.readPixels(bitmap);
        return Image.Companion.makeFromBitmap(bitmap);
    }

    public static final void writeImage(@NotNull Path $this$writeImage, @NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)$this$writeImage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Data data = Image.encodeToData$default((Image)image, null, (int)0, (int)3, null);
        Intrinsics.checkNotNull((Object)data);
        OpenOption[] openOptionArray = new OpenOption[]{};
        Files.write($this$writeImage, data.getBytes(), Arrays.copyOf(openOptionArray, openOptionArray.length));
    }
}

