/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.test.gradle;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.core.Future;
import org.jetbrains.compose.reload.core.FutureKt;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.jetbrains.compose.reload.core.HotReloadProperty;
import org.jetbrains.compose.reload.orchestration.OrchestrationServer;
import org.jetbrains.compose.reload.orchestration.OrchestrationServerKt;
import org.jetbrains.compose.reload.test.gradle.Debug;
import org.jetbrains.compose.reload.test.gradle.GradleRunner;
import org.jetbrains.compose.reload.test.gradle.Headless;
import org.jetbrains.compose.reload.test.gradle.HotReloadTestFixture;
import org.jetbrains.compose.reload.test.gradle.HotReloadTestFixtureExtensionKt;
import org.jetbrains.compose.reload.test.gradle.HotReloadTestFixtureShutdownHook;
import org.jetbrains.compose.reload.test.gradle.HotReloadTestInvocationContext;
import org.jetbrains.compose.reload.test.gradle.HotReloadTestInvocationContextKt;
import org.jetbrains.compose.reload.test.gradle.JunitUtilsKt;
import org.jetbrains.compose.reload.test.gradle.OrchestrationTestLoggingKt;
import org.jetbrains.compose.reload.test.gradle.ProjectDir;
import org.jetbrains.compose.reload.test.gradle.ProjectSetupKt;
import org.jetbrains.compose.reload.test.gradle.ReloadEffects;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\u0018B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000bH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u000bH\u0002J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/compose/reload/test/gradle/HotReloadTestFixtureExtension;", "Lorg/junit/jupiter/api/extension/ParameterResolver;", "Lorg/junit/jupiter/api/extension/BeforeEachCallback;", "Lorg/junit/jupiter/api/extension/AfterEachCallback;", "Lorg/junit/jupiter/api/extension/BeforeTestExecutionCallback;", "context", "Lorg/jetbrains/compose/reload/test/gradle/HotReloadTestInvocationContext;", "<init>", "(Lorg/jetbrains/compose/reload/test/gradle/HotReloadTestInvocationContext;)V", "beforeEach", "", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "afterEach", "beforeTestExecution", "supportsParameter", "", "parameterContext", "Lorg/junit/jupiter/api/extension/ParameterContext;", "extensionContext", "resolveParameter", "", "getOrCreateTestFixture", "Lorg/jetbrains/compose/reload/test/gradle/HotReloadTestFixture;", "createTestFixture", "Companion", "gradle-testFixtures"})
@SourceDebugExtension(value={"SMAP\nHotReloadTestFixtureExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotReloadTestFixtureExtension.kt\norg/jetbrains/compose/reload/test/gradle/HotReloadTestFixtureExtension\n+ 2 annotationUtils.kt\norg/jetbrains/compose/reload/test/gradle/AnnotationUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n23#2:126\n13#2,2:127\n13#2,2:129\n13#2,2:131\n1#3:133\n*S KotlinDebug\n*F\n+ 1 HotReloadTestFixtureExtension.kt\norg/jetbrains/compose/reload/test/gradle/HotReloadTestFixtureExtension\n*L\n71#1:126\n71#1:127,2\n85#1:129,2\n86#1:131,2\n*E\n"})
public final class HotReloadTestFixtureExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback,
BeforeTestExecutionCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HotReloadTestInvocationContext context;
    @NotNull
    public static final String TEST_FIXTURE_KEY = "hotReloadTestFixture";

    public HotReloadTestFixtureExtension(@NotNull HotReloadTestInvocationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public void beforeEach(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HotReloadTestInvocationContextKt.setHotReloadTestInvocationContext(context, this.context);
        this.getOrCreateTestFixture(context);
    }

    public void afterEach(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HotReloadTestFixtureExtensionKt.getHotReloadTestFixtureOrThrow(context).close();
    }

    public void beforeTestExecution(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ProjectSetupKt.setupProject(this.getOrCreateTestFixture(context), context);
    }

    public boolean supportsParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter((Object)parameterContext, (String)"parameterContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        Object[] objectArray = new Class[]{HotReloadTestFixture.class, GradleRunner.class, ProjectDir.class};
        return CollectionsKt.listOf((Object[])objectArray).contains(parameterContext.getParameter().getType());
    }

    @NotNull
    public Object resolveParameter(@NotNull ParameterContext parameterContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter((Object)parameterContext, (String)"parameterContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        if (!Intrinsics.areEqual(parameterContext.getParameter().getType(), HotReloadTestFixture.class)) {
            throw new IllegalArgumentException("Unknown type: " + parameterContext.getParameter().getType());
        }
        return HotReloadTestFixtureExtensionKt.getHotReloadTestFixtureOrThrow(extensionContext);
    }

    private final HotReloadTestFixture getOrCreateTestFixture(ExtensionContext $this$getOrCreateTestFixture) {
        Object object = $this$getOrCreateTestFixture.getStore(JunitUtilsKt.getNamespace()).getOrComputeIfAbsent((Object)TEST_FIXTURE_KEY, arg_0 -> HotReloadTestFixtureExtension.getOrCreateTestFixture$lambda$0(this, $this$getOrCreateTestFixture, arg_0), HotReloadTestFixture.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrComputeIfAbsent(...)");
        return (HotReloadTestFixture)object;
    }

    private final HotReloadTestFixture createTestFixture(ExtensionContext $this$createTestFixture) {
        String string;
        ExtensionContext $this$hasAnnotation$iv = $this$createTestFixture;
        boolean $i$f$hasAnnotation = false;
        ExtensionContext $this$findAnnotation$iv$iv = $this$hasAnnotation$iv;
        boolean $i$f$findAnnotation = false;
        Optional optional = AnnotationUtils.findAnnotation((Optional)$this$findAnnotation$iv$iv.getTestMethod(), Debug.class);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findAnnotation(...)");
        Annotation annotation = (Annotation)OptionalsKt.getOrNull((Optional)optional);
        if (annotation == null) {
            Optional optional2 = AnnotationUtils.findAnnotation((Optional)$this$findAnnotation$iv$iv.getTestClass(), Debug.class);
            Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"findAnnotation(...)");
            annotation = (Annotation)OptionalsKt.getOrNull((Optional)optional2);
        }
        boolean debugAnnotation = annotation != null;
        Path path = Files.createTempDirectory("hot-reload-test", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        ProjectDir projectDir = new ProjectDir(path, null, 2, null);
        if (!((Collection)PathsKt.listDirectoryEntries$default((Path)projectDir.getPath(), null, (int)1, null)).isEmpty()) {
            throw new IllegalStateException((projectDir.getPath() + ": is not empty").toString());
        }
        HotReloadTestFixtureShutdownHook.INSTANCE.invokeOnShutdown((Function0<Unit>)((Function0)() -> HotReloadTestFixtureExtension.createTestFixture$lambda$0(projectDir)));
        OrchestrationServer orchestrationServer = OrchestrationServerKt.startOrchestrationServer();
        OrchestrationTestLoggingKt.startOrchestrationTestLogging($this$createTestFixture, orchestrationServer);
        ExtensionContext $this$findAnnotation$iv = $this$createTestFixture;
        boolean $i$f$findAnnotation2 = false;
        Optional optional3 = AnnotationUtils.findAnnotation((Optional)$this$findAnnotation$iv.getTestMethod(), Headless.class);
        Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"findAnnotation(...)");
        Annotation annotation2 = (Annotation)OptionalsKt.getOrNull((Optional)optional3);
        if (annotation2 == null) {
            Optional optional4 = AnnotationUtils.findAnnotation((Optional)$this$findAnnotation$iv.getTestClass(), Headless.class);
            Intrinsics.checkNotNullExpressionValue((Object)optional4, (String)"findAnnotation(...)");
            annotation2 = (Annotation)OptionalsKt.getOrNull((Optional)optional4);
        }
        Headless headless = (Headless)annotation2;
        boolean isHeadless = headless != null ? headless.isHeadless() : true;
        ExtensionContext $this$findAnnotation$iv2 = $this$createTestFixture;
        boolean $i$f$findAnnotation3 = false;
        Optional optional5 = AnnotationUtils.findAnnotation((Optional)$this$findAnnotation$iv2.getTestMethod(), ReloadEffects.class);
        Intrinsics.checkNotNullExpressionValue((Object)optional5, (String)"findAnnotation(...)");
        Annotation annotation3 = (Annotation)OptionalsKt.getOrNull((Optional)optional5);
        if (annotation3 == null) {
            Optional optional6 = AnnotationUtils.findAnnotation((Optional)$this$findAnnotation$iv2.getTestClass(), ReloadEffects.class);
            Intrinsics.checkNotNullExpressionValue((Object)optional6, (String)"findAnnotation(...)");
            annotation3 = (Annotation)OptionalsKt.getOrNull((Optional)optional6);
        }
        ReloadEffects reloadEffects = (ReloadEffects)annotation3;
        boolean effectsEnabled = reloadEffects != null ? reloadEffects.isEnabled() : false;
        Object[] objectArray = new String[5];
        objectArray[0] = "-P" + HotReloadProperty.OrchestrationPort.getKey() + "=" + FutureKt.getBlocking((Future)orchestrationServer.getPort());
        objectArray[1] = "-P" + HotReloadProperty.IsHeadless.getKey() + "=" + isHeadless;
        objectArray[2] = "-P" + HotReloadProperty.LogLevel.getKey() + "=Debug";
        objectArray[3] = "-P" + HotReloadProperty.ReloadEffectsEnabled.getKey() + "=" + effectsEnabled;
        String string2 = string = "--offline";
        int n = 4;
        Object[] objectArray2 = objectArray;
        String string3 = this.context.getGradleVersion().getVersion();
        Path path2 = projectDir.getPath();
        boolean bl = false;
        boolean bl2 = HotReloadEnvironment.INSTANCE.getGradleOfflineMode();
        objectArray2[n] = bl2 ? string : null;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 8;
        Channel channel = ChannelKt.Channel$default((int)0, null, null, (int)7, null);
        Channel channel2 = ChannelKt.Channel$default((int)0, null, null, (int)7, null);
        Path path3 = null;
        List list = CollectionsKt.listOfNotNull((Object[])objectArray);
        String string4 = string3;
        Path path4 = path2;
        GradleRunner gradleRunner = new GradleRunner(path4, string4, list, path3, channel2, channel, n2, defaultConstructorMarker);
        String string5 = ((Class)$this$createTestFixture.getTestClass().get()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
        String string6 = ((Method)$this$createTestFixture.getTestMethod().get()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
        return new HotReloadTestFixture(string5, string6, projectDir, gradleRunner, orchestrationServer, this.context.getProjectMode(), this.context.getLaunchMode(), this.context.getBuildMode(), debugAnnotation, this.context.getKotlinVersion(), this.context.getComposeVersion(), this.context.getGradleVersion());
    }

    private static final HotReloadTestFixture getOrCreateTestFixture$lambda$0(HotReloadTestFixtureExtension this$0, ExtensionContext $this_getOrCreateTestFixture, String it) {
        return this$0.createTestFixture($this_getOrCreateTestFixture);
    }

    private static final Unit createTestFixture$lambda$0(ProjectDir $projectDir) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists($projectDir.getPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            File file = $projectDir.getPath().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            FilesKt.deleteRecursively((File)file);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/compose/reload/test/gradle/HotReloadTestFixtureExtension$Companion;", "", "<init>", "()V", "TEST_FIXTURE_KEY", "", "gradle-testFixtures"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

