/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.test.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.test.core.AppClasspath;
import org.jetbrains.compose.reload.test.gradle.DependencyFinder;
import org.jetbrains.compose.reload.test.gradle.TestedComposeVersion;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"checkClasspath", "", "classpath", "Lorg/jetbrains/compose/reload/test/core/AppClasspath;", "composeVersion", "Lorg/jetbrains/compose/reload/test/gradle/TestedComposeVersion;", "composeRuntimeFinder", "Lorg/jetbrains/compose/reload/test/gradle/DependencyFinder;", "composeDesktopFinder", "composeFoundationFinder", "dependencyRegex", "Lkotlin/text/Regex;", "groupId", "", "artifactId", "gradle-testFixtures"})
@SourceDebugExtension(value={"SMAP\ncheckClasspath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 checkClasspath.kt\norg/jetbrains/compose/reload/test/gradle/CheckClasspathKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1869#2,2:63\n1869#2,2:65\n*S KotlinDebug\n*F\n+ 1 checkClasspath.kt\norg/jetbrains/compose/reload/test/gradle/CheckClasspathKt\n*L\n33#1:63,2\n36#1:65,2\n*E\n"})
public final class CheckClasspathKt {
    @NotNull
    private static final DependencyFinder composeRuntimeFinder = new DependencyFinder("org.jetbrains.compose.runtime", "runtime-desktop");
    @NotNull
    private static final DependencyFinder composeDesktopFinder = new DependencyFinder("org.jetbrains.compose.desktop", "desktop-jvm");
    @NotNull
    private static final DependencyFinder composeFoundationFinder = new DependencyFinder("org.jetbrains.compose.foundation", "foundation-desktop");

    public static final void checkClasspath(@NotNull AppClasspath classpath, @NotNull TestedComposeVersion composeVersion) {
        String composeFoundationVersion;
        String composeDesktopVersion;
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)composeVersion, (String)"composeVersion");
        List problems = new ArrayList();
        String composeRuntimeVersion = composeRuntimeFinder.findVersion(classpath);
        if (!Intrinsics.areEqual((Object)composeRuntimeVersion, (Object)composeVersion.toString())) {
            problems.add("Compose Runtime version mismatch: expected " + composeVersion + ", found " + composeRuntimeVersion);
        }
        if (!Intrinsics.areEqual((Object)(composeDesktopVersion = composeDesktopFinder.findVersion(classpath)), (Object)composeVersion.toString())) {
            problems.add("Compose Desktop version mismatch: expected " + composeVersion + ", found " + composeDesktopVersion);
        }
        if (!Intrinsics.areEqual((Object)(composeFoundationVersion = composeFoundationFinder.findVersion(classpath)), (Object)composeVersion.toString())) {
            problems.add("Compose Foundation version mismatch: expected " + composeVersion + ", found " + composeFoundationVersion);
        }
        if (!((Collection)problems).isEmpty()) {
            String it;
            StringBuilder stringBuilder;
            StringBuilder $this$checkClasspath_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$checkClasspath_u24lambda_u242.append("Suspicious classpath:").append('\n');
            Iterable $this$forEach$iv = problems;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl2 = false;
                $this$checkClasspath_u24lambda_u242.append("  " + it).append('\n');
            }
            $this$checkClasspath_u24lambda_u242.append('\n');
            $this$checkClasspath_u24lambda_u242.append("Classpath:").append('\n');
            $this$forEach$iv = classpath.getFiles();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl3 = false;
                $this$checkClasspath_u24lambda_u242.append("  " + it).append('\n');
            }
            AssertionsKt.fail((String)stringBuilder.toString());
            throw new KotlinNothingValueException();
        }
    }

    private static final Regex dependencyRegex(String groupId, String artifactId) {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String separator = Regex.Companion.escape(string);
        String escapedGroupId = Regex.Companion.escape(groupId);
        String escapedArtifactId = Regex.Companion.escape(artifactId);
        return new Regex(separator + escapedGroupId + separator + escapedArtifactId + separator + ".*" + escapedArtifactId + "-(?<version>.*).jar");
    }

    public static final /* synthetic */ Regex access$dependencyRegex(String groupId, String artifactId) {
        return CheckClasspathKt.dependencyRegex(groupId, artifactId);
    }
}

