/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.gradle;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.core.DebuggerKt;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.HotReloadProperty;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.PidFileInfo;
import org.jetbrains.compose.reload.core.PidFileInfoKt;
import org.jetbrains.compose.reload.core.ProcessUtilsKt;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.gradle.AbstractComposeHotRun;
import org.jetbrains.compose.reload.gradle.ComposeHotDevRun;
import org.jetbrains.compose.reload.gradle.ComposeHotReloadArgumentsKt;
import org.jetbrains.compose.reload.gradle.ComposeHotReloadRunTask;

@UntrackedTask(because="This task should always run")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0011\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u0015\u001a\u00020\u0017H\u0007J\u0010\u0010.\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0017H\u0007J\u0010\u0010/\u001a\u00020-2\u0006\u0010/\u001a\u00020\u0017H\u0007J\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020\u0017H\u0007J\u0010\u00102\u001a\u00020-2\u0006\u00101\u001a\u00020\u0017H\u0007J\u0015\u00103\u001a\u00020-2\u0006\u00104\u001a\u000205H\u0001\u00a2\u0006\u0002\b6J\u0015\u00107\u001a\u00020-2\u0006\u00104\u001a\u000205H\u0001\u00a2\u0006\u0002\b8J\b\u00109\u001a\u00020-H\u0007R\u001e\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000b8\u0001X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u001e\u0010\u0013\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\tR:\u0010\u0015\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00170\u0017 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00170\u0017\u0018\u00010\u00160\u00168\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\tR\u001e\u0010\u001c\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\tR\u001e\u0010\u001e\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\tR\u001a\u0010 \u001a\u0004\u0018\u00010!8\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010$\u001a\u0004\b\"\u0010#R(\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170'0&8\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R(\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170'0&8\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)\u00a8\u0006:"}, d2={"Lorg/jetbrains/compose/reload/gradle/ComposeHotAsyncRun;", "Lorg/gradle/api/DefaultTask;", "Lorg/jetbrains/compose/reload/gradle/ComposeHotReloadRunTask;", "<init>", "()V", "argFile", "Lorg/gradle/api/file/RegularFileProperty;", "kotlin.jvm.PlatformType", "getArgFile$hot_reload_gradle_plugin", "()Lorg/gradle/api/file/RegularFileProperty;", "runTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/jetbrains/compose/reload/gradle/AbstractComposeHotRun;", "getRunTask$hot_reload_gradle_plugin", "()Lorg/gradle/api/tasks/TaskProvider;", "setRunTask$hot_reload_gradle_plugin", "(Lorg/gradle/api/tasks/TaskProvider;)V", "pidFile", "getPidFile$hot_reload_gradle_plugin", "javaBinary", "getJavaBinary$hot_reload_gradle_plugin", "mainClass", "Lorg/gradle/api/provider/Property;", "", "getMainClass$hot_reload_gradle_plugin", "()Lorg/gradle/api/provider/Property;", "stdinFile", "getStdinFile$hot_reload_gradle_plugin", "stdoutFile", "getStdoutFile$hot_reload_gradle_plugin", "stderrFile", "getStderrFile$hot_reload_gradle_plugin", "intellijDebuggerDispatchPort", "", "getIntellijDebuggerDispatchPort$hot_reload_gradle_plugin", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "orchestrationListenerPortSystemProperties", "Lorg/gradle/api/provider/Provider;", "", "getOrchestrationListenerPortSystemProperties$hot_reload_gradle_plugin", "()Lorg/gradle/api/provider/Provider;", "orchestrationListenerPortEnvironmentVariables", "getOrchestrationListenerPortEnvironmentVariables$hot_reload_gradle_plugin", "mainClas", "", "className", "funName", "stdout", "file", "stderr", "autoReload", "enabled", "", "autoReload$hot_reload_gradle_plugin", "auto", "auto$hot_reload_gradle_plugin", "runAsync", "hot-reload-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nhotAsyncRunTasks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 hotAsyncRunTasks.kt\norg/jetbrains/compose/reload/gradle/ComposeHotAsyncRun\n+ 2 Either.kt\norg/jetbrains/compose/reload/core/EitherKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,227:1\n38#2,3:228\n1#3:231\n126#4:232\n153#4,3:233\n37#5,2:236\n*S KotlinDebug\n*F\n+ 1 hotAsyncRunTasks.kt\norg/jetbrains/compose/reload/gradle/ComposeHotAsyncRun\n*L\n187#1:228,3\n207#1:232\n207#1:233,3\n213#1:236,2\n*E\n"})
public class ComposeHotAsyncRun
extends DefaultTask
implements ComposeHotReloadRunTask {
    private final RegularFileProperty argFile = this.getProject().getObjects().fileProperty();
    @Nullable
    private transient TaskProvider<? extends AbstractComposeHotRun> runTask;
    private final RegularFileProperty pidFile = this.getProject().getObjects().fileProperty();
    private final RegularFileProperty javaBinary = this.getProject().getObjects().fileProperty();
    private final Property<String> mainClass = this.getProject().getObjects().property(String.class);
    private final RegularFileProperty stdinFile = this.getProject().getObjects().fileProperty();
    private final RegularFileProperty stdoutFile = this.getProject().getObjects().fileProperty();
    private final RegularFileProperty stderrFile = this.getProject().getObjects().fileProperty();
    @Nullable
    private final Integer intellijDebuggerDispatchPort;
    @NotNull
    private final Provider<Map<String, String>> orchestrationListenerPortSystemProperties;
    @NotNull
    private final Provider<Map<String, String>> orchestrationListenerPortEnvironmentVariables;

    public ComposeHotAsyncRun() {
        String string = (String)this.getProject().getProviders().environmentVariable(HotReloadProperty.IntelliJDebuggerDispatchPort.getKey()).getOrNull();
        this.intellijDebuggerDispatchPort = string != null ? StringsKt.toIntOrNull((String)string) : null;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.orchestrationListenerPortSystemProperties = ComposeHotReloadArgumentsKt.orchestrationListenerPortSystemProperties(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.orchestrationListenerPortEnvironmentVariables = ComposeHotReloadArgumentsKt.orchestrationListenerPortEnvironmentVariables(project2);
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public final RegularFileProperty getArgFile$hot_reload_gradle_plugin() {
        return this.argFile;
    }

    @Internal
    @Nullable
    public final TaskProvider<? extends AbstractComposeHotRun> getRunTask$hot_reload_gradle_plugin() {
        return this.runTask;
    }

    public final void setRunTask$hot_reload_gradle_plugin(@Nullable TaskProvider<? extends AbstractComposeHotRun> taskProvider) {
        this.runTask = taskProvider;
    }

    @Internal
    public final RegularFileProperty getPidFile$hot_reload_gradle_plugin() {
        return this.pidFile;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public final RegularFileProperty getJavaBinary$hot_reload_gradle_plugin() {
        return this.javaBinary;
    }

    @Input
    public final Property<String> getMainClass$hot_reload_gradle_plugin() {
        return this.mainClass;
    }

    @Internal
    public final RegularFileProperty getStdinFile$hot_reload_gradle_plugin() {
        return this.stdinFile;
    }

    @Internal
    public final RegularFileProperty getStdoutFile$hot_reload_gradle_plugin() {
        return this.stdoutFile;
    }

    @Internal
    public final RegularFileProperty getStderrFile$hot_reload_gradle_plugin() {
        return this.stderrFile;
    }

    @Internal
    @Nullable
    public final Integer getIntellijDebuggerDispatchPort$hot_reload_gradle_plugin() {
        return this.intellijDebuggerDispatchPort;
    }

    @Internal
    @NotNull
    public final Provider<Map<String, String>> getOrchestrationListenerPortSystemProperties$hot_reload_gradle_plugin() {
        return this.orchestrationListenerPortSystemProperties;
    }

    @Internal
    @NotNull
    public final Provider<Map<String, String>> getOrchestrationListenerPortEnvironmentVariables$hot_reload_gradle_plugin() {
        return this.orchestrationListenerPortEnvironmentVariables;
    }

    @Option(option="mainClass", description="Override the main class name")
    public final void mainClas(@NotNull String mainClass) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)mainClass, (String)"mainClass");
            this.mainClass.set((Object)mainClass);
            TaskProvider<? extends AbstractComposeHotRun> taskProvider = this.runTask;
            if (taskProvider == null) break block0;
            taskProvider.configure(arg_0 -> ComposeHotAsyncRun.mainClas$lambda$1(arg_0 -> ComposeHotAsyncRun.mainClas$lambda$0(mainClass, arg_0), arg_0));
        }
    }

    @Option(option="className", description="Provide the name of the class to execute")
    public final void className(@NotNull String className) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            TaskProvider<? extends AbstractComposeHotRun> taskProvider = this.runTask;
            if (taskProvider == null) break block0;
            taskProvider.configure(arg_0 -> ComposeHotAsyncRun.className$lambda$1(arg_0 -> ComposeHotAsyncRun.className$lambda$0(className, arg_0), arg_0));
        }
    }

    @Option(option="funName", description="Provide the name of the function to execute")
    public final void funName(@NotNull String funName) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)funName, (String)"funName");
            TaskProvider<? extends AbstractComposeHotRun> taskProvider = this.runTask;
            if (taskProvider == null) break block0;
            taskProvider.configure(arg_0 -> ComposeHotAsyncRun.funName$lambda$1(arg_0 -> ComposeHotAsyncRun.funName$lambda$0(funName, arg_0), arg_0));
        }
    }

    @Option(option="stdout", description="Path to a file, directing stdout to")
    public final void stdout(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.stdoutFile.set(this.getProject().file((Object)file));
    }

    @Option(option="stderr", description="Path to a file, directing stderr to")
    public final void stderr(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.stderrFile.set(this.getProject().file((Object)file));
    }

    @Option(option="autoReload", description="Enables automatic recompilation/reload once the source files change")
    public final void autoReload$hot_reload_gradle_plugin(boolean enabled) {
        block0: {
            TaskProvider<? extends AbstractComposeHotRun> taskProvider = this.runTask;
            if (taskProvider == null) break block0;
            taskProvider.configure(arg_0 -> ComposeHotAsyncRun.autoReload$lambda$1(arg_0 -> ComposeHotAsyncRun.autoReload$lambda$0(enabled, arg_0), arg_0));
        }
    }

    @Option(option="auto", description="Enables automatic recompilation/reload once the source files change")
    public final void auto$hot_reload_gradle_plugin(boolean enabled) {
        block0: {
            TaskProvider<? extends AbstractComposeHotRun> taskProvider = this.runTask;
            if (taskProvider == null) break block0;
            taskProvider.configure(arg_0 -> ComposeHotAsyncRun.auto$lambda$1(arg_0 -> ComposeHotAsyncRun.auto$lambda$0(enabled, arg_0), arg_0));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TaskAction
    public final void runAsync() {
        void $this$mapTo$iv$iv;
        String string;
        Object[] objectArray;
        ProcessHandle processHandle;
        Object $this$leftOr$iv;
        Path path = ((RegularFile)this.pidFile.get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            ComposeHotAsyncRun composeHotAsyncRun = this;
            boolean bl = false;
            Path path3 = ((RegularFile)composeHotAsyncRun.pidFile.get()).getAsFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toPath(...)");
            $this$leftOr$iv = PidFileInfoKt.PidFileInfo(path3);
            boolean $i$f$leftOr = false;
            Either<PidFileInfo, Throwable> either = $this$leftOr$iv;
            if (!(either instanceof Left)) {
                if (!(either instanceof Right)) throw new NoWhenBranchMatchedException();
                Right it = (Right)$this$leftOr$iv;
                boolean bl2 = false;
            } else {
                PidFileInfo pidFileInfo = (PidFileInfo)((Left)$this$leftOr$iv).getValue();
                Long l = pidFileInfo.getPid();
                if (l == null) {
                } else {
                    long pid = l;
                    Optional<ProcessHandle> optional = ProcessHandle.of(pid);
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                    ProcessHandle processHandle2 = (ProcessHandle)OptionalsKt.getOrNull(optional);
                    if (processHandle2 != null) {
                        processHandle = processHandle2;
                        composeHotAsyncRun.getLogger().info("A previous run (" + pid + ") still running, killing...");
                        ProcessUtilsKt.destroyWithDescendants(processHandle);
                        processHandle.onExit().get(15L, TimeUnit.SECONDS);
                        composeHotAsyncRun.getLogger().info("Previous run (" + pid + ") killed");
                    }
                }
            }
        }
        Path path4 = ((RegularFile)this.pidFile.get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"toPath(...)");
        PathsKt.createParentDirectories((Path)path4, (FileAttribute[])new FileAttribute[0]);
        Path path5 = ((RegularFile)this.stdoutFile.get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"toPath(...)");
        PathsKt.createParentDirectories((Path)path5, (FileAttribute[])new FileAttribute[0]);
        Path path6 = ((RegularFile)this.stderrFile.get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"toPath(...)");
        PathsKt.createParentDirectories((Path)path6, (FileAttribute[])new FileAttribute[0]);
        Object[] objectArray2 = objectArray = new String[5];
        int n = 0;
        Object object = (RegularFile)this.stdinFile.getOrNull();
        if (object != null && (object = object.getAsFile()) != null) {
            void file;
            processHandle = object;
            int n2 = n;
            Object[] objectArray3 = objectArray2;
            boolean bl = false;
            String string2 = "-D" + HotReloadProperty.StdinFile.getKey() + "=" + file.getAbsolutePath();
            objectArray2 = objectArray3;
            n = n2;
            string = string2;
        } else {
            string = null;
        }
        objectArray2[n] = string;
        objectArray[1] = "-D" + HotReloadProperty.StdoutFile.getKey() + "=" + ((RegularFile)this.stdoutFile.get()).getAsFile().getAbsolutePath();
        objectArray[2] = "-D" + HotReloadProperty.StderrFile.getKey() + "=" + ((RegularFile)this.stderrFile.get()).getAsFile().getAbsolutePath();
        objectArray[3] = "-D" + HotReloadProperty.LaunchMode.getKey() + "=Detached";
        objectArray[4] = "-D" + HotReloadProperty.MainClass.getKey() + "=" + this.mainClass.get();
        Collection collection = CollectionsKt.listOfNotNull((Object[])objectArray);
        Map map2 = (Map)this.orchestrationListenerPortSystemProperties.getOrNull();
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map map3 = map2;
        Collection collection2 = collection;
        boolean $i$f$map22 = false;
        $this$leftOr$iv = map3;
        Collection destination$iv$iv = new ArrayList(map3.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            collection3.add("-D" + key + "=" + value);
        }
        List additionalJvmArguments = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
        Object $i$f$map22 = new SpreadBuilder(4);
        $i$f$map22.add((Object)((RegularFile)this.javaBinary.get()).getAsFile().getAbsolutePath());
        String string3 = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        $i$f$map22.addSpread((Object)DebuggerKt.issueNewDebugSessionJvmArguments(string3, this.intellijDebuggerDispatchPort));
        Collection $this$toTypedArray$iv = additionalJvmArguments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $i$f$map22.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        $i$f$map22.add((Object)("@" + ((File)this.argFile.getAsFile().get()).getAbsolutePath()));
        Object $this$runAsync_u24lambda_u243 = $i$f$map22 = new ProcessBuilder((String[])$i$f$map22.toArray((Object[])new String[$i$f$map22.size()]));
        boolean bl = false;
        Map<String, String> map4 = ((ProcessBuilder)$this$runAsync_u24lambda_u243).environment();
        Map map5 = (Map)this.orchestrationListenerPortEnvironmentVariables.getOrNull();
        if (map5 == null) {
            map5 = MapsKt.emptyMap();
        }
        map4.putAll(map5);
        ProcessBuilder processBuilder = ((ProcessBuilder)$i$f$map22).redirectOutput(((RegularFile)this.stdoutFile.get()).getAsFile()).redirectError(((RegularFile)this.stderrFile.get()).getAsFile());
        if (this.stdinFile.isPresent()) {
            processBuilder.redirectInput(((RegularFile)this.stdinFile.get()).getAsFile());
        }
        Process process2 = processBuilder.start();
        this.getLogger().quiet("Started '" + this.mainClass.get() + "' in background (" + process2.pid() + ")");
    }

    private static final Unit mainClas$lambda$0(String $mainClass, AbstractComposeHotRun task2) {
        ((JavaExec)task2).getMainClass().set((Object)$mainClass);
        return Unit.INSTANCE;
    }

    private static final void mainClas$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit className$lambda$0(String $className, AbstractComposeHotRun task2) {
        block0: {
            Property<String> property = task2 instanceof ComposeHotDevRun ? (Property<String>)task2 : null;
            if (property == null || (property = property.getClassName$hot_reload_gradle_plugin()) == null) break block0;
            property.set((Object)$className);
        }
        return Unit.INSTANCE;
    }

    private static final void className$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit funName$lambda$0(String $funName, AbstractComposeHotRun task2) {
        block0: {
            Property<String> property = task2 instanceof ComposeHotDevRun ? (Property<String>)task2 : null;
            if (property == null || (property = property.getFunName$hot_reload_gradle_plugin()) == null) break block0;
            property.set((Object)$funName);
        }
        return Unit.INSTANCE;
    }

    private static final void funName$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit autoReload$lambda$0(boolean $enabled, AbstractComposeHotRun it) {
        it.getIsAutoReloadEnabled().set((Object)$enabled);
        return Unit.INSTANCE;
    }

    private static final void autoReload$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit auto$lambda$0(boolean $enabled, AbstractComposeHotRun it) {
        it.getIsAutoReloadEnabled().set((Object)$enabled);
        return Unit.INSTANCE;
    }

    private static final void auto$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

