/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.InternalHotReloadApi;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u001a+\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bH\u0007\u001a0\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n*\u00020\u00012\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\n0\u0005\u00a2\u0006\u0002\b\bH\u0007\u00a2\u0006\u0002\u0010\f\u001aA\u0010\r\u001a\u0018\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u0002H\n`\u0010\"\u0004\b\u0000\u0010\n*\u00020\u00012\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\n0\u0005\u00a2\u0006\u0002\b\bH\u0007\u001a\u0014\u0010\u0011\u001a\u00020\u0007*\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u001a\f\u0010\u0014\u001a\u00020\u0013*\u00020\u000bH\u0007\u001a\u0014\u0010\u0015\u001a\u00020\u0007*\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0001H\u0007\u001a\f\u0010\u0017\u001a\u00020\u0001*\u00020\u000bH\u0007\u001a\u0016\u0010\u0018\u001a\u00020\u0007*\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u0001*\u00020\u000bH\u0007\u001a\u001e\u0010\u001a\u001a\u00020\u0007*\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\u001a\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001d*\u00020\u000bH\u0007\u001a\"\u0010\u001e\u001a\u00020\u0007*\u00020\u00062\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010 H\u0007\u001aA\u0010\u001e\u001a\u00020\u0007*\u00020\u00062.\u0010\u001f\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001d0!\"\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001dH\u0007\u00a2\u0006\u0002\u0010\"\u001a\f\u0010#\u001a\u00020\u0001*\u00020$H\u0007\u001a\f\u0010%\u001a\u00020$*\u00020\u0001H\u0007\u001a\f\u0010#\u001a\u00020\u0001*\u00020&H\u0007\u001a\f\u0010'\u001a\u00020&*\u00020\u0001H\u0007\u001a\f\u0010#\u001a\u00020\u0001*\u00020\u0003H\u0007\u001a\f\u0010(\u001a\u00020\u0003*\u00020\u0001H\u0007\u001a\u001a\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010 *\u00020\u000bH\u0007\u001a\"\u0010*\u001a\u00020\u0001*\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010 2\u0006\u0010+\u001a\u00020\u0013H\u0007\u00a8\u0006,"}, d2={"encodeByteArray", "", "initialSize", "", "encode", "Lkotlin/Function1;", "Ljava/io/DataOutputStream;", "", "Lkotlin/ExtensionFunctionType;", "decode", "T", "Ljava/io/DataInputStream;", "([BLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "tryDecode", "Lorg/jetbrains/compose/reload/core/Either;", "", "Lorg/jetbrains/compose/reload/core/Try;", "writeString", "value", "", "readString", "writeFrame", "bytes", "readFrame", "writeOptionalFrame", "readOptionalFrame", "writeField", "name", "readField", "Lkotlin/Pair;", "writeFields", "fields", "", "", "(Ljava/io/DataOutputStream;[Lkotlin/Pair;)V", "encodeToByteArray", "", "decodeToBoolean", "", "decodeToLong", "decodeToInt", "readFields", "requireField", "key", "hot-reload-core"})
@SourceDebugExtension(value={"SMAP\nencodeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 encodeUtils.kt\norg/jetbrains/compose/reload/core/EncodeUtilsKt\n+ 2 Try.kt\norg/jetbrains/compose/reload/core/TryKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n16#2,4:151\n1#3:155\n*S KotlinDebug\n*F\n+ 1 encodeUtils.kt\norg/jetbrains/compose/reload/core/EncodeUtilsKt\n*L\n28#1:151,4\n*E\n"})
public final class EncodeUtilsKt {
    @InternalHotReloadApi
    @NotNull
    public static final byte[] encodeByteArray(int initialSize, @NotNull Function1<? super DataOutputStream, Unit> encode) {
        Intrinsics.checkNotNullParameter(encode, (String)"encode");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(initialSize);
        DataOutputStream daos = new DataOutputStream(baos);
        encode.invoke((Object)daos);
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] encodeByteArray$default(int n, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 32;
        }
        return EncodeUtilsKt.encodeByteArray(n, (Function1<? super DataOutputStream, Unit>)function1);
    }

    @InternalHotReloadApi
    public static final <T> T decode(@NotNull byte[] $this$decode, @NotNull Function1<? super DataInputStream, ? extends T> decode) {
        Intrinsics.checkNotNullParameter((Object)$this$decode, (String)"<this>");
        Intrinsics.checkNotNullParameter(decode, (String)"decode");
        return (T)decode.invoke((Object)new DataInputStream(new ByteArrayInputStream($this$decode)));
    }

    @InternalHotReloadApi
    @NotNull
    public static final <T> Either<T, Throwable> tryDecode(@NotNull byte[] $this$tryDecode, @NotNull Function1<? super DataInputStream, ? extends T> decode) {
        Either either;
        Intrinsics.checkNotNullParameter((Object)$this$tryDecode, (String)"<this>");
        Intrinsics.checkNotNullParameter(decode, (String)"decode");
        boolean $i$f$Try = false;
        try {
            boolean bl = false;
            either = EitherKt.toLeft(EncodeUtilsKt.decode($this$tryDecode, decode));
        }
        catch (Throwable t$iv) {
            either = EitherKt.toRight(t$iv);
        }
        return either;
    }

    @InternalHotReloadApi
    public static final void writeString(@NotNull DataOutputStream $this$writeString, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        EncodeUtilsKt.writeFrame($this$writeString, StringsKt.encodeToByteArray((String)value));
    }

    @InternalHotReloadApi
    @NotNull
    public static final String readString(@NotNull DataInputStream $this$readString) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        return StringsKt.decodeToString((byte[])EncodeUtilsKt.readFrame($this$readString));
    }

    @InternalHotReloadApi
    public static final void writeFrame(@NotNull DataOutputStream $this$writeFrame, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$writeFrame, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        $this$writeFrame.writeInt(bytes.length);
        $this$writeFrame.write(bytes);
    }

    @InternalHotReloadApi
    @NotNull
    public static final byte[] readFrame(@NotNull DataInputStream $this$readFrame) {
        Intrinsics.checkNotNullParameter((Object)$this$readFrame, (String)"<this>");
        int size = $this$readFrame.readInt();
        byte[] byArray = $this$readFrame.readNBytes(size);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readNBytes(...)");
        return byArray;
    }

    @InternalHotReloadApi
    public static final void writeOptionalFrame(@NotNull DataOutputStream $this$writeOptionalFrame, @Nullable byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$writeOptionalFrame, (String)"<this>");
        if (bytes == null) {
            $this$writeOptionalFrame.writeInt(-1);
            return;
        }
        EncodeUtilsKt.writeFrame($this$writeOptionalFrame, bytes);
    }

    @InternalHotReloadApi
    @Nullable
    public static final byte[] readOptionalFrame(@NotNull DataInputStream $this$readOptionalFrame) {
        Intrinsics.checkNotNullParameter((Object)$this$readOptionalFrame, (String)"<this>");
        int size = $this$readOptionalFrame.readInt();
        if (size < 0) {
            return null;
        }
        return $this$readOptionalFrame.readNBytes(size);
    }

    @InternalHotReloadApi
    public static final void writeField(@NotNull DataOutputStream $this$writeField, @NotNull String name, @Nullable byte[] value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        EncodeUtilsKt.writeString($this$writeField, name);
        EncodeUtilsKt.writeOptionalFrame($this$writeField, value);
    }

    @InternalHotReloadApi
    @NotNull
    public static final Pair<String, byte[]> readField(@NotNull DataInputStream $this$readField) {
        Intrinsics.checkNotNullParameter((Object)$this$readField, (String)"<this>");
        return TuplesKt.to((Object)EncodeUtilsKt.readString($this$readField), (Object)EncodeUtilsKt.readOptionalFrame($this$readField));
    }

    @InternalHotReloadApi
    public static final void writeFields(@NotNull DataOutputStream $this$writeFields, @NotNull Map<String, byte[]> fields) {
        Intrinsics.checkNotNullParameter((Object)$this$writeFields, (String)"<this>");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        $this$writeFields.writeInt(fields.size());
        for (Map.Entry<String, byte[]> entry : fields.entrySet()) {
            String key = entry.getKey();
            byte[] value = entry.getValue();
            EncodeUtilsKt.writeField($this$writeFields, key, value);
        }
    }

    @InternalHotReloadApi
    public static final void writeFields(@NotNull DataOutputStream $this$writeFields, Pair<String, byte[]> ... fields) {
        Intrinsics.checkNotNullParameter((Object)$this$writeFields, (String)"<this>");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        EncodeUtilsKt.writeFields($this$writeFields, MapsKt.toMap(fields));
    }

    @InternalHotReloadApi
    @NotNull
    public static final byte[] encodeToByteArray(boolean $this$encodeToByteArray) {
        if ($this$encodeToByteArray) {
            byte[] byArray = new byte[]{1};
            return byArray;
        }
        byte[] byArray = new byte[]{0};
        return byArray;
    }

    @InternalHotReloadApi
    public static final boolean decodeToBoolean(@NotNull byte[] $this$decodeToBoolean) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeToBoolean, (String)"<this>");
        if (!($this$decodeToBoolean.length == 1)) {
            boolean bl = false;
            String string = "Invalid boolean value: " + HexExtensionsKt.toHexString$default((byte[])$this$decodeToBoolean, null, (int)1, null);
            throw new IllegalArgumentException(string.toString());
        }
        return $this$decodeToBoolean[0] != 0;
    }

    @InternalHotReloadApi
    @NotNull
    public static final byte[] encodeToByteArray(long $this$encodeToByteArray) {
        return EncodeUtilsKt.encodeByteArray(8, (Function1<? super DataOutputStream, Unit>)((Function1)arg_0 -> EncodeUtilsKt.encodeToByteArray$lambda$0($this$encodeToByteArray, arg_0)));
    }

    @InternalHotReloadApi
    public static final long decodeToLong(@NotNull byte[] $this$decodeToLong) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeToLong, (String)"<this>");
        if (!($this$decodeToLong.length == 8)) {
            boolean bl = false;
            String string = "Invalid long value: " + HexExtensionsKt.toHexString$default((byte[])$this$decodeToLong, null, (int)1, null);
            throw new IllegalArgumentException(string.toString());
        }
        return ((Number)EncodeUtilsKt.decode($this$decodeToLong, EncodeUtilsKt::decodeToLong$lambda$1)).longValue();
    }

    @InternalHotReloadApi
    @NotNull
    public static final byte[] encodeToByteArray(int $this$encodeToByteArray) {
        return EncodeUtilsKt.encodeByteArray(4, (Function1<? super DataOutputStream, Unit>)((Function1)arg_0 -> EncodeUtilsKt.encodeToByteArray$lambda$1($this$encodeToByteArray, arg_0)));
    }

    @InternalHotReloadApi
    public static final int decodeToInt(@NotNull byte[] $this$decodeToInt) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeToInt, (String)"<this>");
        if (!($this$decodeToInt.length == 4)) {
            boolean bl = false;
            String string = "Invalid int value: " + HexExtensionsKt.toHexString$default((byte[])$this$decodeToInt, null, (int)1, null);
            throw new IllegalArgumentException(string.toString());
        }
        return ((Number)EncodeUtilsKt.decode($this$decodeToInt, EncodeUtilsKt::decodeToInt$lambda$1)).intValue();
    }

    @InternalHotReloadApi
    @NotNull
    public static final Map<String, byte[]> readFields(@NotNull DataInputStream $this$readFields) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)$this$readFields, (String)"<this>");
        int size = $this$readFields.readInt();
        Map $this$readFields_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        int n = 0;
        while (n < size) {
            int it = n++;
            boolean bl2 = false;
            Pair<String, byte[]> pair = EncodeUtilsKt.readField($this$readFields);
            String name = (String)pair.component1();
            byte[] bytes = (byte[])pair.component2();
            $this$readFields_u24lambda_u240.put(name, bytes);
        }
        return MapsKt.build((Map)map2);
    }

    @InternalHotReloadApi
    @NotNull
    public static final byte[] requireField(@NotNull Map<String, byte[]> $this$requireField, @NotNull String key) {
        Intrinsics.checkNotNullParameter($this$requireField, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!$this$requireField.containsKey(key)) {
            throw new IllegalStateException(("Missing field '" + key + "'").toString());
        }
        byte[] byArray = $this$requireField.get(key);
        if (byArray == null) {
            throw new IllegalStateException(("Field '" + key + "' is null").toString());
        }
        return byArray;
    }

    private static final Unit encodeToByteArray$lambda$0(long $this_encodeToByteArray, DataOutputStream $this$encodeByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeByteArray, (String)"$this$encodeByteArray");
        $this$encodeByteArray.writeLong($this_encodeToByteArray);
        return Unit.INSTANCE;
    }

    private static final long decodeToLong$lambda$1(DataInputStream $this$decode) {
        Intrinsics.checkNotNullParameter((Object)$this$decode, (String)"$this$decode");
        return $this$decode.readLong();
    }

    private static final Unit encodeToByteArray$lambda$1(int $this_encodeToByteArray, DataOutputStream $this$encodeByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeByteArray, (String)"$this$encodeByteArray");
        $this$encodeByteArray.writeInt($this_encodeToByteArray);
        return Unit.INSTANCE;
    }

    private static final int decodeToInt$lambda$1(DataInputStream $this$decode) {
        Intrinsics.checkNotNullParameter((Object)$this$decode, (String)"$this$decode");
        return $this$decode.readInt();
    }
}

