/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0019\u001a\u00020\u0007J\u0014\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u001d\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lorg/jetbrains/compose/reload/core/Node;", "T", "", "value", "originalOrdinal", "", "isVisible", "", "<init>", "(Ljava/lang/Object;IZ)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getOriginalOrdinal", "()I", "setOriginalOrdinal", "(I)V", "()Z", "isReleased", "incomingEdgesCounter", "getIncomingEdgesCounter", "children", "", "getChildren", "()Ljava/util/List;", "isRoot", "addChild", "", "node", "release", "", "toString", "", "hot-reload-core"})
@SourceDebugExtension(value={"SMAP\ntopologicalSort.kt\nKotlin\n*S Kotlin\n*F\n+ 1 topologicalSort.kt\norg/jetbrains/compose/reload/core/Node\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1869#2,2:202\n*S KotlinDebug\n*F\n+ 1 topologicalSort.kt\norg/jetbrains/compose/reload/core/Node\n*L\n187#1:202,2\n*E\n"})
final class Node<T> {
    private final T value;
    private int originalOrdinal;
    private final boolean isVisible;
    private boolean isReleased;
    private int incomingEdgesCounter;
    @NotNull
    private final List<Node<T>> children;

    public Node(T value, int originalOrdinal, boolean isVisible) {
        this.value = value;
        this.originalOrdinal = originalOrdinal;
        this.isVisible = isVisible;
        this.children = new ArrayList();
    }

    public /* synthetic */ Node(Object object, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        this(object, n, bl);
    }

    public final T getValue() {
        return this.value;
    }

    public final int getOriginalOrdinal() {
        return this.originalOrdinal;
    }

    public final void setOriginalOrdinal(int n) {
        this.originalOrdinal = n;
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    public final boolean isReleased() {
        return this.isReleased;
    }

    public final int getIncomingEdgesCounter() {
        return this.incomingEdgesCounter;
    }

    @NotNull
    public final List<Node<T>> getChildren() {
        return this.children;
    }

    public final boolean isRoot() {
        return this.incomingEdgesCounter == 0;
    }

    public final void addChild(@NotNull Node<T> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        this.children.add(node);
        int n = node.incomingEdgesCounter;
        node.incomingEdgesCounter = n + 1;
    }

    @NotNull
    public final List<Node<T>> release() {
        if (this.isReleased) {
            throw new IllegalStateException(("Already released this node: " + this.value).toString());
        }
        this.isReleased = true;
        List newRoots = new ArrayList();
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node child = (Node)element$iv;
            boolean bl = false;
            int n = child.incomingEdgesCounter;
            child.incomingEdgesCounter = n + -1;
            if (!child.isRoot() || child.isReleased) continue;
            newRoots.add(child);
        }
        this.children.clear();
        return CollectionsKt.toList((Iterable)newRoots);
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.value);
    }
}

