/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.gradle;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.core.FileUtilsKt;
import org.jetbrains.compose.reload.core.ZipKt;
import org.jetbrains.compose.reload.gradle.UtilsKt;

@DisableCachingByDefault(because="Not worth caching")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0013\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\u00020\n8G\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u00020\u000f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/compose/reload/gradle/SyncArtifactsTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "artifactCollection", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/artifacts/ArtifactCollection;", "getArtifactCollection", "()Lorg/gradle/api/provider/ListProperty;", "files", "Lorg/gradle/api/file/FileCollection;", "getFiles$annotations", "getFiles", "()Lorg/gradle/api/file/FileCollection;", "destinationDir", "Lorg/gradle/api/file/DirectoryProperty;", "getDestinationDir", "()Lorg/gradle/api/file/DirectoryProperty;", "sync", "", "hot-reload-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nruntimeClasspath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 runtimeClasspath.kt\norg/jetbrains/compose/reload/gradle/SyncArtifactsTask\n+ 2 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n77#2:173\n1863#3:174\n1863#3,2:175\n1863#3,2:177\n1864#3:179\n1557#3:180\n1628#3,3:181\n*S KotlinDebug\n*F\n+ 1 runtimeClasspath.kt\norg/jetbrains/compose/reload/gradle/SyncArtifactsTask\n*L\n102#1:173\n119#1:174\n122#1:175,2\n128#1:177,2\n119#1:179\n106#1:180\n106#1:181,3\n*E\n"})
class SyncArtifactsTask
extends DefaultTask {
    @NotNull
    private final ListProperty<ArtifactCollection> artifactCollection;
    @NotNull
    private final FileCollection files;
    @NotNull
    private final DirectoryProperty destinationDir;

    public SyncArtifactsTask() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        ObjectFactory $this$listProperty$iv = objectFactory;
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(ArtifactCollection.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.artifactCollection = listProperty;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ConfigurableFileCollection configurableFileCollection = UtilsKt.files(project, (Function0<? extends Object>)((Function0)() -> SyncArtifactsTask.files$lambda$1(this)));
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"files(...)");
        this.files = (FileCollection)configurableFileCollection;
        DirectoryProperty directoryProperty = this.getProject().getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"directoryProperty(...)");
        this.destinationDir = directoryProperty;
    }

    @Internal
    @NotNull
    public final ListProperty<ArtifactCollection> getArtifactCollection() {
        return this.artifactCollection;
    }

    @Classpath
    @NotNull
    public final FileCollection getFiles() {
        return this.files;
    }

    public static /* synthetic */ void getFiles$annotations() {
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getDestinationDir() {
        return this.destinationDir;
    }

    @TaskAction
    public final void sync() {
        Path destination = ((File)this.destinationDir.getAsFile().get()).toPath();
        Intrinsics.checkNotNull((Object)destination);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(destination, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathsKt.deleteRecursively((Path)destination);
        }
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(destination, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Object object = this.artifactCollection.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable $this$forEach$iv = CollectionsKt.flatten((Iterable)((Iterable)object));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path targetFile;
            Path path;
            String disambiguationHash;
            Object element$iv22;
            ResolvedArtifactResult artifact = (ResolvedArtifactResult)element$iv;
            boolean bl = false;
            CRC32 crc = new CRC32();
            List list = artifact.getVariant().getCapabilities();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCapabilities(...)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv22 : $this$forEach$iv2) {
                Object object2;
                block15: {
                    block14: {
                        Capability capability = (Capability)element$iv22;
                        boolean bl2 = false;
                        String string = capability.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        crc.update(StringsKt.encodeToByteArray((String)string));
                        String string2 = capability.getGroup();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getGroup(...)");
                        crc.update(StringsKt.encodeToByteArray((String)string2));
                        object2 = capability.getVersion();
                        if (object2 == null) break block14;
                        byte[] byArray = StringsKt.encodeToByteArray((String)object2);
                        object2 = byArray;
                        if (byArray != null) break block15;
                    }
                    object2 = new byte[0];
                }
                crc.update((byte[])object2);
            }
            Set set = artifact.getVariant().getAttributes().keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
            $this$forEach$iv2 = set;
            $i$f$forEach2 = false;
            for (Object element$iv22 : $this$forEach$iv2) {
                Attribute key = (Attribute)element$iv22;
                boolean bl3 = false;
                String string = key.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                crc.update(StringsKt.encodeToByteArray((String)string));
                crc.update(StringsKt.encodeToByteArray((String)String.valueOf(artifact.getVariant().getAttributes().getAttribute(key))));
            }
            if (artifact.getId().getComponentIdentifier() instanceof OpaqueComponentArtifactIdentifier) {
                String string = artifact.getFile().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                crc.update(StringsKt.encodeToByteArray((String)string));
            }
            Intrinsics.checkNotNullExpressionValue((Object)Integer.toString((int)crc.getValue(), CharsKt.checkRadix((int)24)), (String)"toString(...)");
            ComponentIdentifier componentIdentifier = artifact.getId().getComponentIdentifier();
            element$iv22 = componentIdentifier;
            if (element$iv22 instanceof ModuleComponentIdentifier) {
                String string = ((ModuleComponentIdentifier)componentIdentifier).getGroup();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroup(...)");
                String string3 = FileUtilsKt.asFileName(string);
                String string4 = ((ModuleComponentIdentifier)componentIdentifier).getModule();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getModule(...)");
                String string5 = FileUtilsKt.asFileName(string4);
                String string6 = ((ModuleComponentIdentifier)componentIdentifier).getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getVersion(...)");
                String string7 = FileUtilsKt.asFileName(string6);
                File file = artifact.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                String string8 = FilesKt.getNameWithoutExtension((File)file);
                File file2 = artifact.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getFile(...)");
                path = destination.resolve(string3 + "/" + string5 + "/" + string7 + "/" + disambiguationHash + "/" + string8 + "." + FilesKt.getExtension((File)file2));
            } else if (element$iv22 instanceof ProjectComponentIdentifier) {
                String string = ((ProjectComponentIdentifier)componentIdentifier).getBuildTreePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBuildTreePath(...)");
                path = destination.resolve(FileUtilsKt.asFileName(StringsKt.replace$default((String)StringsKt.removePrefix((String)string, (CharSequence)":"), (String)":", (String)"/", (boolean)false, (int)4, null))).resolve(disambiguationHash).resolve(artifact.getFile().getName());
            } else {
                path = targetFile = destination.resolve("opaque").resolve(disambiguationHash).resolve(artifact.getFile().getName());
            }
            if (artifact.getFile().exists()) {
                Intrinsics.checkNotNull((Object)targetFile);
                PathsKt.createParentDirectories((Path)targetFile, (FileAttribute[])new FileAttribute[0]);
            }
            if (artifact.getFile().isFile()) {
                File file = artifact.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                File file3 = targetFile.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
                FilesKt.copyTo$default((File)file, (File)file3, (boolean)true, (int)0, (int)4, null);
            }
            if (!artifact.getFile().isDirectory()) continue;
            Intrinsics.checkNotNull((Object)targetFile);
            Path targetFileJar = targetFile.resolveSibling(PathsKt.getName((Path)targetFile) + ".jar");
            Path path2 = artifact.getFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            Intrinsics.checkNotNull((Object)targetFileJar);
            ZipKt.copyRecursivelyToZip(path2, targetFileJar, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Object files$lambda$1(SyncArtifactsTask this$0) {
        void $this$mapTo$iv$iv;
        Object object = this$0.artifactCollection.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ArtifactCollection artifactCollection = (ArtifactCollection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getArtifactFiles());
        }
        return (List)destination$iv$iv;
    }
}

