/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.core.AsyncTraces;
import org.jetbrains.compose.reload.core.AsyncTracesThrowable;
import org.jetbrains.compose.reload.core.CompletableFuture;
import org.jetbrains.compose.reload.core.Disposable;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.FutureKt;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.core.ReloadMainThreadKt;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.core.StoppedException;
import org.jetbrains.compose.reload.core.Task;
import org.jetbrains.compose.reload.core.TaskKt;
import org.jetbrains.compose.reload.core.TryKt;
import org.jetbrains.compose.reload.core.Update;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001/BH\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012-\u0010\u0007\u001a)\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJZ\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0002\"\u0004\b\u0001\u0010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001f\u001a\u00020\u00062-\u0010 \u001a)\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0002\b\u000bH\u0016\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\b\u0010&\u001a\u00020#H\u0016J\"\u0010'\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020%\u0018\u00010(j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`)H\u0016J$\u0010*\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020%0(j\b\u0012\u0004\u0012\u00028\u0000`)H\u0096@\u00a2\u0006\u0002\u0010+J\u0016\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R7\u0010\u0007\u001a)\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017\u00a8\u00060\u00b2\u0006\n\u0010$\u001a\u00020%X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/compose/reload/core/TaskImpl;", "T", "Lorg/jetbrains/compose/reload/core/Task;", "name", "", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "action", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Ljava/lang/String;Lkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function2;)V", "getName", "()Ljava/lang/String;", "Lkotlin/jvm/functions/Function2;", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/compose/reload/core/TaskImpl$State;", "value", "Lorg/jetbrains/compose/reload/core/CompletableFuture;", "getValue", "()Lorg/jetbrains/compose/reload/core/CompletableFuture;", "onStop", "", "getOnStop", "reject", "", "start", "subtask", "context", "body", "(Ljava/lang/String;Lkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/compose/reload/core/Task;", "stop", "", "exception", "", "isCompleted", "getOrNull", "Lorg/jetbrains/compose/reload/core/Either;", "Lorg/jetbrains/compose/reload/core/Try;", "await", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitWith", "Lorg/jetbrains/compose/reload/core/Disposable;", "continuation", "State", "hot-reload-core"})
@SourceDebugExtension(value={"SMAP\nTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Task.kt\norg/jetbrains/compose/reload/core/TaskImpl\n+ 2 atomics.kt\norg/jetbrains/compose/reload/core/AtomicsKt\n+ 3 AsyncTraces.kt\norg/jetbrains/compose/reload/core/AsyncTracesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n17#2,5:289\n17#2,5:294\n17#2,5:302\n17#2,5:307\n17#2,5:314\n63#3:299\n56#3,2:300\n1869#4,2:312\n*S KotlinDebug\n*F\n+ 1 Task.kt\norg/jetbrains/compose/reload/core/TaskImpl\n*L\n139#1:289,5\n148#1:294,5\n225#1:302,5\n259#1:307,5\n242#1:314,5\n223#1:299\n223#1:300,2\n268#1:312,2\n*E\n"})
final class TaskImpl<T>
implements Task<T> {
    @Nullable
    private final String name;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final Function2<Task<? extends T>, Continuation<? super T>, Object> action;
    @NotNull
    private final AtomicReference<State<T>> state;
    @NotNull
    private final CompletableFuture<T> value;
    @NotNull
    private final CompletableFuture onStop;

    public TaskImpl(@Nullable String name, @NotNull CoroutineContext coroutineContext, @NotNull Function2<? super Task<? extends T>, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.name = name;
        this.coroutineContext = coroutineContext;
        this.action = action;
        this.state = new AtomicReference<State.Idle>(State.Idle.INSTANCE);
        this.value = FutureKt.Future();
        this.onStop = FutureKt.Future();
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public CompletableFuture<T> getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public CompletableFuture getOnStop() {
        return this.onStop;
    }

    public final void reject() {
        State updated$iv;
        State<T> value$iv;
        AtomicReference<State<T>> $this$update$iv = this.state;
        boolean $i$f$update = false;
        do {
            State<T> currentState = value$iv = $this$update$iv.get();
            boolean bl = false;
            if (currentState instanceof State.Idle) continue;
            throw new IllegalStateException(("Unexpected state: " + currentState).toString());
        } while (!$this$update$iv.compareAndSet(value$iv, updated$iv = (State)new State.Finished((Either)EitherKt.toRight(new RejectedExecutionException()))));
        new Update<State>(value$iv, updated$iv);
    }

    public final void start() {
        State updated$iv;
        State<T> value$iv;
        AtomicReference<State<T>> $this$update$iv = this.state;
        boolean $i$f$update = false;
        do {
            State<T> currentState = value$iv = $this$update$iv.get();
            boolean bl = false;
            if (currentState instanceof State.Idle) continue;
            throw new IllegalStateException(("Unexpected state: " + currentState).toString());
        } while (!$this$update$iv.compareAndSet(value$iv, updated$iv = (State)new State.Running(CollectionsKt.emptyList())));
        new Update<State>(value$iv, updated$iv);
        CoroutineContext coroutineContext = ReloadMainThreadKt.getReloadMainDispatcher().plus(this.coroutineContext).plus((CoroutineContext)this);
        coroutineContext = ContinuationKt.createCoroutine((Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ TaskImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block26: {
                    var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block2 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var3_3 = this.this$0;
                            $i$f$Try = false;
                            $i$a$-Try-TaskImpl$start$2$result$1 = false;
                            this.label = 1;
                            v0 = TaskImpl.access$getAction$p(var3_3).invoke(var3_3, (Object)this);
                            ** if (v0 != var11_2) goto lbl14
lbl13:
                            // 1 sources

                            return var11_2;
lbl14:
                            // 1 sources

                            ** GOTO lbl23
                        }
                        case 1: {
                            $i$f$Try = false;
                            $i$a$-Try-TaskImpl$start$2$result$1 = false;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl23:
                                // 2 sources

                                var6_9 = EitherKt.toLeft(v0);
                            }
                            catch (Throwable t$iv) {
                                var6_9 = EitherKt.toRight(t$iv);
                            }
                            result = var6_9;
                            if (TryKt.isFailure(result)) {
                                asyncTraces = (AsyncTraces)TaskImpl.access$getCoroutineContext$p(this.this$0).get((CoroutineContext.Key)AsyncTraces.Key);
                                if (asyncTraces != null) {
                                    ExceptionsKt.addSuppressed((Throwable)TryKt.getException((Right)result), (Throwable)new AsyncTracesThrowable(asyncTraces));
                                }
                                this.this$0.stop(TryKt.getException((Right)result));
                            }
lbl36:
                            // 5 sources

                            while (true) {
                                v1 = TaskImpl.access$getState$p(this.this$0).get();
                                Intrinsics.checkNotNullExpressionValue(v1, (String)"get(...)");
                                t$iv = currentState = (State)v1;
                                if (t$iv instanceof State.Running) {
                                    v2 = ((State.Running)currentState).getChildren();
                                } else if (t$iv instanceof State.Stopping) {
                                    v2 = ((State.Stopping)currentState).getChildren();
                                } else {
                                    if (t$iv instanceof State.Finished || t$iv instanceof State.Idle) {
                                        throw new IllegalStateException(("Unexpected state: " + TaskImpl.access$getState$p(this.this$0)).toString());
                                    }
                                    throw new NoWhenBranchMatchedException();
                                }
                                children = v2;
                                if (!(((Collection)children).isEmpty() == false)) break block26;
                                $this$forEach$iv = children;
                                $i$f$forEach = false;
                                var7_12 = $this$forEach$iv.iterator();
lbl54:
                                // 3 sources

                                while (var7_12.hasNext()) {
                                    element$iv = var7_12.next();
                                    child = (Task)element$iv;
                                    $i$a$-forEach-TaskImpl$start$2$1 = false;
                                    this.L$0 = result;
                                    this.L$1 = children;
                                    this.L$2 = var7_12;
                                    this.label = 2;
                                    v3 = child.getValue().await(this);
                                    if (v3 != var11_2) continue;
                                    return var11_2;
                                }
                                break block2;
                                break;
                            }
                        }
                        case 2: {
                            $i$f$forEach = false;
                            $i$a$-forEach-TaskImpl$start$2$1 = false;
                            var7_12 = (Iterator<T>)this.L$2;
                            children = (List<Task<?>>)this.L$1;
                            result = (Either)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
                            ** GOTO lbl54
                        }
                    }
                    $this$update$iv = TaskImpl.access$getState$p(this.this$0);
                    $i$f$update = false;
                    do {
                        value$iv = $this$update$iv.get();
                        currentState = (State)value$iv;
                        $i$a$-update-TaskImpl$start$2$2 = false;
                        var10_16 = currentState;
                        if (var10_16 instanceof State.Running) {
                            v4 = ((State.Running)currentState).copy(CollectionsKt.minus((Iterable)((State.Running)currentState).getChildren(), (Iterable)children));
                            continue;
                        }
                        if (var10_16 instanceof State.Stopping) {
                            v4 = State.Stopping.copy$default((State.Stopping)currentState, CollectionsKt.minus((Iterable)((State.Stopping)currentState).getChildren(), (Iterable)children), null, 2, null);
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)var10_16, (Object)State.Idle.INSTANCE) || var10_16 instanceof State.Finished) {
                            v4 = currentState;
                            continue;
                        }
                        throw new NoWhenBranchMatchedException();
                    } while (!$this$update$iv.compareAndSet(value$iv, updated$iv = v4));
                    new Update<State>((State)value$iv, updated$iv);
                    ** GOTO lbl36
                }
                var6_9 = currentState;
                if (var6_9 instanceof State.Running) {
                    v5 = new State.Finished<T>(result);
                } else if (var6_9 instanceof State.Stopping) {
                    v5 = new State.Finished<T>((Either)EitherKt.toRight(((State.Stopping)currentState).getException()));
                } else {
                    throw new IllegalStateException(("Unexpected state: " + TaskImpl.access$getState$p(this.this$0)).toString());
                }
                finished = v5;
                if (TaskImpl.access$getState$p(this.this$0).compareAndSet(currentState, finished)) ** break;
                ** while (true)
                this.this$0.getValue().completeWith(finished.getResult());
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }), (Continuation)((Continuation)new Continuation<Unit>(coroutineContext){
            final /* synthetic */ CoroutineContext $context;
            {
                this.$context = $context;
            }

            public CoroutineContext getContext() {
                return this.$context;
            }

            public void resumeWith(Object result) {
                Object result2 = result;
                boolean bl = false;
                if (Result.isFailure-impl((Object)result2)) {
                    LoggingKt.error(TaskKt.access$getLogger$p(), "Exception in task handling", Result.exceptionOrNull-impl((Object)result2));
                }
            }
        }));
        Unit unit = Unit.INSTANCE;
        coroutineContext.resumeWith(Result.constructor-impl((Object)unit));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> Task<T> subtask(@Nullable String name, @NotNull CoroutineContext context, @NotNull Function2<? super Task<? extends T>, ? super Continuation<? super T>, ? extends Object> body) {
        State state;
        State updated$iv;
        State<T> value$iv;
        void $this$createAsyncTraces$iv$iv;
        void $this$withAsyncTraces$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        CoroutineContext coroutineContext = context;
        String title$iv = "subtask(" + name + ")";
        boolean $i$f$withAsyncTraces = false;
        void var8_9 = $this$withAsyncTraces$iv;
        String title$iv$iv = title$iv;
        boolean $i$f$createAsyncTraces = false;
        Object object = (AsyncTraces)$this$createAsyncTraces$iv$iv.get((CoroutineContext.Key)AsyncTraces.Key);
        if (object == null || (object = ((AsyncTraces)object).getFrames()) == null) {
            object = CollectionsKt.emptyList();
        }
        List frames$iv$iv = CollectionsKt.plus((Collection)((Collection)object), (Object)new AsyncTraces.Frame(title$iv$iv, null, 2, null));
        TaskImpl<T> subtask = new TaskImpl<T>(name, $this$withAsyncTraces$iv.plus((CoroutineContext)new AsyncTraces(frames$iv$iv)), body);
        AtomicReference<State<T>> $this$update$iv = this.state;
        boolean $i$f$update = false;
        do {
            State<T> currentState = value$iv = $this$update$iv.get();
            boolean bl = false;
            State<T> state2 = currentState;
            if (state2 instanceof State.Idle) {
                throw new IllegalStateException("Cannot call subtask() from the 'Idle' state".toString());
            }
            if (state2 instanceof State.Running) {
                state = ((State.Running)currentState).copy(CollectionsKt.plus((Collection)((State.Running)currentState).getChildren(), subtask));
                continue;
            }
            if (state2 instanceof State.Stopping) {
                state = State.Stopping.copy$default((State.Stopping)currentState, CollectionsKt.plus((Collection)((State.Stopping)currentState).getChildren(), subtask), null, 2, null);
                continue;
            }
            if (state2 instanceof State.Finished) {
                subtask.reject();
                return subtask;
            }
            throw new NoWhenBranchMatchedException();
        } while (!$this$update$iv.compareAndSet(value$iv, updated$iv = state));
        new Update<State>(value$iv, updated$iv);
        TaskKt.invokeOnStop((Task)subtask, (Function1<? super Throwable, Unit>)((Function1)arg_0 -> TaskImpl.subtask$lambda$4(this, arg_0)));
        TaskKt.invokeOnFinish((Task)subtask, arg_0 -> TaskImpl.subtask$lambda$6(this, subtask, arg_0));
        subtask.start();
        return subtask;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(@Nullable Throwable exception) {
        void $this$forEach$iv;
        State.Stopping stopping;
        State state;
        State updated$iv;
        State<T> value$iv;
        Lazy exception$delegate = LazyKt.lazy(() -> TaskImpl.stop$lambda$7(exception));
        AtomicReference<State<T>> $this$update$iv = this.state;
        boolean $i$f$update = false;
        do {
            State<T> currentState = value$iv = $this$update$iv.get();
            boolean bl = false;
            State<T> state2 = currentState;
            if (state2 instanceof State.Idle) {
                state = new State.Finished((Either)EitherKt.toRight(TaskImpl.stop$lambda$8((Lazy<? extends Throwable>)exception$delegate)));
                continue;
            }
            if (state2 instanceof State.Running) {
                state = new State.Stopping(((State.Running)currentState).getChildren(), TaskImpl.stop$lambda$8((Lazy<? extends Throwable>)exception$delegate));
                continue;
            }
            if (state2 instanceof State.Stopping) {
                return false;
            }
            if (state2 instanceof State.Finished) {
                return false;
            }
            throw new NoWhenBranchMatchedException();
        } while (!$this$update$iv.compareAndSet(value$iv, updated$iv = state));
        Object object = new Update<State>(value$iv, updated$iv).getUpdated();
        State.Stopping stopping2 = stopping = object instanceof State.Stopping ? (State.Stopping)object : null;
        List list = stopping2 != null ? stopping2.getChildren() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        object = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Task child = (Task)element$iv;
            boolean bl = false;
            child.stop(TaskImpl.stop$lambda$8((Lazy<? extends Throwable>)exception$delegate));
        }
        FutureKt.completeExceptionally(this.getOnStop(), TaskImpl.stop$lambda$8((Lazy<? extends Throwable>)exception$delegate));
        return true;
    }

    @Override
    public boolean isCompleted() {
        return this.getValue().isCompleted();
    }

    @Override
    @Nullable
    public Either<T, Throwable> getOrNull() {
        return this.getValue().getOrNull();
    }

    @Override
    @Nullable
    public Object await(@NotNull Continuation<? super Either<? extends T, ? extends Throwable>> $completion) {
        return this.getValue().await($completion);
    }

    @Override
    @NotNull
    public Disposable awaitWith(@NotNull Continuation<? super T> continuation) {
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        return this.getValue().awaitWith(continuation);
    }

    @Override
    @NotNull
    public CoroutineContext.Key<?> getKey() {
        return Task.DefaultImpls.getKey(this);
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
        return Task.DefaultImpls.get(this, key);
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        return Task.DefaultImpls.fold(this, initial, operation);
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
        return Task.DefaultImpls.minusKey(this, key);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context) {
        return Task.DefaultImpls.plus(this, context);
    }

    private static final Unit subtask$lambda$4(TaskImpl this$0, Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this$0.stop(exception);
        return Unit.INSTANCE;
    }

    private static final Unit subtask$lambda$6(TaskImpl this$0, TaskImpl $subtask, Either it) {
        State state;
        State updated$iv;
        State value$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AtomicReference $this$update$iv = this$0.state;
        boolean $i$f$update = false;
        do {
            State currentState = value$iv = $this$update$iv.get();
            boolean bl = false;
            State state2 = currentState;
            if (state2 instanceof State.Running) {
                state = ((State.Running)currentState).copy(CollectionsKt.minus((Iterable)((State.Running)currentState).getChildren(), (Object)$subtask));
                continue;
            }
            if (state2 instanceof State.Stopping) {
                state = State.Stopping.copy$default((State.Stopping)currentState, CollectionsKt.minus((Iterable)((State.Stopping)currentState).getChildren(), (Object)$subtask), null, 2, null);
                continue;
            }
            if (state2 instanceof State.Finished) {
                state = currentState;
                continue;
            }
            if (state2 instanceof State.Idle) {
                state = currentState;
                continue;
            }
            throw new NoWhenBranchMatchedException();
        } while (!$this$update$iv.compareAndSet(value$iv, updated$iv = state));
        new Update<State>(value$iv, updated$iv);
        return Unit.INSTANCE;
    }

    private static final Throwable stop$lambda$7(Throwable $exception) {
        Throwable throwable = $exception;
        if (throwable == null) {
            throwable = new StoppedException(null, 1, null);
        }
        return throwable;
    }

    private static final Throwable stop$lambda$8(Lazy<? extends Throwable> $exception$delegate) {
        Lazy<? extends Throwable> lazy = $exception$delegate;
        return (Throwable)lazy.getValue();
    }

    public static final /* synthetic */ CoroutineContext access$getCoroutineContext$p(TaskImpl $this) {
        return $this.coroutineContext;
    }

    public static final /* synthetic */ AtomicReference access$getState$p(TaskImpl $this) {
        return $this.state;
    }

    public static final /* synthetic */ Function2 access$getAction$p(TaskImpl $this) {
        return $this.action;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\u00020\u0002:\u0004\u0005\u0006\u0007\bB\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004\u0082\u0001\u0004\t\n\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/compose/reload/core/TaskImpl$State;", "T", "", "<init>", "()V", "Idle", "Running", "Stopping", "Finished", "Lorg/jetbrains/compose/reload/core/TaskImpl$State$Finished;", "Lorg/jetbrains/compose/reload/core/TaskImpl$State$Idle;", "Lorg/jetbrains/compose/reload/core/TaskImpl$State$Running;", "Lorg/jetbrains/compose/reload/core/TaskImpl$State$Stopping;", "hot-reload-core"})
    private static abstract class State<T> {
        private State() {
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\u001c\u0010\u0003\u001a\u0018\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00028\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00028\u0002`\u0006H\u00c6\u0003J/\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00020\u00002\u001e\b\u0002\u0010\u0003\u001a\u0018\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00028\u0002`\u0006H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R'\u0010\u0003\u001a\u0018\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00028\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/compose/reload/core/TaskImpl$State$Finished;", "T", "Lorg/jetbrains/compose/reload/core/TaskImpl$State;", "result", "Lorg/jetbrains/compose/reload/core/Either;", "", "Lorg/jetbrains/compose/reload/core/Try;", "<init>", "(Lorg/jetbrains/compose/reload/core/Either;)V", "getResult", "()Lorg/jetbrains/compose/reload/core/Either;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hot-reload-core"})
        public static final class Finished<T>
        extends State<T> {
            @NotNull
            private final Either<T, Throwable> result;

            public Finished(@NotNull Either<? extends T, ? extends Throwable> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                super(null);
                this.result = result;
            }

            @NotNull
            public final Either<T, Throwable> getResult() {
                return this.result;
            }

            @NotNull
            public final Either<T, Throwable> component1() {
                return this.result;
            }

            @NotNull
            public final Finished<T> copy(@NotNull Either<? extends T, ? extends Throwable> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                return new Finished<T>(result);
            }

            public static /* synthetic */ Finished copy$default(Finished finished, Either either, int n, Object object) {
                if ((n & 1) != 0) {
                    either = finished.result;
                }
                return finished.copy(either);
            }

            @NotNull
            public String toString() {
                return "Finished(result=" + this.result + ")";
            }

            public int hashCode() {
                return this.result.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Finished)) {
                    return false;
                }
                Finished finished = (Finished)other;
                return Intrinsics.areEqual(this.result, finished.result);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0013\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00d6\u0003J\t\u0010\t\u001a\u00020\nH\u00d6\u0001J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001\u00a8\u0006\r"}, d2={"Lorg/jetbrains/compose/reload/core/TaskImpl$State$Idle;", "Lorg/jetbrains/compose/reload/core/TaskImpl$State;", "", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "hot-reload-core"})
        public static final class Idle
        extends State {
            @NotNull
            public static final Idle INSTANCE = new Idle();

            private Idle() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Idle";
            }

            public int hashCode() {
                return -295903582;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Idle)) {
                    return false;
                }
                Idle cfr_ignored_0 = (Idle)other;
                return true;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\u0012\b\u0002\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u001b\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/compose/reload/core/TaskImpl$State$Running;", "Lorg/jetbrains/compose/reload/core/TaskImpl$State;", "", "children", "", "Lorg/jetbrains/compose/reload/core/Task;", "<init>", "(Ljava/util/List;)V", "getChildren", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hot-reload-core"})
        public static final class Running
        extends State {
            @NotNull
            private final List<Task<?>> children;

            public Running(@NotNull List<? extends Task<?>> children) {
                Intrinsics.checkNotNullParameter(children, (String)"children");
                super(null);
                this.children = children;
            }

            @NotNull
            public final List<Task<?>> getChildren() {
                return this.children;
            }

            @NotNull
            public final List<Task<?>> component1() {
                return this.children;
            }

            @NotNull
            public final Running copy(@NotNull List<? extends Task<?>> children) {
                Intrinsics.checkNotNullParameter(children, (String)"children");
                return new Running(children);
            }

            public static /* synthetic */ Running copy$default(Running running, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = running.children;
                }
                return running.copy(list);
            }

            @NotNull
            public String toString() {
                return "Running(children=" + this.children + ")";
            }

            public int hashCode() {
                return ((Object)this.children).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Running)) {
                    return false;
                }
                Running running = (Running)other;
                return Intrinsics.areEqual(this.children, running.children);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\u0012\b\u0002\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001b\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/compose/reload/core/TaskImpl$State$Stopping;", "Lorg/jetbrains/compose/reload/core/TaskImpl$State;", "", "children", "", "Lorg/jetbrains/compose/reload/core/Task;", "exception", "", "<init>", "(Ljava/util/List;Ljava/lang/Throwable;)V", "getChildren", "()Ljava/util/List;", "getException", "()Ljava/lang/Throwable;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hot-reload-core"})
        public static final class Stopping
        extends State {
            @NotNull
            private final List<Task<?>> children;
            @NotNull
            private final Throwable exception;

            public Stopping(@NotNull List<? extends Task<?>> children, @NotNull Throwable exception) {
                Intrinsics.checkNotNullParameter(children, (String)"children");
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                super(null);
                this.children = children;
                this.exception = exception;
            }

            @NotNull
            public final List<Task<?>> getChildren() {
                return this.children;
            }

            @NotNull
            public final Throwable getException() {
                return this.exception;
            }

            @NotNull
            public final List<Task<?>> component1() {
                return this.children;
            }

            @NotNull
            public final Throwable component2() {
                return this.exception;
            }

            @NotNull
            public final Stopping copy(@NotNull List<? extends Task<?>> children, @NotNull Throwable exception) {
                Intrinsics.checkNotNullParameter(children, (String)"children");
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new Stopping(children, exception);
            }

            public static /* synthetic */ Stopping copy$default(Stopping stopping, List list, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    list = stopping.children;
                }
                if ((n & 2) != 0) {
                    throwable = stopping.exception;
                }
                return stopping.copy(list, throwable);
            }

            @NotNull
            public String toString() {
                return "Stopping(children=" + this.children + ", exception=" + this.exception + ")";
            }

            public int hashCode() {
                int result = ((Object)this.children).hashCode();
                result = result * 31 + this.exception.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Stopping)) {
                    return false;
                }
                Stopping stopping = (Stopping)other;
                if (!Intrinsics.areEqual(this.children, stopping.children)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.exception, (Object)stopping.exception);
            }
        }
    }
}

