/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.gradle;

import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.InternalHotReloadApi;
import org.jetbrains.compose.reload.core.JavaHome;
import org.jetbrains.compose.reload.core.JavaReleaseFileContent;
import org.jetbrains.compose.reload.gradle.HotReloadGradleEnvironmentKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0007\u001a\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\u00020\u0003H\u0003\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0002*\u00020\u0003H\u0002\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\u0002*\u00020\u0003H\u0002\u001a\u0014\u0010\b\u001a\u00020\u0002*\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"jetbrainsRuntimeLauncher", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "Lorg/gradle/api/Project;", "jetbrainsRuntimeVersion", "Lorg/gradle/jvm/toolchain/JavaLanguageVersion;", "providedJetBrainsRuntimeLauncher", "intellijJetBrainsRuntimeLauncher", "createJavaLauncher", "javaHome", "Lorg/jetbrains/compose/reload/core/JavaHome;", "hot-reload-gradle-core"})
@SourceDebugExtension(value={"SMAP\njetbrainsRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jetbrainsRuntime.kt\norg/jetbrains/compose/reload/gradle/JetbrainsRuntimeKt\n+ 2 ProjectExtensions.kt\norg/gradle/kotlin/dsl/support/ProjectExtensionsKt\n+ 3 ServiceRegistryExtensions.kt\norg/gradle/kotlin/dsl/support/ServiceRegistryExtensionsKt\n+ 4 ExtensionContainerExtensions.kt\norg/gradle/kotlin/dsl/ExtensionContainerExtensionsKt\n+ 5 TypeOfExtensions.kt\norg/gradle/kotlin/dsl/TypeOfExtensionsKt\n*L\n1#1,136:1\n27#2:137\n22#3:138\n123#4:139\n28#5:140\n*S KotlinDebug\n*F\n+ 1 jetbrainsRuntime.kt\norg/jetbrains/compose/reload/gradle/JetbrainsRuntimeKt\n*L\n54#1:137\n54#1:138\n73#1:139\n73#1:140\n*E\n"})
public final class JetbrainsRuntimeKt {
    @InternalHotReloadApi
    @NotNull
    public static final Provider<JavaLauncher> jetbrainsRuntimeLauncher(@NotNull Project $this$jetbrainsRuntimeLauncher) {
        Intrinsics.checkNotNullParameter((Object)$this$jetbrainsRuntimeLauncher, (String)"<this>");
        Project $this$serviceOf$iv = $this$jetbrainsRuntimeLauncher;
        boolean $i$f$serviceOf = false;
        ServiceRegistry serviceRegistry = ((ProjectInternal)$this$serviceOf$iv).getServices();
        Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry, (String)"this as ProjectInternal).services");
        ServiceRegistry $this$get$iv$iv = serviceRegistry;
        boolean $i$f$get = false;
        Object object = $this$get$iv$iv.get(JavaToolchainService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this[T::class.java]");
        Provider provisionedLauncher = ((JavaToolchainService)object).launcherFor(arg_0 -> JetbrainsRuntimeKt.jetbrainsRuntimeLauncher$lambda$1(arg_0 -> JetbrainsRuntimeKt.jetbrainsRuntimeLauncher$lambda$0($this$jetbrainsRuntimeLauncher, arg_0), arg_0));
        Provider provider = $this$jetbrainsRuntimeLauncher.getProject().provider(() -> JetbrainsRuntimeKt.jetbrainsRuntimeLauncher$lambda$2($this$jetbrainsRuntimeLauncher, provisionedLauncher));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"provider(...)");
        return provider;
    }

    @InternalHotReloadApi
    private static final Provider<JavaLanguageVersion> jetbrainsRuntimeVersion(Project $this$jetbrainsRuntimeVersion) {
        JavaLanguageVersion defaultVersion = JavaLanguageVersion.of((int)HotReloadGradleEnvironmentKt.getComposeReloadJetBrainsRuntimeVersion($this$jetbrainsRuntimeVersion));
        Provider provider = $this$jetbrainsRuntimeVersion.getProject().provider(() -> JetbrainsRuntimeKt.jetbrainsRuntimeVersion$lambda$0($this$jetbrainsRuntimeVersion, defaultVersion));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"provider(...)");
        return provider;
    }

    private static final JavaLauncher providedJetBrainsRuntimeLauncher(Project $this$providedJetBrainsRuntimeLauncher) {
        Path path = HotReloadGradleEnvironmentKt.getComposeReloadJetBrainsRuntimeBinary($this$providedJetBrainsRuntimeLauncher);
        if (path == null) {
            return null;
        }
        Path executablePath = path;
        JavaHome javaHome = JavaHome.Companion.fromExecutable(executablePath);
        return JetbrainsRuntimeKt.createJavaLauncher($this$providedJetBrainsRuntimeLauncher, javaHome);
    }

    private static final JavaLauncher intellijJetBrainsRuntimeLauncher(Project $this$intellijJetBrainsRuntimeLauncher) {
        Path path = HotReloadGradleEnvironmentKt.getComposeReloadIdeaJetBrainsRuntimeBinary($this$intellijJetBrainsRuntimeLauncher);
        if (path == null) {
            return null;
        }
        Path executablePath = path;
        JavaHome javaHome = JavaHome.Companion.fromExecutable(executablePath);
        return JetbrainsRuntimeKt.createJavaLauncher($this$intellijJetBrainsRuntimeLauncher, javaHome);
    }

    private static final JavaLauncher createJavaLauncher(Project $this$createJavaLauncher, JavaHome javaHome) {
        JavaReleaseFileContent releaseFileContent = javaHome.readReleaseFile();
        String string = releaseFileContent.getJavaVersion();
        if (string == null) {
            throw new IllegalStateException(("Missing 'JAVA_VERSION' in '" + javaHome + "'").toString());
        }
        String javaVersion = string;
        ProjectLayout layout = $this$createJavaLauncher.getProject().getLayout();
        return new JavaLauncher(javaVersion, releaseFileContent, layout, javaHome){
            final /* synthetic */ String $javaVersion;
            final /* synthetic */ JavaReleaseFileContent $releaseFileContent;
            final /* synthetic */ ProjectLayout $layout;
            final /* synthetic */ JavaHome $javaHome;
            {
                this.$javaVersion = $javaVersion;
                this.$releaseFileContent = $releaseFileContent;
                this.$layout = $layout;
                this.$javaHome = $javaHome;
            }

            public JavaInstallationMetadata getMetadata() {
                return new JavaInstallationMetadata(this.$javaVersion, this.$releaseFileContent, this.$layout, this.$javaHome){
                    final /* synthetic */ String $javaVersion;
                    final /* synthetic */ JavaReleaseFileContent $releaseFileContent;
                    final /* synthetic */ ProjectLayout $layout;
                    final /* synthetic */ JavaHome $javaHome;
                    {
                        this.$javaVersion = $javaVersion;
                        this.$releaseFileContent = $releaseFileContent;
                        this.$layout = $layout;
                        this.$javaHome = $javaHome;
                    }

                    public JavaLanguageVersion getLanguageVersion() {
                        String[] stringArray = new String[]{"."};
                        JavaLanguageVersion javaLanguageVersion = JavaLanguageVersion.of((int)Integer.parseInt((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)this.$javaVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null))));
                        Intrinsics.checkNotNullExpressionValue((Object)javaLanguageVersion, (String)"of(...)");
                        return javaLanguageVersion;
                    }

                    public String getJavaRuntimeVersion() {
                        String string = this.$releaseFileContent.getJavaRuntimeVersion();
                        if (string == null) {
                            string = "N/A";
                        }
                        return string;
                    }

                    public String getJvmVersion() {
                        String string = this.$releaseFileContent.getImplementorVersion();
                        if (string == null) {
                            string = "N/A";
                        }
                        return string;
                    }

                    public String getVendor() {
                        String string = this.$releaseFileContent.getImplementor();
                        if (string == null) {
                            string = "N/A";
                        }
                        return string;
                    }

                    public Directory getInstallationPath() {
                        Directory directory = this.$layout.getProjectDirectory().dir(((Object)this.$javaHome.getPath().toAbsolutePath()).toString());
                        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"dir(...)");
                        return directory;
                    }

                    public boolean isCurrentJvm() {
                        return Intrinsics.areEqual((Object)JavaHome.Companion.current(), (Object)this.$javaHome);
                    }
                };
            }

            public RegularFile getExecutablePath() {
                RegularFile regularFile = this.$layout.getProjectDirectory().file(((Object)this.$javaHome.getJavaExecutable().toAbsolutePath()).toString());
                Intrinsics.checkNotNullExpressionValue((Object)regularFile, (String)"file(...)");
                return regularFile;
            }
        };
    }

    private static final Unit jetbrainsRuntimeLauncher$lambda$0(Project $this_jetbrainsRuntimeLauncher, JavaToolchainSpec spec) {
        spec.getVendor().set((Object)JvmVendorSpec.JETBRAINS);
        spec.getLanguageVersion().set(JetbrainsRuntimeKt.jetbrainsRuntimeVersion($this_jetbrainsRuntimeLauncher));
        return Unit.INSTANCE;
    }

    private static final void jetbrainsRuntimeLauncher$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final JavaLauncher jetbrainsRuntimeLauncher$lambda$2(Project $this_jetbrainsRuntimeLauncher, Provider $provisionedLauncher) {
        JavaLauncher javaLauncher;
        try {
            JavaLauncher javaLauncher2 = JetbrainsRuntimeKt.providedJetBrainsRuntimeLauncher($this_jetbrainsRuntimeLauncher);
            if (javaLauncher2 == null) {
                javaLauncher2 = (JavaLauncher)$provisionedLauncher.get();
            }
            javaLauncher = javaLauncher2;
        }
        catch (Throwable e) {
            JavaLauncher javaLauncher3 = JetbrainsRuntimeKt.intellijJetBrainsRuntimeLauncher($this_jetbrainsRuntimeLauncher);
            if (javaLauncher3 == null) {
                throw e;
            }
            javaLauncher = javaLauncher3;
        }
        return javaLauncher;
    }

    private static final JavaLanguageVersion jetbrainsRuntimeVersion$lambda$0(Project $this_jetbrainsRuntimeVersion, JavaLanguageVersion $defaultVersion) {
        JavaLanguageVersion projectLevel;
        ExtensionContainer extensionContainer = $this_jetbrainsRuntimeVersion.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"getExtensions(...)");
        ExtensionContainer $this$findByType$iv = extensionContainer;
        boolean $i$f$findByType = false;
        boolean $i$f$typeOf = false;
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)$this$findByType$iv.findByType((TypeOf)new TypeOf<JavaPluginExtension>(){});
        JavaLanguageVersion javaLanguageVersion = javaPluginExtension != null && (javaPluginExtension = javaPluginExtension.getToolchain()) != null && (javaPluginExtension = javaPluginExtension.getLanguageVersion()) != null ? (JavaLanguageVersion)javaPluginExtension.getOrNull() : (projectLevel = null);
        if (projectLevel != null && projectLevel.compareTo((Object)$defaultVersion) > 0) {
            return projectLevel;
        }
        return $defaultVersion;
    }
}

