/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.devtools;

import io.sellmair.evas.State;
import io.sellmair.evas.States;
import io.sellmair.evas.StatesKt;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.devtools.Main;
import org.jetbrains.compose.devtools.OrchestrationKt;
import org.jetbrains.compose.devtools.ShutdownAction;
import org.jetbrains.compose.devtools.ShutdownThread;
import org.jetbrains.compose.devtools.states.DtLifecycleState;
import org.jetbrains.compose.reload.core.Disposable;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.core.Task;
import org.jetbrains.compose.reload.core.TaskKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientRole;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0000\u001a\n\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "setupShutdownProcedure", "", "shutdown", "", "invokeOnShutdown", "Lorg/jetbrains/compose/reload/core/Disposable;", "action", "Lkotlin/Function0;", "shutdownReportFile", "Ljava/nio/file/Path;", "shutdownErrorReportFile", "hot-reload-devtools"})
@SourceDebugExtension(value={"SMAP\nshutdown.kt\nKotlin\n*S Kotlin\n*F\n+ 1 shutdown.kt\norg/jetbrains/compose/devtools/ShutdownKt\n+ 2 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,164:1\n22#2:165\n*S KotlinDebug\n*F\n+ 1 shutdown.kt\norg/jetbrains/compose/devtools/ShutdownKt\n*L\n32#1:165\n*E\n"})
public final class ShutdownKt {
    @NotNull
    private static final Logger logger;
    @Nullable
    private static final Path shutdownReportFile;

    public static final void setupShutdownProcedure() {
        Runtime.getRuntime().addShutdownHook(ShutdownThread.INSTANCE);
        Path path = shutdownReportFile;
        if (path != null) {
            Files.deleteIfExists(path);
        }
        ShutdownKt.invokeOnShutdown((Function0<Unit>)((Function0)ShutdownKt::setupShutdownProcedure$lambda$0));
        Thread.setDefaultUncaughtExceptionHandler(ShutdownKt::setupShutdownProcedure$lambda$1);
    }

    @NotNull
    public static final Void shutdown() {
        States states = StatesKt.getStatesOrNull((CoroutineContext)Main.getApplicationScope().getCoroutineContext());
        if (states != null) {
            states.setState((State.Key)DtLifecycleState.Key, (State)new DtLifecycleState(false));
        }
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    @NotNull
    public static final Disposable invokeOnShutdown(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ShutdownAction action2 = new ShutdownAction(action, null, 2, null);
        ShutdownThread.INSTANCE.getActions().add(action2);
        return () -> ShutdownKt.invokeOnShutdown$lambda$0(action2);
    }

    private static final Path shutdownErrorReportFile() {
        Path path = HotReloadEnvironment.INSTANCE.getPidFile();
        if (path == null) {
            return null;
        }
        Path pidFile = path;
        int n = 128;
        int n2 = 0;
        while (n2 < n) {
            int index = n2++;
            boolean bl = false;
            Path reportFile = pidFile.resolveSibling("shutdown-error." + index + ".log");
            Intrinsics.checkNotNull((Object)reportFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(reportFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            return reportFile;
        }
        return null;
    }

    private static final Unit setupShutdownProcedure$lambda$0() {
        LoggingKt.info((Logger)logger, (String)"Shutting down...");
        return Unit.INSTANCE;
    }

    private static final void setupShutdownProcedure$lambda$1(Thread thread, Throwable e) {
        LoggingKt.error((Logger)logger, (String)("Uncaught exception in thread '" + thread.getName() + "': " + e.getMessage()), (Throwable)e);
        TaskKt.launchTask((Function2)new Function2<Task, Continuation<?>, Object>(thread, e, null){
            int label;
            final /* synthetic */ Thread $thread;
            final /* synthetic */ Throwable $e;
            {
                this.$thread = $thread;
                this.$e = $e;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = "Uncaught Exception in " + this.$thread.getName() + ": " + this.$e.getMessage();
                        v1 = this.$e.getClass().getName();
                        v2 = this.$e.getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStackTrace(...)");
                        this.label = 1;
                        v3 = OrchestrationKt.send((OrchestrationMessage)new OrchestrationMessage.CriticalException(OrchestrationClientRole.Tooling, v0, v1, ArraysKt.toList((Object[])v2)), (Continuation<? super Unit>)((Continuation)this));
                        if (v3 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl17:
                        // 2 sources

                        ShutdownKt.shutdown();
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Task p1, Continuation<?> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final void invokeOnShutdown$lambda$0(ShutdownAction $action) {
        ShutdownThread.INSTANCE.getActions().remove($action);
    }

    public static final /* synthetic */ Path access$getShutdownReportFile$p() {
        return shutdownReportFile;
    }

    public static final /* synthetic */ Path access$shutdownErrorReportFile() {
        return ShutdownKt.shutdownErrorReportFile();
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string2 = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default((String)string2, null, null, (int)6, null);
        Path path = HotReloadEnvironment.INSTANCE.getPidFile();
        shutdownReportFile = path != null ? path.resolveSibling("shutdown.log") : null;
    }
}

