/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.devtools;

import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Optional;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.devtools.OrchestrationKt;
import org.jetbrains.compose.devtools.ShutdownKt;
import org.jetbrains.compose.reload.core.CoroutinesKt;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.Future;
import org.jetbrains.compose.reload.core.FutureKt;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.jetbrains.compose.reload.core.HotReloadProperty;
import org.jetbrains.compose.reload.core.LockFile;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.core.PidFileInfo;
import org.jetbrains.compose.reload.core.PidFileInfoKt;
import org.jetbrains.compose.reload.core.PidFileLockKt;
import org.jetbrains.compose.reload.core.ReloadMainThreadKt;
import org.jetbrains.compose.reload.core.Task;
import org.jetbrains.compose.reload.core.TaskKt;
import org.jetbrains.compose.reload.core.WorkerThread;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientRole;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\b\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\b\u0010\u0005\u001a\u00020\u0003H\u0002\u001a\b\u0010\u0006\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "setupDevToolsProcess", "", "setupExceptionHandler", "bindParentProcess", "setupOrchestration", "hot-reload-devtools"})
@SourceDebugExtension(value={"SMAP\nprocess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 process.kt\norg/jetbrains/compose/devtools/ProcessKt\n+ 2 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,81:1\n22#2:82\n*S KotlinDebug\n*F\n+ 1 process.kt\norg/jetbrains/compose/devtools/ProcessKt\n*L\n26#1:82\n*E\n"})
public final class ProcessKt {
    @NotNull
    private static final Logger logger;

    public static final void setupDevToolsProcess() {
        ProcessKt.setupExceptionHandler();
        ShutdownKt.setupShutdownProcedure();
        ProcessKt.setupOrchestration();
        ProcessKt.bindParentProcess();
    }

    private static final void setupExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(ProcessKt::setupExceptionHandler$lambda$0);
    }

    private static final void bindParentProcess() {
        Long l = HotReloadEnvironment.INSTANCE.getParentPid();
        if (l == null) {
            boolean bl = false;
            LoggingKt.error$default((Logger)logger, (String)"parentPid: Missing", null, (int)2, null);
            ShutdownKt.shutdown();
            throw new KotlinNothingValueException();
        }
        long pid = l;
        if (HotReloadEnvironment.INSTANCE.getPidFile() == null) {
            LoggingKt.warn((Logger)logger, (String)("parentPid: Missing '" + HotReloadProperty.PidFile.getKey() + "' property"));
        }
        Optional<ProcessHandle> optional = ProcessHandle.of(pid);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        ProcessHandle processHandle = (ProcessHandle)OptionalsKt.getOrNull(optional);
        if (processHandle == null) {
            boolean bl = false;
            LoggingKt.error$default((Logger)logger, (String)("parentPid: Cannot find process with pid=" + pid), null, (int)2, null);
            ShutdownKt.shutdown();
            throw new KotlinNothingValueException();
        }
        ProcessHandle process = processHandle;
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> ProcessKt.bindParentProcess$lambda$2(process, pid), (int)31, null);
    }

    private static final void setupOrchestration() {
        FutureKt.invokeOnCompletion((Future)((Future)OrchestrationKt.getOrchestration()), ProcessKt::setupOrchestration$lambda$0);
    }

    private static final void setupExceptionHandler$lambda$0(Thread thread, Throwable exception) {
        LoggingKt.error((Logger)logger, (String)("Uncaught exception in thread '" + thread.getName() + "': " + exception.getMessage()), (Throwable)exception);
        TaskKt.launchTask((Function2)new Function2<Task, Continuation<?>, Object>(exception, null){
            int label;
            final /* synthetic */ Throwable $exception;
            {
                this.$exception = $exception;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        LoggingKt.error$default((Logger)ProcessKt.access$getLogger$p(), (String)("Initiating shutdown because of uncaught exception: " + this.$exception.getClass().getSimpleName()), null, (int)2, null);
                        var2_3 = this.$exception;
                        Intrinsics.checkNotNull((Object)var2_3);
                        OrchestrationKt.sendAsync((OrchestrationMessage)new OrchestrationMessage.CriticalException(OrchestrationClientRole.Tooling, var2_3));
                        this.label = 1;
                        v0 = CoroutinesKt.awaitIdle((WorkerThread)ReloadMainThreadKt.getReloadMainThread(), (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        ShutdownKt.shutdown();
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Task p1, Continuation<?> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final Unit bindParentProcess$lambda$2(ProcessHandle $process, long $pid) {
        $process.onExit().get();
        LoggingKt.debug((Logger)logger, (String)("parentPid: Parent process with pid=" + $pid + " exited"));
        try {
            boolean bl = false;
            LockFile lockFile = PidFileLockKt.getRunDirectoryLockFile();
            Object object = Result.constructor-impl((Object)(lockFile != null ? (Boolean)lockFile.withLock(() -> ProcessKt.bindParentProcess$lambda$2$0$0($pid)) : null));
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        ShutdownKt.shutdown();
        throw new KotlinNothingValueException();
    }

    private static final Boolean bindParentProcess$lambda$2$0$0(long $pid) {
        Boolean bl;
        Path path = HotReloadEnvironment.INSTANCE.getPidFile();
        if (path != null) {
            Either either = OrchestrationKt.getOrchestration().getPort().getOrNull();
            bl = PidFileInfoKt.deleteMyPidFileIfExists((Path)path, (PidFileInfo)new PidFileInfo(Long.valueOf($pid), either != null ? (Integer)either.leftOrNull() : null));
        } else {
            bl = null;
        }
        return bl;
    }

    private static final Unit setupOrchestration$lambda$0(Either it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ShutdownKt.shutdown();
        throw new KotlinNothingValueException();
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string2 = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default((String)string2, null, null, (int)6, null);
    }
}

