/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.devtools;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.devtools.LoggingKt;
import org.jetbrains.compose.devtools.ShutdownAction;
import org.jetbrains.compose.devtools.ShutdownKt;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.core.TryKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/compose/devtools/ShutdownThread;", "Ljava/lang/Thread;", "<init>", "()V", "actions", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lorg/jetbrains/compose/devtools/ShutdownAction;", "getActions", "()Ljava/util/concurrent/LinkedBlockingQueue;", "run", "", "logShutdownActionFailure", "action", "exception", "", "hot-reload-devtools"})
@SourceDebugExtension(value={"SMAP\nshutdown.kt\nKotlin\n*S Kotlin\n*F\n+ 1 shutdown.kt\norg/jetbrains/compose/devtools/ShutdownThread\n+ 2 Try.kt\norg/jetbrains/compose/reload/core/TryKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n16#2,4:166\n13472#3,2:170\n13472#3,2:173\n13472#3,2:176\n1869#4:172\n1870#4:175\n1#5:178\n*S KotlinDebug\n*F\n+ 1 shutdown.kt\norg/jetbrains/compose/devtools/ShutdownThread\n*L\n110#1:166,4\n143#1:170,2\n151#1:173,2\n158#1:176,2\n148#1:172\n148#1:175\n*E\n"})
final class ShutdownThread
extends Thread {
    @NotNull
    public static final ShutdownThread INSTANCE = new ShutdownThread();
    @NotNull
    private static final LinkedBlockingQueue<ShutdownAction> actions = new LinkedBlockingQueue();

    private ShutdownThread() {
        super("shutdown");
    }

    @NotNull
    public final LinkedBlockingQueue<ShutdownAction> getActions() {
        return actions;
    }

    @Override
    public void run() {
        block12: {
            BufferedWriter shutdownReportWriter;
            BufferedWriter bufferedWriter;
            long startInstant = System.currentTimeMillis();
            Path path = ShutdownKt.access$getShutdownReportFile$p();
            if (path != null && (path = PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0])) != null) {
                Path path2 = path;
                OpenOption[] openOptionArray = new OpenOption[]{};
                Charset charset = Charsets.UTF_8;
                int n = 8192;
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(path2, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset), n);
            } else {
                bufferedWriter = null;
            }
            BufferedWriter bufferedWriter2 = shutdownReportWriter = bufferedWriter;
            if (bufferedWriter2 != null) {
                ((Appendable)bufferedWriter2).append("Shutting down (DevTools '" + ProcessHandle.current().pid() + "')").append('\n');
            }
            BufferedWriter bufferedWriter3 = shutdownReportWriter;
            if (bufferedWriter3 != null) {
                ((Appendable)bufferedWriter3).append("Shutdown actions registered: " + actions.size()).append('\n');
            }
            BufferedWriter bufferedWriter4 = shutdownReportWriter;
            if (bufferedWriter4 != null) {
                bufferedWriter4.flush();
            }
            int totalFailures = 0;
            int totalSuccess = 0;
            while (!((Collection)actions).isEmpty()) {
                Either either;
                ShutdownAction action;
                if (actions.poll() == null) continue;
                boolean $i$f$Try = false;
                try {
                    boolean bl = false;
                    action.getWork().invoke();
                    either = (Either)EitherKt.toLeft((Object)Unit.INSTANCE);
                }
                catch (Throwable t$iv) {
                    either = (Either)EitherKt.toRight((Object)t$iv);
                }
                Either result2 = either;
                if (TryKt.isSuccess((Either)result2)) {
                    ++totalSuccess;
                }
                if (!TryKt.isFailure((Either)result2)) continue;
                ++totalFailures;
                this.logShutdownActionFailure(action, TryKt.getException((Right)((Right)result2)));
            }
            long endInstant = System.currentTimeMillis();
            long duration = DurationKt.toDuration((long)(endInstant - startInstant), (DurationUnit)DurationUnit.MILLISECONDS);
            BufferedWriter bufferedWriter5 = shutdownReportWriter;
            if (bufferedWriter5 != null) {
                ((Appendable)bufferedWriter5).append("Shutdown actions completed: " + totalSuccess + ", failed: " + totalFailures).append('\n');
            }
            BufferedWriter bufferedWriter6 = shutdownReportWriter;
            if (bufferedWriter6 != null) {
                ((Appendable)bufferedWriter6).append("Shutdown duration: " + Duration.toString-impl((long)duration)).append('\n');
            }
            while ((Logger.Log)LoggingKt.getDevtoolsLoggingQueue().nextOrNull().leftOrNull() != null) {
                Logger.Log log;
                BufferedWriter bufferedWriter7 = shutdownReportWriter;
                if (bufferedWriter7 == null) continue;
                ((Appendable)bufferedWriter7).append(org.jetbrains.compose.reload.core.LoggingKt.displayString$default((Logger.Log)log, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)31, null)).append('\n');
            }
            BufferedWriter bufferedWriter8 = shutdownReportWriter;
            if (bufferedWriter8 == null) break block12;
            bufferedWriter8.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void logShutdownActionFailure(ShutdownAction action, Throwable exception) {
        block15: {
            Object object;
            Object object2 = this;
            try {
                Unit unit;
                ShutdownThread $this$logShutdownActionFailure_u24lambda_u240 = object2;
                boolean bl = false;
                Path path = ShutdownKt.access$shutdownErrorReportFile();
                if (path != null && (path = PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0])) != null) {
                    Object object3 = path;
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    Object object4 = Charsets.UTF_8;
                    int n = 8192;
                    object3 = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object3, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object4), n);
                    object4 = null;
                    try {
                        BufferedWriter writer = (BufferedWriter)object3;
                        boolean bl2 = false;
                        ((Appendable)writer).append("Failed to execute shutdown action:").append('\n');
                        ((Appendable)writer).append(exception.getMessage()).append('\n');
                        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                        Object $this$forEach$iv = stackTraceElementArray;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            StackTraceElement element = (StackTraceElement)element$iv;
                            boolean bl3 = false;
                            ((Appendable)writer).append("  at " + element).append('\n');
                        }
                        if (!((Collection)ExceptionsKt.getSuppressedExceptions((Throwable)exception)).isEmpty()) {
                            ((Appendable)writer).append('\n');
                        }
                        $this$forEach$iv = ExceptionsKt.getSuppressedExceptions((Throwable)exception);
                        $i$f$forEach = false;
                        Iterator iterator = $this$forEach$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv = iterator.next();
                            Throwable suppressed = (Throwable)element$iv;
                            boolean bl4 = false;
                            ((Appendable)writer).append("Suppressed:").append('\n');
                            ((Appendable)writer).append(suppressed.getMessage()).append('\n');
                            StackTraceElement[] stackTraceElementArray2 = suppressed.getStackTrace();
                            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray2, (String)"getStackTrace(...)");
                            Object[] $this$forEach$iv2 = stackTraceElementArray2;
                            boolean $i$f$forEach2 = false;
                            for (Object element$iv2 : $this$forEach$iv2) {
                                StackTraceElement element = (StackTraceElement)element$iv2;
                                boolean bl5 = false;
                                ((Appendable)writer).append("  at " + element).append('\n');
                            }
                        }
                        ((Appendable)writer).append('\n');
                        ((Appendable)writer).append("Registration:").append('\n');
                        $this$forEach$iv = action.getRegistration();
                        $i$f$forEach = false;
                        int n2 = ((Object)$this$forEach$iv).length;
                        for (int i = 0; i < n2; ++i) {
                            Object element$iv;
                            Object element = element$iv = $this$forEach$iv[i];
                            boolean bl6 = false;
                            ((Appendable)writer).append("    at " + (StackTraceElement)element).append('\n');
                        }
                        Unit unit2 = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        object4 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                object = Result.constructor-impl(unit);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block15;
            Object e = object = throwable;
            boolean bl = false;
            ((Throwable)e).printStackTrace();
        }
    }
}

