/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.devtools;

import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Optional;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.devtools.OrchestrationKt;
import org.jetbrains.compose.devtools.ShutdownKt;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.Future;
import org.jetbrains.compose.reload.core.FutureKt;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.jetbrains.compose.reload.core.HotReloadProperty;
import org.jetbrains.compose.reload.core.LockFile;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.core.PidFileInfo;
import org.jetbrains.compose.reload.core.PidFileInfoKt;
import org.jetbrains.compose.reload.core.PidFileLockKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\b\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\b\u0010\u0005\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "setupDevToolsProcess", "", "bindParentProcess", "setupOrchestration", "hot-reload-devtools"})
@SourceDebugExtension(value={"SMAP\nprocess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 process.kt\norg/jetbrains/compose/devtools/ProcessKt\n+ 2 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,63:1\n22#2:64\n*S KotlinDebug\n*F\n+ 1 process.kt\norg/jetbrains/compose/devtools/ProcessKt\n*L\n21#1:64\n*E\n"})
public final class ProcessKt {
    @NotNull
    private static final Logger logger;

    public static final void setupDevToolsProcess() {
        ShutdownKt.setupShutdownProcedure();
        ProcessKt.setupOrchestration();
        ProcessKt.bindParentProcess();
    }

    private static final void bindParentProcess() {
        Long l = HotReloadEnvironment.INSTANCE.getParentPid();
        if (l == null) {
            boolean bl = false;
            LoggingKt.error$default((Logger)logger, (String)"parentPid: Missing", null, (int)2, null);
            ShutdownKt.shutdown();
            throw new KotlinNothingValueException();
        }
        long pid = l;
        if (HotReloadEnvironment.INSTANCE.getPidFile() == null) {
            LoggingKt.warn((Logger)logger, (String)("parentPid: Missing '" + HotReloadProperty.PidFile.getKey() + "' property"));
        }
        Optional<ProcessHandle> optional = ProcessHandle.of(pid);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        ProcessHandle processHandle = (ProcessHandle)OptionalsKt.getOrNull(optional);
        if (processHandle == null) {
            boolean bl = false;
            LoggingKt.error$default((Logger)logger, (String)("parentPid: Cannot find process with pid=" + pid), null, (int)2, null);
            ShutdownKt.shutdown();
            throw new KotlinNothingValueException();
        }
        ProcessHandle process = processHandle;
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> ProcessKt.bindParentProcess$lambda$2(process, pid), (int)31, null);
    }

    private static final void setupOrchestration() {
        FutureKt.invokeOnCompletion((Future)((Future)OrchestrationKt.getOrchestration()), ProcessKt::setupOrchestration$lambda$0);
    }

    private static final Unit bindParentProcess$lambda$2(ProcessHandle $process, long $pid) {
        $process.onExit().get();
        LoggingKt.debug((Logger)logger, (String)("parentPid: Parent process with pid=" + $pid + " exited"));
        try {
            boolean bl = false;
            LockFile lockFile = PidFileLockKt.getRunDirectoryLockFile();
            Object object = Result.constructor-impl((Object)(lockFile != null ? (Boolean)lockFile.withLock(() -> ProcessKt.bindParentProcess$lambda$2$0$0($pid)) : null));
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        ShutdownKt.shutdown();
        throw new KotlinNothingValueException();
    }

    private static final Boolean bindParentProcess$lambda$2$0$0(long $pid) {
        Boolean bl;
        Path path = HotReloadEnvironment.INSTANCE.getPidFile();
        if (path != null) {
            Either either = OrchestrationKt.getOrchestration().getPort().getOrNull();
            bl = PidFileInfoKt.deleteMyPidFileIfExists((Path)path, (PidFileInfo)new PidFileInfo(Long.valueOf($pid), either != null ? (Integer)either.leftOrNull() : null));
        } else {
            bl = null;
        }
        return bl;
    }

    private static final Unit setupOrchestration$lambda$0(Either it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ShutdownKt.shutdown();
        throw new KotlinNothingValueException();
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string2 = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default((String)string2, null, null, (int)6, null);
    }
}

