/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.InternalHotReloadApi;
import org.jetbrains.compose.reload.core.JavaReleaseFileContent;
import org.jetbrains.compose.reload.core.JdkKt;
import org.jetbrains.compose.reload.core.Os;

@InternalHotReloadApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/compose/reload/core/JavaHome;", "", "path", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getPath", "()Ljava/nio/file/Path;", "javaExecutable", "getJavaExecutable", "releaseFile", "getReleaseFile", "readReleaseFile", "Lorg/jetbrains/compose/reload/core/JavaReleaseFileContent;", "toString", "", "hashCode", "", "equals", "", "other", "Companion", "hot-reload-core"})
public final class JavaHome {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;

    public JavaHome(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final Path getJavaExecutable() {
        Path path = this.path.resolve("bin").resolve(Os.Companion.currentOrNull() == Os.Windows ? "java.exe" : "java");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getReleaseFile() {
        Path path = this.path.resolve("release");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final JavaReleaseFileContent readReleaseFile() {
        return JdkKt.access$parseJavaReleaseFile(this.getReleaseFile());
    }

    @NotNull
    public String toString() {
        return "JavaHome(" + ((Object)this.path.toAbsolutePath()).toString() + ")";
    }

    public int hashCode() {
        return ((Object)this.path).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaHome)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)this.path.toAbsolutePath()).toString(), (Object)((Object)((JavaHome)other).path.toAbsolutePath()).toString());
    }

    @InternalHotReloadApi
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lorg/jetbrains/compose/reload/core/JavaHome$Companion;", "", "<init>", "()V", "fromExecutable", "Lorg/jetbrains/compose/reload/core/JavaHome;", "path", "Ljava/nio/file/Path;", "current", "hot-reload-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaHome fromExecutable(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Path path2 = path.getParent().getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
            return new JavaHome(path2);
        }

        @NotNull
        public final JavaHome current() {
            String string = System.getProperty("java.home");
            if (string != null) {
                String javaHome = string;
                boolean bl = false;
                Path path = Paths.get(javaHome, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                return new JavaHome(path);
            }
            String string2 = System.getenv("JAVA_HOME");
            if (string2 != null) {
                String javaHome = string2;
                boolean bl = false;
                Path path = Paths.get(javaHome, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                return new JavaHome(path);
            }
            throw new IllegalStateException("Missing 'java.home' System property or 'JAVA_HOME' environment variable");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

