package org.jetbrains.compose.reload.core

import org.jetbrains.compose.reload.InternalHotReloadApi
import org.jetbrains.compose.reload.DelicateHotReloadApi
import org.jetbrains.compose.reload.ExperimentalHotReloadApi

public enum class HotReloadProperty(
    public val key: String,
    public val type: Type,
    public val default: String?,
    public val targets: List<Environment>,
    public val visibility: Visibility,
) {
    /**
    * - 'compose.reload.orchestration.port'
    * - Available in [Environment.BuildTool], [Environment.DevTools], [Environment.Application]
    */
    @InternalHotReloadApi
    OrchestrationPort(
        "compose.reload.orchestration.port",
        type = Type.Int,
        default = "null",
        targets = listOf(Environment.BuildTool, Environment.DevTools, Environment.Application),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.pidFile'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    @InternalHotReloadApi
    PidFile(
        "compose.reload.pidFile",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.argfile'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    */
    @InternalHotReloadApi
    ArgFile(
        "compose.reload.argfile",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.mainClass'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    @InternalHotReloadApi
    MainClass(
        "compose.reload.mainClass",
        type = Type.String,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.headless'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    * - default: 'false'
    */
    @InternalHotReloadApi
    IsHeadless(
        "compose.reload.headless",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.isHotReloadBuild'
    * - Available in [Environment.BuildTool]
    * - default: 'false'
    */
    @InternalHotReloadApi
    IsHotReloadBuild(
        "compose.reload.isHotReloadBuild",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.BuildTool),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.hotApplicationClasspath'
    * - Available in [Environment.Application]
    */
    @InternalHotReloadApi
    HotClasspath(
        "compose.reload.hotApplicationClasspath",
        type = Type.String,
        default = "null",
        targets = listOf(Environment.Application),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.virtualMethodResolveEnabled'
    * - Available in [Environment.Application], [Environment.BuildTool]
    * - default: 'true'
    */
    @InternalHotReloadApi
    VirtualMethodResolveEnabled(
        "compose.reload.virtualMethodResolveEnabled",
        type = Type.Boolean,
        default = "true",
        targets = listOf(Environment.Application, Environment.BuildTool),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.dirtyResolveDepthLimit'
    * - Available in [Environment.Application], [Environment.BuildTool]
    * - default: '5'
    */
    @InternalHotReloadApi
    DirtyResolveDepthLimit(
        "compose.reload.dirtyResolveDepthLimit",
        type = Type.Int,
        default = "5",
        targets = listOf(Environment.Application, Environment.BuildTool),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.buildSystem'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    @InternalHotReloadApi
    BuildSystem(
        "compose.reload.buildSystem",
        type = Type.Enum,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'org.gradle.java.home'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    @InternalHotReloadApi
    GradleJavaHome(
        "org.gradle.java.home",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'gradle.offline.mode'
    * - Available in [Environment.Application], [Environment.DevTools]
    * - default: 'false'
    */
    @InternalHotReloadApi
    GradleOfflineMode(
        "gradle.offline.mode",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application, Environment.DevTools),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'gradle.build.root'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    @InternalHotReloadApi
    GradleBuildRoot(
        "gradle.build.root",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'gradle.build.project'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    @InternalHotReloadApi
    GradleBuildProject(
        "gradle.build.project",
        type = Type.String,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'gradle.build.task'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    @InternalHotReloadApi
    GradleBuildTask(
        "gradle.build.task",
        type = Type.String,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.build.continuous'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    * - default: 'false'
    */
    @DelicateHotReloadApi
    GradleBuildContinuous(
        "compose.reload.build.continuous",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
        visibility = Visibility.Delicate,
    ),
    /**
    * - 'compose.reload.build.warmup'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    * - default: 'false'
    */
    @DelicateHotReloadApi
    GradleWarmupEnabled(
        "compose.reload.build.warmup",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
        visibility = Visibility.Delicate,
    ),
    /**
    * - 'compose.reload.gradle.build.optimize'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    * - default: 'true'
    */
    @DelicateHotReloadApi
    GradleBuildOptimize(
        "compose.reload.gradle.build.optimize",
        type = Type.Boolean,
        default = "true",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
        visibility = Visibility.Delicate,
    ),
    /**
    * - 'amper.build.root'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    @InternalHotReloadApi
    AmperBuildRoot(
        "amper.build.root",
        type = Type.String,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'amper.build.task'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    @InternalHotReloadApi
    AmperBuildTask(
        "amper.build.task",
        type = Type.String,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.devToolsEnabled'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    * - default: 'true'
    */
    DevToolsEnabled(
        "compose.reload.devToolsEnabled",
        type = Type.Boolean,
        default = "true",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
        visibility = Visibility.Public,
    ),
    /**
    * - 'compose.reload.devToolsHeadless'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    * - default: 'false'
    */
    DevToolsIsHeadless(
        "compose.reload.devToolsHeadless",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
        visibility = Visibility.Public,
    ),
    /**
    * - 'compose.reload.devToolsClasspath'
    * - Available in [Environment.Application]
    */
    @InternalHotReloadApi
    DevToolsClasspath(
        "compose.reload.devToolsClasspath",
        type = Type.Files,
        default = "null",
        targets = listOf(Environment.Application),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.devToolsTransparencyEnabled'
    * - Available in [Environment.Application], [Environment.BuildTool], [Environment.DevTools]
    * - default: '(Os.currentOrNull() != Os.Linux).toString()'
    */
    @DelicateHotReloadApi
    DevToolsTransparencyEnabled(
        "compose.reload.devToolsTransparencyEnabled",
        type = Type.Boolean,
        default = (Os.currentOrNull() != Os.Linux).toString(),
        targets = listOf(Environment.Application, Environment.BuildTool, Environment.DevTools),
        visibility = Visibility.Delicate,
    ),
    /**
    * - 'compose.reload.devToolsDetached'
    * - Available in [Environment.Application], [Environment.BuildTool], [Environment.DevTools]
    * - default: 'false'
    */
    DevToolsDetached(
        "compose.reload.devToolsDetached",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application, Environment.BuildTool, Environment.DevTools),
        visibility = Visibility.Public,
    ),
    /**
    * - 'compose.reload.effectsEnabled'
    * - Available in [Environment.Application], [Environment.BuildTool]
    * - default: 'true'
    */
    ReloadEffectsEnabled(
        "compose.reload.effectsEnabled",
        type = Type.Boolean,
        default = "true",
        targets = listOf(Environment.Application, Environment.BuildTool),
        visibility = Visibility.Public,
    ),
    /**
    * - 'compose.reload.idea.debugger.dispatch.port'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    */
    @InternalHotReloadApi
    IntelliJDebuggerDispatchPort(
        "compose.reload.idea.debugger.dispatch.port",
        type = Type.Int,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.subprocessDebuggingEnabled'
    * - Available in [Environment.BuildTool]
    * - default: 'false'
    */
    @InternalHotReloadApi
    SubprocessDebuggingEnabled(
        "compose.reload.subprocessDebuggingEnabled",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.BuildTool),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.jbr.binary'
    * - Available in [Environment.BuildTool]
    */
    @DelicateHotReloadApi
    JetBrainsRuntimeBinary(
        "compose.reload.jbr.binary",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.BuildTool),
        visibility = Visibility.Delicate,
    ),
    /**
    * - 'compose.reload.jbr.version'
    * - Available in [Environment.BuildTool]
    * - default: '21'
    */
    @DelicateHotReloadApi
    JetBrainsRuntimeVersion(
        "compose.reload.jbr.version",
        type = Type.Int,
        default = "21",
        targets = listOf(Environment.BuildTool),
        visibility = Visibility.Delicate,
    ),
    /**
    * - 'compose.reload.autoRuntimeDependenciesEnabled'
    * - Available in [Environment.BuildTool]
    * - default: 'true'
    */
    @InternalHotReloadApi
    AutoRuntimeDependenciesEnabled(
        "compose.reload.autoRuntimeDependenciesEnabled",
        type = Type.Boolean,
        default = "true",
        targets = listOf(Environment.BuildTool),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'idea.compose.hot-reload'
    * - Available in [Environment.BuildTool], [Environment.Application], [Environment.DevTools]
    * - default: 'false'
    */
    @InternalHotReloadApi
    IdeaComposeHotReload(
        "idea.compose.hot-reload",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.BuildTool, Environment.Application, Environment.DevTools),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'idea.compose.hot-reload.version'
    * - Available in [Environment.BuildTool], [Environment.Application], [Environment.DevTools]
    */
    @InternalHotReloadApi
    IdeaComposeHotReloadSupportVersion(
        "idea.compose.hot-reload.version",
        type = Type.Int,
        default = "null",
        targets = listOf(Environment.BuildTool, Environment.Application, Environment.DevTools),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'idea.compose.hot-reload.jbr'
    * - Available in [Environment.BuildTool]
    */
    @InternalHotReloadApi
    IdeaJetBrainsRuntimeBinary(
        "idea.compose.hot-reload.jbr",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.BuildTool),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.stdinFile'
    * - Available in [Environment.BuildTool], [Environment.Application], [Environment.DevTools]
    */
    @DelicateHotReloadApi
    StdinFile(
        "compose.reload.stdinFile",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.BuildTool, Environment.Application, Environment.DevTools),
        visibility = Visibility.Delicate,
    ),
    /**
    * - 'compose.reload.stdoutFile'
    * - Available in [Environment.BuildTool], [Environment.Application], [Environment.DevTools]
    */
    @DelicateHotReloadApi
    StdoutFile(
        "compose.reload.stdoutFile",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.BuildTool, Environment.Application, Environment.DevTools),
        visibility = Visibility.Delicate,
    ),
    /**
    * - 'compose.reload.stderrFile'
    * - Available in [Environment.BuildTool], [Environment.Application], [Environment.DevTools]
    */
    @DelicateHotReloadApi
    StderrFile(
        "compose.reload.stderrFile",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.BuildTool, Environment.Application, Environment.DevTools),
        visibility = Visibility.Delicate,
    ),
    /**
    * - 'compose.reload.parentPid'
    * - Available in [Environment.DevTools], [Environment.BuildTool]
    */
    @InternalHotReloadApi
    ParentPid(
        "compose.reload.parentPid",
        type = Type.Long,
        default = "null",
        targets = listOf(Environment.DevTools, Environment.BuildTool),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.launchMode'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    @InternalHotReloadApi
    LaunchMode(
        "compose.reload.launchMode",
        type = Type.Enum,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
        visibility = Visibility.Internal,
    ),
    /**
    * - 'compose.reload.logLevel'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    * - default: 'Info'
    */
    LogLevel(
        "compose.reload.logLevel",
        type = Type.Enum,
        default = "Info",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
        visibility = Visibility.Public,
    ),
    /**
    * - 'compose.reload.logStdout'
    * - Available in [Environment.Application], [Environment.BuildTool], [Environment.DevTools]
    * - default: 'false'
    */
    LogStdout(
        "compose.reload.logStdout",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application, Environment.BuildTool, Environment.DevTools),
        visibility = Visibility.Public,
    ),
    /**
    * - 'compose.reload.isActive'
    * - Available in [Environment.Application]
    * - default: 'false'
    */
    IsHotReloadActive(
        "compose.reload.isActive",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application),
        visibility = Visibility.Public,
    ),
;
    
    public enum class Environment {
        BuildTool, DevTools, Application;
    }

    public enum class Type {
        String, Int, Long, Boolean, File, Files, Enum
    }

    public enum class Visibility {
        Public, Delicate, Experimental, Internal, Deprecated
    }
}