/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core.testFixtures;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.core.testFixtures.FileUtilsKt;
import org.jetbrains.compose.reload.test.core.TestEnvironment;
import org.junit.jupiter.api.AssertionsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"assertFileContent", "", "expectFile", "Ljava/nio/file/Path;", "actualText", "", "hot-reload-core_testFixtures"})
public final class AssertFileContentKt {
    public static final void assertFileContent(@NotNull Path expectFile, @NotNull String actualText) {
        Intrinsics.checkNotNullParameter((Object)expectFile, (String)"expectFile");
        Intrinsics.checkNotNullParameter((Object)actualText, (String)"actualText");
        PathsKt.createParentDirectories((Path)expectFile, (FileAttribute[])new FileAttribute[0]);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(expectFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || TestEnvironment.INSTANCE.getUpdateTestData()) {
            PathsKt.writeText$default((Path)expectFile, (CharSequence)FileUtilsKt.sanitized(actualText), null, (OpenOption[])new OpenOption[0], (int)2, null);
            if (!TestEnvironment.INSTANCE.getUpdateTestData()) {
                throw new IllegalStateException((expectFile.toUri() + " did not exist; Generated").toString());
            }
        }
        if (!Intrinsics.areEqual((Object)FileUtilsKt.sanitized(PathsKt.readText$default((Path)expectFile, null, (int)1, null)), (Object)FileUtilsKt.sanitized(actualText))) {
            Path actualFile = expectFile.resolveSibling(PathsKt.getNameWithoutExtension((Path)expectFile) + "-actual." + PathsKt.getExtension((Path)expectFile));
            Intrinsics.checkNotNull((Object)actualFile);
            PathsKt.writeText$default((Path)actualFile, (CharSequence)FileUtilsKt.sanitized(actualText), null, (OpenOption[])new OpenOption[0], (int)2, null);
            AssertionsKt.fail$default((String)(expectFile.toUri() + " did not match\n" + actualFile.toUri()), null, (int)2, null);
            throw new KotlinNothingValueException();
        }
    }
}

