/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.InternalHotReloadApi;
import org.jetbrains.compose.reload.core.BuildSystem;
import org.jetbrains.compose.reload.core.LaunchMode;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.Os;

@InternalHotReloadApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010 \n\u0002\b\u0017\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u0017\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000bR\u0011\u0010\"\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0014R\u0013\u0010$\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000bR\u0013\u0010&\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0011R\u0013\u0010(\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0011R\u0011\u0010*\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0014R\u0011\u0010,\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0014R\u0011\u0010.\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0014R\u0013\u00100\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0011R\u0013\u00102\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0011R\u0011\u00104\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0014R\u0011\u00106\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0014R\u0019\u00108\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u0001098F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0014R\u0011\u0010>\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u0014R\u0011\u0010@\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u0014R\u0011\u0010B\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u0014R\u0013\u0010D\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\bE\u0010\u0007R\u0011\u0010F\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u0014R\u0013\u0010H\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\bI\u0010\u0007R\u0013\u0010J\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010\u000bR\u0013\u0010L\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010\u000bR\u0013\u0010N\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u000bR\u0013\u0010P\u001a\u0004\u0018\u00010Q8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\u0013\u0010T\u001a\u0004\u0018\u00010U8F\u00a2\u0006\u0006\u001a\u0004\bV\u0010WR\u0011\u0010X\u001a\u00020Y8F\u00a2\u0006\u0006\u001a\u0004\bZ\u0010[R\u0011\u0010\\\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b]\u0010\u0014R\u0011\u0010^\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b^\u0010\u0014\u00a8\u0006_"}, d2={"Lorg/jetbrains/compose/reload/core/HotReloadEnvironment;", "", "<init>", "()V", "orchestrationPort", "", "getOrchestrationPort", "()Ljava/lang/Integer;", "pidFile", "Ljava/nio/file/Path;", "getPidFile", "()Ljava/nio/file/Path;", "argFile", "getArgFile", "mainClass", "", "getMainClass", "()Ljava/lang/String;", "isHeadless", "", "()Z", "hotClasspath", "getHotClasspath", "virtualMethodResolveEnabled", "getVirtualMethodResolveEnabled", "dirtyResolveDepthLimit", "getDirtyResolveDepthLimit", "()I", "buildSystem", "Lorg/jetbrains/compose/reload/core/BuildSystem;", "getBuildSystem", "()Lorg/jetbrains/compose/reload/core/BuildSystem;", "gradleJavaHome", "getGradleJavaHome", "gradleOfflineMode", "getGradleOfflineMode", "gradleBuildRoot", "getGradleBuildRoot", "gradleBuildProject", "getGradleBuildProject", "gradleBuildTask", "getGradleBuildTask", "gradleBuildContinuous", "getGradleBuildContinuous", "gradleWarmupEnabled", "getGradleWarmupEnabled", "gradleBuildOptimize", "getGradleBuildOptimize", "amperBuildRoot", "getAmperBuildRoot", "amperBuildTask", "getAmperBuildTask", "devToolsEnabled", "getDevToolsEnabled", "devToolsIsHeadless", "getDevToolsIsHeadless", "devToolsClasspath", "", "getDevToolsClasspath", "()Ljava/util/List;", "devToolsTransparencyEnabled", "getDevToolsTransparencyEnabled", "devToolsDetached", "getDevToolsDetached", "devToolsAnimationsEnabled", "getDevToolsAnimationsEnabled", "reloadEffectsEnabled", "getReloadEffectsEnabled", "intelliJDebuggerDispatchPort", "getIntelliJDebuggerDispatchPort", "ideaComposeHotReload", "getIdeaComposeHotReload", "ideaComposeHotReloadSupportVersion", "getIdeaComposeHotReloadSupportVersion", "stdinFile", "getStdinFile", "stdoutFile", "getStdoutFile", "stderrFile", "getStderrFile", "parentPid", "", "getParentPid", "()Ljava/lang/Long;", "launchMode", "Lorg/jetbrains/compose/reload/core/LaunchMode;", "getLaunchMode", "()Lorg/jetbrains/compose/reload/core/LaunchMode;", "logLevel", "Lorg/jetbrains/compose/reload/core/Logger$Level;", "getLogLevel", "()Lorg/jetbrains/compose/reload/core/Logger$Level;", "logStdout", "getLogStdout", "isHotReloadActive", "hot-reload-core"})
@SourceDebugExtension(value={"SMAP\nHotReloadEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotReloadEnvironment.kt\norg/jetbrains/compose/reload/core/HotReloadEnvironment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,535:1\n1563#2:536\n1634#2,3:537\n*S KotlinDebug\n*F\n+ 1 HotReloadEnvironment.kt\norg/jetbrains/compose/reload/core/HotReloadEnvironment\n*L\n305#1:536\n305#1:537,3\n*E\n"})
public final class HotReloadEnvironment {
    @NotNull
    public static final HotReloadEnvironment INSTANCE = new HotReloadEnvironment();

    private HotReloadEnvironment() {
    }

    @Nullable
    public final Integer getOrchestrationPort() {
        String string = System.getProperty("compose.reload.orchestration.port");
        if (string == null && (string = System.getenv("compose.reload.orchestration.port")) == null) {
            return null;
        }
        String value = string;
        return Integer.parseInt(value);
    }

    @Nullable
    public final Path getPidFile() {
        String string = System.getProperty("compose.reload.pidFile");
        if (string == null && (string = System.getenv("compose.reload.pidFile")) == null) {
            return null;
        }
        String value = string;
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final Path getArgFile() {
        String string = System.getProperty("compose.reload.argfile");
        if (string == null && (string = System.getenv("compose.reload.argfile")) == null) {
            return null;
        }
        String value = string;
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final String getMainClass() {
        String string = System.getProperty("compose.reload.mainClass");
        if (string == null && (string = System.getenv("compose.reload.mainClass")) == null) {
            return null;
        }
        String value = string;
        return value;
    }

    public final boolean isHeadless() {
        String string = System.getProperty("compose.reload.headless");
        if (string == null && (string = System.getenv("compose.reload.headless")) == null) {
            string = "false";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    @Nullable
    public final String getHotClasspath() {
        String string = System.getProperty("compose.reload.hotApplicationClasspath");
        if (string == null && (string = System.getenv("compose.reload.hotApplicationClasspath")) == null) {
            return null;
        }
        String value = string;
        return value;
    }

    public final boolean getVirtualMethodResolveEnabled() {
        String string = System.getProperty("compose.reload.virtualMethodResolveEnabled");
        if (string == null && (string = System.getenv("compose.reload.virtualMethodResolveEnabled")) == null) {
            string = "true";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    public final int getDirtyResolveDepthLimit() {
        String string = System.getProperty("compose.reload.dirtyResolveDepthLimit");
        if (string == null && (string = System.getenv("compose.reload.dirtyResolveDepthLimit")) == null) {
            string = "5";
        }
        String value = string;
        return Integer.parseInt(value);
    }

    @Nullable
    public final BuildSystem getBuildSystem() {
        String string = System.getProperty("compose.reload.buildSystem");
        if (string == null && (string = System.getenv("compose.reload.buildSystem")) == null) {
            return null;
        }
        String value = string;
        return BuildSystem.valueOf(value);
    }

    @Nullable
    public final Path getGradleJavaHome() {
        String string = System.getProperty("org.gradle.java.home");
        if (string == null && (string = System.getenv("org.gradle.java.home")) == null) {
            return null;
        }
        String value = string;
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    public final boolean getGradleOfflineMode() {
        String string = System.getProperty("gradle.offline.mode");
        if (string == null && (string = System.getenv("gradle.offline.mode")) == null) {
            string = "false";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    @Nullable
    public final Path getGradleBuildRoot() {
        String string = System.getProperty("gradle.build.root");
        if (string == null && (string = System.getenv("gradle.build.root")) == null) {
            return null;
        }
        String value = string;
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final String getGradleBuildProject() {
        String string = System.getProperty("gradle.build.project");
        if (string == null && (string = System.getenv("gradle.build.project")) == null) {
            return null;
        }
        String value = string;
        return value;
    }

    @Nullable
    public final String getGradleBuildTask() {
        String string = System.getProperty("gradle.build.task");
        if (string == null && (string = System.getenv("gradle.build.task")) == null) {
            return null;
        }
        String value = string;
        return value;
    }

    public final boolean getGradleBuildContinuous() {
        String string = System.getProperty("compose.reload.build.continuous");
        if (string == null && (string = System.getenv("compose.reload.build.continuous")) == null) {
            string = "false";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    public final boolean getGradleWarmupEnabled() {
        String string = System.getProperty("compose.reload.build.warmup");
        if (string == null && (string = System.getenv("compose.reload.build.warmup")) == null) {
            string = "false";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    public final boolean getGradleBuildOptimize() {
        String string = System.getProperty("compose.reload.gradle.build.optimize");
        if (string == null && (string = System.getenv("compose.reload.gradle.build.optimize")) == null) {
            string = "true";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    @Nullable
    public final String getAmperBuildRoot() {
        String string = System.getProperty("amper.build.root");
        if (string == null && (string = System.getenv("amper.build.root")) == null) {
            return null;
        }
        String value = string;
        return value;
    }

    @Nullable
    public final String getAmperBuildTask() {
        String string = System.getProperty("amper.build.task");
        if (string == null && (string = System.getenv("amper.build.task")) == null) {
            return null;
        }
        String value = string;
        return value;
    }

    public final boolean getDevToolsEnabled() {
        String string = System.getProperty("compose.reload.devToolsEnabled");
        if (string == null && (string = System.getenv("compose.reload.devToolsEnabled")) == null) {
            string = "true";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    public final boolean getDevToolsIsHeadless() {
        String string = System.getProperty("compose.reload.devToolsHeadless");
        if (string == null && (string = System.getenv("compose.reload.devToolsHeadless")) == null) {
            string = "false";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<Path> getDevToolsClasspath() {
        void $this$mapTo$iv$iv;
        String string = System.getProperty("compose.reload.devToolsClasspath");
        if (string == null && (string = System.getenv("compose.reload.devToolsClasspath")) == null) {
            return null;
        }
        String value = string;
        CharSequence charSequence = value;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = Paths.get((String)p0, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            collection.add(path);
        }
        return (List)destination$iv$iv;
    }

    public final boolean getDevToolsTransparencyEnabled() {
        String string = System.getProperty("compose.reload.devToolsTransparencyEnabled");
        if (string == null && (string = System.getenv("compose.reload.devToolsTransparencyEnabled")) == null) {
            string = String.valueOf(Os.Companion.currentOrNull() != Os.Linux);
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    public final boolean getDevToolsDetached() {
        String string = System.getProperty("compose.reload.devToolsDetached");
        if (string == null && (string = System.getenv("compose.reload.devToolsDetached")) == null) {
            string = "false";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    public final boolean getDevToolsAnimationsEnabled() {
        String string = System.getProperty("compose.reload.devToolsAnimationsEnabled");
        if (string == null && (string = System.getenv("compose.reload.devToolsAnimationsEnabled")) == null) {
            string = "true";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    public final boolean getReloadEffectsEnabled() {
        String string = System.getProperty("compose.reload.effectsEnabled");
        if (string == null && (string = System.getenv("compose.reload.effectsEnabled")) == null) {
            string = "true";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    @Nullable
    public final Integer getIntelliJDebuggerDispatchPort() {
        String string = System.getProperty("compose.reload.idea.debugger.dispatch.port");
        if (string == null && (string = System.getenv("compose.reload.idea.debugger.dispatch.port")) == null) {
            return null;
        }
        String value = string;
        return Integer.parseInt(value);
    }

    public final boolean getIdeaComposeHotReload() {
        String string = System.getProperty("idea.compose.hot-reload");
        if (string == null && (string = System.getenv("idea.compose.hot-reload")) == null) {
            string = "false";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    @Nullable
    public final Integer getIdeaComposeHotReloadSupportVersion() {
        String string = System.getProperty("idea.compose.hot-reload.version");
        if (string == null && (string = System.getenv("idea.compose.hot-reload.version")) == null) {
            return null;
        }
        String value = string;
        return Integer.parseInt(value);
    }

    @Nullable
    public final Path getStdinFile() {
        String string = System.getProperty("compose.reload.stdinFile");
        if (string == null && (string = System.getenv("compose.reload.stdinFile")) == null) {
            return null;
        }
        String value = string;
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final Path getStdoutFile() {
        String string = System.getProperty("compose.reload.stdoutFile");
        if (string == null && (string = System.getenv("compose.reload.stdoutFile")) == null) {
            return null;
        }
        String value = string;
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final Path getStderrFile() {
        String string = System.getProperty("compose.reload.stderrFile");
        if (string == null && (string = System.getenv("compose.reload.stderrFile")) == null) {
            return null;
        }
        String value = string;
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final Long getParentPid() {
        String string = System.getProperty("compose.reload.parentPid");
        if (string == null && (string = System.getenv("compose.reload.parentPid")) == null) {
            return null;
        }
        String value = string;
        return Long.parseLong(value);
    }

    @Nullable
    public final LaunchMode getLaunchMode() {
        String string = System.getProperty("compose.reload.launchMode");
        if (string == null && (string = System.getenv("compose.reload.launchMode")) == null) {
            return null;
        }
        String value = string;
        return LaunchMode.valueOf(value);
    }

    @NotNull
    public final Logger.Level getLogLevel() {
        String string = System.getProperty("compose.reload.logLevel");
        if (string == null && (string = System.getenv("compose.reload.logLevel")) == null) {
            string = "Info";
        }
        String value = string;
        return Logger.Level.valueOf(value);
    }

    public final boolean getLogStdout() {
        String string = System.getProperty("compose.reload.logStdout");
        if (string == null && (string = System.getenv("compose.reload.logStdout")) == null) {
            string = "false";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    public final boolean isHotReloadActive() {
        String string = System.getProperty("compose.reload.isActive");
        if (string == null && (string = System.getenv("compose.reload.isActive")) == null) {
            string = "false";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }
}

