package org.jetbrains.compose.reload.core

import org.jetbrains.compose.reload.InternalHotReloadApi

@InternalHotReloadApi
public enum class HotReloadProperty(
    public val key: String,
    public val type: Type,
    public val default: String?,
    public val targets: List<Environment>,
) {
    /**
    * - 'compose.reload.orchestration.port'
    * - Available in [Environment.BuildTool], [Environment.DevTools], [Environment.Application]
    */
    OrchestrationPort(
        "compose.reload.orchestration.port",
        type = Type.Int,
        default = "null",
        targets = listOf(Environment.BuildTool, Environment.DevTools, Environment.Application),
    ),
    /**
    * - 'compose.reload.pidFile'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    PidFile(
        "compose.reload.pidFile",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'compose.reload.argfile'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    */
    ArgFile(
        "compose.reload.argfile",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.mainClass'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    MainClass(
        "compose.reload.mainClass",
        type = Type.String,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'compose.reload.headless'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    * - default: 'false'
    */
    IsHeadless(
        "compose.reload.headless",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.isHotReloadBuild'
    * - Available in [Environment.BuildTool]
    * - default: 'false'
    */
    IsHotReloadBuild(
        "compose.reload.isHotReloadBuild",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.hotApplicationClasspath'
    * - Available in [Environment.Application]
    */
    HotClasspath(
        "compose.reload.hotApplicationClasspath",
        type = Type.String,
        default = "null",
        targets = listOf(Environment.Application),
    ),
    /**
    * - 'compose.reload.virtualMethodResolveEnabled'
    * - Available in [Environment.Application], [Environment.BuildTool]
    * - default: 'true'
    */
    VirtualMethodResolveEnabled(
        "compose.reload.virtualMethodResolveEnabled",
        type = Type.Boolean,
        default = "true",
        targets = listOf(Environment.Application, Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.dirtyResolveDepthLimit'
    * - Available in [Environment.Application], [Environment.BuildTool]
    * - default: '5'
    */
    DirtyResolveDepthLimit(
        "compose.reload.dirtyResolveDepthLimit",
        type = Type.Int,
        default = "5",
        targets = listOf(Environment.Application, Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.buildSystem'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    BuildSystem(
        "compose.reload.buildSystem",
        type = Type.Enum,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'org.gradle.java.home'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    GradleJavaHome(
        "org.gradle.java.home",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'gradle.offline.mode'
    * - Available in [Environment.Application], [Environment.DevTools]
    * - default: 'false'
    */
    GradleOfflineMode(
        "gradle.offline.mode",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'gradle.build.root'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    GradleBuildRoot(
        "gradle.build.root",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'gradle.build.project'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    GradleBuildProject(
        "gradle.build.project",
        type = Type.String,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'gradle.build.task'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    GradleBuildTask(
        "gradle.build.task",
        type = Type.String,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'compose.reload.build.continuous'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    * - default: 'false'
    */
    @org.jetbrains.compose.reload.DelicateHotReloadApi
    GradleBuildContinuous(
        "compose.reload.build.continuous",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.build.warmup'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    * - default: 'false'
    */
    @org.jetbrains.compose.reload.DelicateHotReloadApi
    GradleWarmupEnabled(
        "compose.reload.build.warmup",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.gradle.build.optimize'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    * - default: 'true'
    */
    @org.jetbrains.compose.reload.DelicateHotReloadApi
    GradleBuildOptimize(
        "compose.reload.gradle.build.optimize",
        type = Type.Boolean,
        default = "true",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
    ),
    /**
    * - 'amper.build.root'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    AmperBuildRoot(
        "amper.build.root",
        type = Type.String,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'amper.build.task'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    AmperBuildTask(
        "amper.build.task",
        type = Type.String,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'compose.reload.devToolsEnabled'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    * - default: 'true'
    */
    DevToolsEnabled(
        "compose.reload.devToolsEnabled",
        type = Type.Boolean,
        default = "true",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.devToolsHeadless'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    * - default: 'false'
    */
    DevToolsIsHeadless(
        "compose.reload.devToolsHeadless",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.devToolsClasspath'
    * - Available in [Environment.Application]
    */
    DevToolsClasspath(
        "compose.reload.devToolsClasspath",
        type = Type.Files,
        default = "null",
        targets = listOf(Environment.Application),
    ),
    /**
    * - 'compose.reload.devToolsTransparencyEnabled'
    * - Available in [Environment.Application], [Environment.BuildTool], [Environment.DevTools]
    * - default: '(Os.currentOrNull() != Os.Linux).toString()'
    */
    @org.jetbrains.compose.reload.DelicateHotReloadApi
    DevToolsTransparencyEnabled(
        "compose.reload.devToolsTransparencyEnabled",
        type = Type.Boolean,
        default = (Os.currentOrNull() != Os.Linux).toString(),
        targets = listOf(Environment.Application, Environment.BuildTool, Environment.DevTools),
    ),
    /**
    * - 'compose.reload.devToolsDetached'
    * - Available in [Environment.Application], [Environment.BuildTool], [Environment.DevTools]
    * - default: 'false'
    */
    DevToolsDetached(
        "compose.reload.devToolsDetached",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application, Environment.BuildTool, Environment.DevTools),
    ),
    /**
    * - 'compose.reload.devToolsAnimationsEnabled'
    * - Available in [Environment.Application], [Environment.BuildTool], [Environment.DevTools]
    * - default: 'true'
    */
    @org.jetbrains.compose.reload.DelicateHotReloadApi
    DevToolsAnimationsEnabled(
        "compose.reload.devToolsAnimationsEnabled",
        type = Type.Boolean,
        default = "true",
        targets = listOf(Environment.Application, Environment.BuildTool, Environment.DevTools),
    ),
    /**
    * - 'compose.reload.effectsEnabled'
    * - Available in [Environment.Application], [Environment.BuildTool]
    * - default: 'true'
    */
    ReloadEffectsEnabled(
        "compose.reload.effectsEnabled",
        type = Type.Boolean,
        default = "true",
        targets = listOf(Environment.Application, Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.idea.debugger.dispatch.port'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    */
    IntelliJDebuggerDispatchPort(
        "compose.reload.idea.debugger.dispatch.port",
        type = Type.Int,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.subprocessDebuggingEnabled'
    * - Available in [Environment.BuildTool]
    * - default: 'false'
    */
    @org.jetbrains.compose.reload.DelicateHotReloadApi
    SubprocessDebuggingEnabled(
        "compose.reload.subprocessDebuggingEnabled",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.jbr.binary'
    * - Available in [Environment.BuildTool]
    */
    JetBrainsRuntimeBinary(
        "compose.reload.jbr.binary",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.autoRuntimeDependenciesEnabled'
    * - Available in [Environment.BuildTool]
    * - default: 'true'
    */
    AutoRuntimeDependenciesEnabled(
        "compose.reload.autoRuntimeDependenciesEnabled",
        type = Type.Boolean,
        default = "true",
        targets = listOf(Environment.BuildTool),
    ),
    /**
    * - 'idea.compose.hot-reload'
    * - Available in [Environment.BuildTool], [Environment.Application], [Environment.DevTools]
    * - default: 'false'
    */
    IdeaComposeHotReload(
        "idea.compose.hot-reload",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.BuildTool, Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'idea.compose.hot-reload.version'
    * - Available in [Environment.BuildTool], [Environment.Application], [Environment.DevTools]
    */
    IdeaComposeHotReloadSupportVersion(
        "idea.compose.hot-reload.version",
        type = Type.Int,
        default = "null",
        targets = listOf(Environment.BuildTool, Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'compose.reload.stdinFile'
    * - Available in [Environment.BuildTool], [Environment.Application], [Environment.DevTools]
    */
    @org.jetbrains.compose.reload.DelicateHotReloadApi
    StdinFile(
        "compose.reload.stdinFile",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.BuildTool, Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'compose.reload.stdoutFile'
    * - Available in [Environment.BuildTool], [Environment.Application], [Environment.DevTools]
    */
    @org.jetbrains.compose.reload.DelicateHotReloadApi
    StdoutFile(
        "compose.reload.stdoutFile",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.BuildTool, Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'compose.reload.stderrFile'
    * - Available in [Environment.BuildTool], [Environment.Application], [Environment.DevTools]
    */
    @org.jetbrains.compose.reload.DelicateHotReloadApi
    StderrFile(
        "compose.reload.stderrFile",
        type = Type.File,
        default = "null",
        targets = listOf(Environment.BuildTool, Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'compose.reload.parentPid'
    * - Available in [Environment.DevTools], [Environment.BuildTool]
    */
    ParentPid(
        "compose.reload.parentPid",
        type = Type.Long,
        default = "null",
        targets = listOf(Environment.DevTools, Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.launchMode'
    * - Available in [Environment.Application], [Environment.DevTools]
    */
    LaunchMode(
        "compose.reload.launchMode",
        type = Type.Enum,
        default = "null",
        targets = listOf(Environment.Application, Environment.DevTools),
    ),
    /**
    * - 'compose.reload.logLevel'
    * - Available in [Environment.Application], [Environment.DevTools], [Environment.BuildTool]
    * - default: 'Info'
    */
    LogLevel(
        "compose.reload.logLevel",
        type = Type.Enum,
        default = "Info",
        targets = listOf(Environment.Application, Environment.DevTools, Environment.BuildTool),
    ),
    /**
    * - 'compose.reload.logStdout'
    * - Available in [Environment.Application], [Environment.BuildTool], [Environment.DevTools]
    * - default: 'false'
    */
    LogStdout(
        "compose.reload.logStdout",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application, Environment.BuildTool, Environment.DevTools),
    ),
    /**
    * - 'compose.reload.isActive'
    * - Available in [Environment.Application]
    * - default: 'false'
    */
    IsHotReloadActive(
        "compose.reload.isActive",
        type = Type.Boolean,
        default = "false",
        targets = listOf(Environment.Application),
    ),
;
    
    @InternalHotReloadApi
    public enum class Environment {
        BuildTool, DevTools, Application;
    }

    @InternalHotReloadApi
    public enum class Type {
        String, Int, Long, Boolean, File, Files, Enum
    }
}