/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.core.ParsedTemplate;
import org.jetbrains.compose.reload.core.TemplateToken;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0002J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00160\u0018H\u0086\b\u00f8\u0001\u0000J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001aH\u0096\u0002J\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u00c6\u0003J\t\u0010 \u001a\u00020\u0004H\u00c6\u0003J-\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006'"}, d2={"Lorg/jetbrains/compose/reload/core/ParsingContext;", "", "Lorg/jetbrains/compose/reload/core/TemplateToken;", "index", "", "tokens", "", "endIndexExclusive", "<init>", "(ILjava/util/List;I)V", "getIndex", "()I", "getTokens", "()Ljava/util/List;", "getEndIndexExclusive", "inc", "plus", "skip", "withEndIndexExclusive", "hasNext", "", "forEach", "", "block", "Lkotlin/Function1;", "iterator", "", "get", "toString", "", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "Consumed", "hot-reload-core"})
final class ParsingContext
implements Iterable<TemplateToken>,
KMappedMarker {
    private final int index;
    @NotNull
    private final List<TemplateToken> tokens;
    private final int endIndexExclusive;

    public ParsingContext(int index, @NotNull List<? extends TemplateToken> tokens, int endIndexExclusive) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        this.index = index;
        this.tokens = tokens;
        this.endIndexExclusive = endIndexExclusive;
        if (!(this.endIndexExclusive <= this.tokens.size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ ParsingContext(int n, List list, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = list.size();
        }
        this(n, list, n2);
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final List<TemplateToken> getTokens() {
        return this.tokens;
    }

    public final int getEndIndexExclusive() {
        return this.endIndexExclusive;
    }

    @NotNull
    public final ParsingContext inc() {
        return this.skip(1);
    }

    @NotNull
    public final ParsingContext plus(int tokens) {
        return this.skip(tokens);
    }

    @NotNull
    public final ParsingContext skip(int tokens) {
        return ParsingContext.copy$default(this, this.index + tokens, null, 0, 6, null);
    }

    @NotNull
    public final ParsingContext withEndIndexExclusive(int endIndexExclusive) {
        return ParsingContext.copy$default(this, 0, null, this.index + endIndexExclusive, 3, null);
    }

    public final boolean hasNext() {
        return this.index < this.endIndexExclusive;
    }

    public final void forEach(@NotNull Function1<? super TemplateToken, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEach = false;
        int n = this.getEndIndexExclusive();
        for (int i = this.getIndex(); i < n; ++i) {
            block.invoke((Object)this.getTokens().get(i));
        }
    }

    @Override
    @NotNull
    public Iterator<TemplateToken> iterator() {
        return this.tokens.subList(this.index, this.endIndexExclusive).iterator();
    }

    @Nullable
    public final TemplateToken get(int index) {
        if (this.index + index >= this.endIndexExclusive) {
            return null;
        }
        return this.tokens.get(this.index + index);
    }

    @NotNull
    public String toString() {
        return CollectionsKt.toList((Iterable)this).toString();
    }

    public final int component1() {
        return this.index;
    }

    @NotNull
    public final List<TemplateToken> component2() {
        return this.tokens;
    }

    public final int component3() {
        return this.endIndexExclusive;
    }

    @NotNull
    public final ParsingContext copy(int index, @NotNull List<? extends TemplateToken> tokens, int endIndexExclusive) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        return new ParsingContext(index, tokens, endIndexExclusive);
    }

    public static /* synthetic */ ParsingContext copy$default(ParsingContext parsingContext, int n, List list, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = parsingContext.index;
        }
        if ((n3 & 2) != 0) {
            list = parsingContext.tokens;
        }
        if ((n3 & 4) != 0) {
            n2 = parsingContext.endIndexExclusive;
        }
        return parsingContext.copy(n, list, n2);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.index);
        result = result * 31 + ((Object)this.tokens).hashCode();
        result = result * 31 + Integer.hashCode(this.endIndexExclusive);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParsingContext)) {
            return false;
        }
        ParsingContext parsingContext = (ParsingContext)other;
        if (this.index != parsingContext.index) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tokens, parsingContext.tokens)) {
            return false;
        }
        return this.endIndexExclusive == parsingContext.endIndexExclusive;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/compose/reload/core/ParsingContext$Consumed;", "", "tokens", "", "Lorg/jetbrains/compose/reload/core/TemplateToken;", "part", "Lorg/jetbrains/compose/reload/core/ParsedTemplate$Part;", "<init>", "(Ljava/util/List;Lorg/jetbrains/compose/reload/core/ParsedTemplate$Part;)V", "getTokens", "()Ljava/util/List;", "getPart", "()Lorg/jetbrains/compose/reload/core/ParsedTemplate$Part;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "hot-reload-core"})
    public static final class Consumed {
        @NotNull
        private final List<TemplateToken> tokens;
        @NotNull
        private final ParsedTemplate.Part part;

        public Consumed(@NotNull List<? extends TemplateToken> tokens, @NotNull ParsedTemplate.Part part) {
            Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            this.tokens = tokens;
            this.part = part;
        }

        @NotNull
        public final List<TemplateToken> getTokens() {
            return this.tokens;
        }

        @NotNull
        public final ParsedTemplate.Part getPart() {
            return this.part;
        }

        @NotNull
        public final List<TemplateToken> component1() {
            return this.tokens;
        }

        @NotNull
        public final ParsedTemplate.Part component2() {
            return this.part;
        }

        @NotNull
        public final Consumed copy(@NotNull List<? extends TemplateToken> tokens, @NotNull ParsedTemplate.Part part) {
            Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            return new Consumed(tokens, part);
        }

        public static /* synthetic */ Consumed copy$default(Consumed consumed, List list, ParsedTemplate.Part part, int n, Object object) {
            if ((n & 1) != 0) {
                list = consumed.tokens;
            }
            if ((n & 2) != 0) {
                part = consumed.part;
            }
            return consumed.copy(list, part);
        }

        @NotNull
        public String toString() {
            return "Consumed(tokens=" + this.tokens + ", part=" + this.part + ")";
        }

        public int hashCode() {
            int result = ((Object)this.tokens).hashCode();
            result = result * 31 + this.part.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Consumed)) {
                return false;
            }
            Consumed consumed = (Consumed)other;
            if (!Intrinsics.areEqual(this.tokens, consumed.tokens)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.part, (Object)consumed.part);
        }
    }
}

