/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.InternalHotReloadApi;
import org.jetbrains.compose.reload.core.ComposedTemplateTokenizer;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.ParsedTemplate;
import org.jetbrains.compose.reload.core.ParsingContext;
import org.jetbrains.compose.reload.core.RegexTemplateTokenizer;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.core.Template;
import org.jetbrains.compose.reload.core.TemplateBuilder;
import org.jetbrains.compose.reload.core.TemplateToken;
import org.jetbrains.compose.reload.core.TemplateTokenizer;
import org.jetbrains.compose.reload.core.TryKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a?\u0010\u0000\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0004*\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nH\u0087\b\u00f8\u0001\u0000\u001a)\u0010\u000b\u001a\u00020\u0002*\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nH\u0087\b\u00f8\u0001\u0000\u001aW\u0010\u0000\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0004*\u00020\u00052.\u0010\u0006\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\f\"\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0007\u00a2\u0006\u0002\u0010\u000f\u001aA\u0010\u000b\u001a\u00020\u0002*\u00020\u00052.\u0010\u0006\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\f\"\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0007\u00a2\u0006\u0002\u0010\u0010\u001a&\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\u0005`\u00042\u0006\u0010\u0012\u001a\u00020\u0002H\u0007\u001a\"\u0010\u0013\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\u0005`\u0004*\u00020\u0002H\u0007\u001a\f\u0010\u0014\u001a\u00020\u0005*\u00020\u0002H\u0007\u001a2\u0010\u0015\u001a$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016`\u00042\u0006\u0010\u0018\u001a\u00020\u0002H\u0002\u001a4\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\u001a`\u00042\u0006\u0010\u001b\u001a\u00020\u00022\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u001a*\u0010'\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010(\u0012\u0004\u0012\u00020\u00030\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010(`\u00042\u0006\u0010)\u001a\u00020*H\u0002\u001a*\u0010+\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010(\u0012\u0004\u0012\u00020\u00030\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010(`\u00042\u0006\u0010)\u001a\u00020*H\u0002\u001a*\u0010,\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010(\u0012\u0004\u0012\u00020\u00030\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010(`\u00042\u0006\u0010)\u001a\u00020*H\u0002\u001a*\u0010-\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010(\u0012\u0004\u0012\u00020\u00030\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010(`\u00042\u0006\u0010)\u001a\u00020*H\u0002\"\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010#\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010$\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006."}, d2={"render", "Lorg/jetbrains/compose/reload/core/Either;", "", "", "Lorg/jetbrains/compose/reload/core/Try;", "Lorg/jetbrains/compose/reload/core/Template;", "values", "Lkotlin/Function1;", "Lorg/jetbrains/compose/reload/core/TemplateBuilder;", "", "Lkotlin/ExtensionFunctionType;", "renderOrThrow", "", "Lkotlin/Pair;", "", "(Lorg/jetbrains/compose/reload/core/Template;[Lkotlin/Pair;)Lorg/jetbrains/compose/reload/core/Either;", "(Lorg/jetbrains/compose/reload/core/Template;[Lkotlin/Pair;)Ljava/lang/String;", "Template", "value", "asTemplate", "asTemplateOrThrow", "createTemplateTokens", "", "Lorg/jetbrains/compose/reload/core/TemplateToken;", "text", "parseTemplateTokens", "Lorg/jetbrains/compose/reload/core/ParsedTemplate;", "template", "tokens", "variableTokenizer", "Lorg/jetbrains/compose/reload/core/RegexTemplateTokenizer;", "ifTokenizer", "endifTokenizer", "linebreakTokenizer", "whitespaceTokenizer", "dollarInterpolationTokenizer", "wordTokenizer", "tokenizer", "Lorg/jetbrains/compose/reload/core/ComposedTemplateTokenizer;", "parsePart", "Lorg/jetbrains/compose/reload/core/ParsingContext$Consumed;", "context", "Lorg/jetbrains/compose/reload/core/ParsingContext;", "parseBlock", "parseConditionalPart", "parseVariableLine", "hot-reload-core"})
@SourceDebugExtension(value={"SMAP\nTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Template.kt\norg/jetbrains/compose/reload/core/TemplateKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 Either.kt\norg/jetbrains/compose/reload/core/EitherKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,523:1\n32#1,11:524\n13472#2:535\n13473#2:543\n384#3,7:536\n38#4,3:544\n38#4,3:547\n38#4,3:550\n38#4,3:553\n38#4,3:556\n38#4,3:559\n38#4,3:562\n38#4,3:565\n38#4,3:571\n1878#5,3:568\n1761#5,3:574\n1#6:577\n*S KotlinDebug\n*F\n+ 1 Template.kt\norg/jetbrains/compose/reload/core/TemplateKt\n*L\n47#1:524,11\n53#1:535\n53#1:543\n54#1:536,7\n69#1:544,3\n98#1:547,3\n251#1:550,3\n255#1:553,3\n268#1:556,3\n271#1:559,3\n279#1:562,3\n283#1:565,3\n333#1:571,3\n322#1:568,3\n371#1:574,3\n*E\n"})
public final class TemplateKt {
    @NotNull
    private static final RegexTemplateTokenizer variableTokenizer = new RegexTemplateTokenizer(new Regex("\\{\\h*\\{\\h*(?<key>(\\w|\\.)+)\\h*\\}\\h*\\}"), (Function1<? super MatchResult, ? extends TemplateToken>)((Function1)TemplateKt::variableTokenizer$lambda$4));
    @NotNull
    private static final RegexTemplateTokenizer ifTokenizer = new RegexTemplateTokenizer(new Regex("\\h*\\{\\h*\\{\\h*if\\h+(?<key>(\\w|\\.)+)\\h*\\}\\h*\\}\\h*\\v"), (Function1<? super MatchResult, ? extends TemplateToken>)((Function1)TemplateKt::ifTokenizer$lambda$5));
    @NotNull
    private static final RegexTemplateTokenizer endifTokenizer = new RegexTemplateTokenizer(new Regex("\\v\\h*\\{\\h*\\{/if\\}\\h*\\}\\h*"), (Function1<? super MatchResult, ? extends TemplateToken>)((Function1)TemplateKt::endifTokenizer$lambda$6));
    @NotNull
    private static final RegexTemplateTokenizer linebreakTokenizer = new RegexTemplateTokenizer(new Regex("\\v+"), (Function1<? super MatchResult, ? extends TemplateToken>)((Function1)TemplateKt::linebreakTokenizer$lambda$7));
    @NotNull
    private static final RegexTemplateTokenizer whitespaceTokenizer = new RegexTemplateTokenizer(new Regex("\\h+"), (Function1<? super MatchResult, ? extends TemplateToken>)((Function1)TemplateKt::whitespaceTokenizer$lambda$8));
    @NotNull
    private static final RegexTemplateTokenizer dollarInterpolationTokenizer = new RegexTemplateTokenizer(Regex.Companion.fromLiteral("%%"), (Function1<? super MatchResult, ? extends TemplateToken>)((Function1)TemplateKt::dollarInterpolationTokenizer$lambda$9));
    @NotNull
    private static final RegexTemplateTokenizer wordTokenizer = new RegexTemplateTokenizer(new Regex("\\S+"), (Function1<? super MatchResult, ? extends TemplateToken>)((Function1)TemplateKt::wordTokenizer$lambda$11));
    @NotNull
    private static final ComposedTemplateTokenizer tokenizer;

    @InternalHotReloadApi
    @NotNull
    public static final Either<String, Throwable> render(@NotNull Template $this$render, @NotNull Function1<? super TemplateBuilder, Unit> values) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        boolean $i$f$render = false;
        Map values2 = new LinkedHashMap();
        values.invoke((Object)new TemplateBuilder(values2){
            final /* synthetic */ Map<String, List<Object>> $values;
            {
                this.$values = $values;
            }

            /*
             * WARNING - void declaration
             */
            public void push(String key, Object value) {
                Object object;
                void $this$getOrPut$iv;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Map<String, List<Object>> map2 = this.$values;
                String key$iv = key;
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList<E>();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(value);
            }

            public void set(String key, Object value) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Map<String, List<Object>> map2 = this.$values;
                Object object = new Object[]{value};
                object = CollectionsKt.mutableListOf((Object[])object);
                map2.put(key, (List<Object>)object);
            }

            public void invoke(String $this$invoke, Object value) {
                TemplateBuilder.DefaultImpls.invoke(this, $this$invoke, value);
            }
        });
        return $this$render.render(values2);
    }

    @InternalHotReloadApi
    @NotNull
    public static final String renderOrThrow(@NotNull Template $this$renderOrThrow, @NotNull Function1<? super TemplateBuilder, Unit> values) {
        Intrinsics.checkNotNullParameter((Object)$this$renderOrThrow, (String)"<this>");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        boolean $i$f$renderOrThrow = false;
        Template $this$render$iv = $this$renderOrThrow;
        boolean $i$f$render = false;
        Map values$iv = new LinkedHashMap();
        values.invoke((Object)new /* invalid duplicate definition of identical inner class */);
        return TryKt.getOrThrow($this$render$iv.render(values$iv));
    }

    /*
     * WARNING - void declaration
     */
    @InternalHotReloadApi
    @NotNull
    public static final Either<String, Throwable> render(@NotNull Template $this$render, Pair<String, ? extends Object> ... values) {
        Intrinsics.checkNotNullParameter((Object)$this$render, (String)"<this>");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Map map2 = new LinkedHashMap();
        Pair<String, ? extends Object>[] $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            void $this$getOrPut$iv;
            Pair<String, ? extends Object> element$iv;
            Pair<String, ? extends Object> pair = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String key = (String)pair.component1();
            Object value = pair.component2();
            Map map3 = map2;
            String key$iv = key;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(value);
        }
        return $this$render.render(map2);
    }

    @InternalHotReloadApi
    @NotNull
    public static final String renderOrThrow(@NotNull Template $this$renderOrThrow, Pair<String, ? extends Object> ... values) {
        Intrinsics.checkNotNullParameter((Object)$this$renderOrThrow, (String)"<this>");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return TryKt.getOrThrow(TemplateKt.render($this$renderOrThrow, Arrays.copyOf(values, values.length)));
    }

    @InternalHotReloadApi
    @NotNull
    public static final Either<Template, Throwable> Template(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return TemplateKt.asTemplate(value);
    }

    @InternalHotReloadApi
    @NotNull
    public static final Either<Template, Throwable> asTemplate(@NotNull String $this$asTemplate) {
        Intrinsics.checkNotNullParameter((Object)$this$asTemplate, (String)"<this>");
        Either<List<TemplateToken>, Throwable> $this$leftOr$iv = TemplateKt.createTemplateTokens($this$asTemplate);
        boolean $i$f$leftOr = false;
        Either<List<TemplateToken>, Throwable> either = $this$leftOr$iv;
        if (!(either instanceof Left)) {
            if (either instanceof Right) {
                Right it = (Right)$this$leftOr$iv;
                boolean bl = false;
                return it;
            }
            throw new NoWhenBranchMatchedException();
        }
        List tokens = (List)((Left)$this$leftOr$iv).getValue();
        return TemplateKt.parseTemplateTokens($this$asTemplate, tokens);
    }

    @InternalHotReloadApi
    @NotNull
    public static final Template asTemplateOrThrow(@NotNull String $this$asTemplateOrThrow) {
        Intrinsics.checkNotNullParameter((Object)$this$asTemplateOrThrow, (String)"<this>");
        return TryKt.getOrThrow(TemplateKt.asTemplate($this$asTemplateOrThrow));
    }

    private static final Either<List<TemplateToken>, Throwable> createTemplateTokens(String text) {
        TemplateToken nextToken;
        if (((CharSequence)text).length() == 0) {
            return EitherKt.toLeft(CollectionsKt.emptyList());
        }
        List result = new ArrayList();
        for (int index = 0; index < text.length(); index += nextToken.getValue().length()) {
            nextToken = tokenizer.consume(index, text);
            if (nextToken == null) {
                return EitherKt.toRight(new Template.ParseFailure("Cannot build tokens for template (index: " + index));
            }
            result.add(nextToken);
        }
        return EitherKt.toLeft(CollectionsKt.toList((Iterable)result));
    }

    private static final Either<ParsedTemplate, Throwable> parseTemplateTokens(String template, List<? extends TemplateToken> tokens) {
        if (tokens.isEmpty()) {
            return EitherKt.toLeft(new ParsedTemplate(template, CollectionsKt.emptyList()));
        }
        ParsingContext context = new ParsingContext(0, tokens, 0, 4, null);
        List parts = new ArrayList();
        while (context.hasNext()) {
            ParsingContext.Consumed consumed;
            Either<ParsingContext.Consumed, Throwable> $this$leftOr$iv = TemplateKt.parsePart(context);
            boolean $i$f$leftOr = false;
            Either<ParsingContext.Consumed, Throwable> either = $this$leftOr$iv;
            if (!(either instanceof Left)) {
                if (either instanceof Right) {
                    Right it = (Right)$this$leftOr$iv;
                    boolean bl = false;
                    return it;
                }
                throw new NoWhenBranchMatchedException();
            }
            if ((ParsingContext.Consumed)((Left)$this$leftOr$iv).getValue() == null) {
                return EitherKt.toRight(new Template.ParseFailure("Failed parsing template part"));
            }
            parts.add(consumed.getPart());
            context = ParsingContext.copy$default(context, context.getIndex() + consumed.getTokens().size(), null, 0, 6, null);
        }
        return EitherKt.toLeft(new ParsedTemplate(template, parts));
    }

    private static final Either<ParsingContext.Consumed, Throwable> parsePart(ParsingContext context) {
        ParsingContext.Consumed variableLine;
        ParsingContext.Consumed conditionalPart;
        Either<ParsingContext.Consumed, Throwable> $this$leftOr$iv = TemplateKt.parseConditionalPart(context);
        boolean $i$f$leftOr = false;
        Either<ParsingContext.Consumed, Throwable> either = $this$leftOr$iv;
        if (!(either instanceof Left)) {
            if (either instanceof Right) {
                Right it = (Right)$this$leftOr$iv;
                boolean bl = false;
                return it;
            }
            throw new NoWhenBranchMatchedException();
        }
        ParsingContext.Consumed consumed = conditionalPart = (ParsingContext.Consumed)((Left)$this$leftOr$iv).getValue();
        if (consumed != null) {
            return EitherKt.toLeft(consumed);
        }
        Either<ParsingContext.Consumed, Throwable> $this$leftOr$iv2 = TemplateKt.parseVariableLine(context);
        boolean $i$f$leftOr2 = false;
        Either<ParsingContext.Consumed, Throwable> either2 = $this$leftOr$iv2;
        if (!(either2 instanceof Left)) {
            if (either2 instanceof Right) {
                Right it = (Right)$this$leftOr$iv2;
                boolean bl = false;
                return it;
            }
            throw new NoWhenBranchMatchedException();
        }
        ParsingContext.Consumed consumed2 = variableLine = (ParsingContext.Consumed)((Left)$this$leftOr$iv2).getValue();
        if (consumed2 != null) {
            return EitherKt.toLeft(consumed2);
        }
        return TemplateKt.parseBlock(context);
    }

    private static final Either<ParsingContext.Consumed, Throwable> parseBlock(ParsingContext context) {
        ParsingContext currentContext = context;
        List block = new ArrayList();
        while (currentContext.hasNext()) {
            if (currentContext.get(0) instanceof TemplateToken.IfToken) {
                ParsedTemplate.Block header = new ParsedTemplate.Block(block);
                Either<ParsingContext.Consumed, Throwable> $this$leftOr$iv = TemplateKt.parseConditionalPart(currentContext);
                boolean $i$f$leftOr = false;
                Either<ParsingContext.Consumed, Throwable> either = $this$leftOr$iv;
                if (!(either instanceof Left)) {
                    if (either instanceof Right) {
                        Right it = (Right)$this$leftOr$iv;
                        boolean bl = false;
                        return it;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                ParsingContext.Consumed body = (ParsingContext.Consumed)((Left)$this$leftOr$iv).getValue();
                if (body == null) {
                    return EitherKt.toRight(new Template.ParseFailure("Failed parsing conditional part"));
                }
                ParsingContext footerContext = currentContext.skip(body.getTokens().size());
                Either<ParsingContext.Consumed, Throwable> $this$leftOr$iv2 = TemplateKt.parsePart(footerContext);
                boolean $i$f$leftOr2 = false;
                Either<ParsingContext.Consumed, Throwable> either2 = $this$leftOr$iv2;
                if (!(either2 instanceof Left)) {
                    if (either2 instanceof Right) {
                        Right it = (Right)$this$leftOr$iv2;
                        boolean bl = false;
                        return it;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                ParsingContext.Consumed footer = (ParsingContext.Consumed)((Left)$this$leftOr$iv2).getValue();
                if (footer == null) {
                    return EitherKt.toRight(new Template.ParseFailure("Failed parsing conditional part"));
                }
                return EitherKt.toLeft(new ParsingContext.Consumed(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)block, (Iterable)body.getTokens()), (Iterable)footer.getTokens()), new ParsedTemplate.NestedPart(header, body.getPart(), footer.getPart())));
            }
            Either<ParsingContext.Consumed, Throwable> $this$leftOr$iv = TemplateKt.parseVariableLine(currentContext);
            boolean $i$f$leftOr = false;
            Either<ParsingContext.Consumed, Throwable> footer = $this$leftOr$iv;
            if (!(footer instanceof Left)) {
                if (footer instanceof Right) {
                    Right it = (Right)$this$leftOr$iv;
                    boolean bl = false;
                    return it;
                }
                throw new NoWhenBranchMatchedException();
            }
            ParsingContext.Consumed variableLine = (ParsingContext.Consumed)((Left)$this$leftOr$iv).getValue();
            if (variableLine != null) {
                ParsedTemplate.Block header = new ParsedTemplate.Block(block);
                ParsingContext footerContext = currentContext.skip(variableLine.getTokens().size());
                Either<ParsingContext.Consumed, Throwable> $this$leftOr$iv3 = TemplateKt.parseBlock(footerContext);
                boolean $i$f$leftOr3 = false;
                Either<ParsingContext.Consumed, Throwable> either = $this$leftOr$iv3;
                if (!(either instanceof Left)) {
                    if (either instanceof Right) {
                        Right it = (Right)$this$leftOr$iv3;
                        boolean bl = false;
                        return it;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                footer = (ParsingContext.Consumed)((Left)$this$leftOr$iv3).getValue();
                Collection collection = CollectionsKt.plus((Collection)block, (Iterable)variableLine.getTokens());
                Either<ParsingContext.Consumed, Throwable> either3 = footer;
                List list = either3 != null ? ((ParsingContext.Consumed)((Object)either3)).getTokens() : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                Either<ParsingContext.Consumed, Throwable> either4 = footer;
                return EitherKt.toLeft(new ParsingContext.Consumed(CollectionsKt.plus((Collection)collection, (Iterable)list), new ParsedTemplate.NestedPart(header, variableLine.getPart(), either4 != null ? ((ParsingContext.Consumed)((Object)either4)).getPart() : null)));
            }
            if (currentContext.get(0) instanceof TemplateToken.EndifToken) break;
            TemplateToken templateToken = currentContext.get(0);
            if (templateToken == null) {
                return EitherKt.toLeft(null);
            }
            block.add(templateToken);
            currentContext = currentContext.skip(1);
        }
        return EitherKt.toLeft(new ParsingContext.Consumed(block, new ParsedTemplate.Block(block)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Either<ParsingContext.Consumed, Throwable> parseConditionalPart(ParsingContext context) {
        List tokens = new ArrayList();
        ParsingContext currentContext = null;
        currentContext = context;
        while (currentContext.hasNext()) {
            ParsingContext parsingContext;
            TemplateToken token;
            if (currentContext.get(0) == null) {
                return EitherKt.toLeft(null);
            }
            TemplateToken templateToken = token;
            if (templateToken instanceof TemplateToken.Whitespace) {
                tokens.add(token);
                parsingContext = currentContext;
                currentContext = parsingContext.inc();
                continue;
            }
            if (templateToken instanceof TemplateToken.IfToken) {
                int currentIndex;
                block13: {
                    tokens.add(token);
                    parsingContext = currentContext;
                    currentContext = parsingContext.inc();
                    boolean bl = false;
                    int parity = 0;
                    parity = 1;
                    Iterable $this$forEachIndexed$iv = currentContext;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        void token2;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        TemplateToken templateToken2 = (TemplateToken)item$iv;
                        currentIndex = n;
                        boolean bl2 = false;
                        if (token2 instanceof TemplateToken.IfToken) {
                            ++parity;
                        }
                        if (token2 instanceof TemplateToken.EndifToken) {
                            parity += -1;
                        }
                        if (parity != 0) continue;
                        break block13;
                    }
                    return EitherKt.toRight(new Template.ParseFailure("Missing '{{/if}}' for '" + ((Object)StringsKt.trim((CharSequence)((TemplateToken.IfToken)token).getValue())).toString() + "'"));
                }
                int endIfTokenIndex = currentIndex;
                ParsingContext partParsingContext = currentContext.withEndIndexExclusive(endIfTokenIndex);
                Either<ParsingContext.Consumed, Throwable> $this$leftOr$iv = TemplateKt.parseBlock(partParsingContext);
                boolean $i$f$leftOr = false;
                Either<ParsingContext.Consumed, Throwable> either = $this$leftOr$iv;
                if (!(either instanceof Left)) {
                    if (either instanceof Right) {
                        Right it = (Right)$this$leftOr$iv;
                        boolean bl = false;
                        return it;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                ParsingContext.Consumed parsedBlock = (ParsingContext.Consumed)((Left)$this$leftOr$iv).getValue();
                if (parsedBlock == null) {
                    return EitherKt.toRight(new Template.ParseFailure("Failed parsing conditional part"));
                }
                tokens.addAll((Collection)parsedBlock.getTokens());
                currentContext = currentContext.plus(parsedBlock.getTokens().size());
                TemplateToken templateToken3 = currentContext.get(0);
                if (templateToken3 == null) {
                    return EitherKt.toRight(new Template.ParseFailure("Missing 'endif'"));
                }
                TemplateToken endif = templateToken3;
                if (!(endif instanceof TemplateToken.EndifToken)) {
                    return EitherKt.toRight(new Template.ParseFailure("'endif' expected, found " + endif));
                }
                tokens.add(endif);
                return EitherKt.toLeft(new ParsingContext.Consumed(tokens, new ParsedTemplate.ConditionalPart(((TemplateToken.IfToken)token).getRequiredKey(), parsedBlock.getPart())));
            }
            return EitherKt.toLeft(null);
        }
        return EitherKt.toLeft(null);
    }

    private static final Either<ParsingContext.Consumed, Throwable> parseVariableLine(ParsingContext context) {
        boolean bl;
        List tokens;
        List line;
        block6: {
            line = new ArrayList();
            tokens = new ArrayList();
            for (TemplateToken token : context) {
                if (token instanceof TemplateToken.IfToken) {
                    return EitherKt.toLeft(null);
                }
                if (token instanceof TemplateToken.EndifToken) {
                    return EitherKt.toLeft(null);
                }
                tokens.add(token);
                line.add(token instanceof TemplateToken.Variable ? (ParsedTemplate.VariableLine.Content)new ParsedTemplate.VariableLine.Variable(((TemplateToken.Variable)token).getKey()) : (ParsedTemplate.VariableLine.Content)new ParsedTemplate.VariableLine.Constant(token));
                if (!(token instanceof TemplateToken.Linebreak)) continue;
            }
            Iterable $this$any$iv = line;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ParsedTemplate.VariableLine.Content content = (ParsedTemplate.VariableLine.Content)element$iv;
                    boolean bl2 = false;
                    if (!(content instanceof ParsedTemplate.VariableLine.Variable)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl ? (Either)EitherKt.toLeft(new ParsingContext.Consumed(tokens, new ParsedTemplate.VariableLine(line))) : (Either)EitherKt.toLeft(null);
    }

    private static final TemplateToken variableTokenizer$lambda$4(MatchResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)result.getGroups(), (String)"key");
        if (object == null || (object = object.getValue()) == null) {
            return null;
        }
        Object key = object;
        return new TemplateToken.Variable((String)key, result.getValue());
    }

    private static final TemplateToken ifTokenizer$lambda$5(MatchResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)result.getGroups(), (String)"key");
        if (object == null || (object = object.getValue()) == null) {
            return null;
        }
        Object key = object;
        return new TemplateToken.IfToken((String)key, result.getValue());
    }

    private static final TemplateToken endifTokenizer$lambda$6(MatchResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return new TemplateToken.EndifToken(result.getValue());
    }

    private static final TemplateToken linebreakTokenizer$lambda$7(MatchResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return new TemplateToken.Linebreak(result.getValue());
    }

    private static final TemplateToken whitespaceTokenizer$lambda$8(MatchResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return new TemplateToken.Whitespace(result.getValue());
    }

    private static final TemplateToken dollarInterpolationTokenizer$lambda$9(MatchResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        return new TemplateToken.DollarInterpolation(result.getValue());
    }

    private static final TemplateToken wordTokenizer$lambda$11(MatchResult result) {
        MatchResult priorityMatch;
        block2: {
            MatchResult matchResult;
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Object[] objectArray = new Regex[]{variableTokenizer.getRegex(), ifTokenizer.getRegex(), endifTokenizer.getRegex()};
            for (Regex regex : (Iterable)CollectionsKt.listOf((Object[])objectArray)) {
                boolean bl = false;
                MatchResult matchResult2 = Regex.find$default((Regex)regex, (CharSequence)result.getValue(), (int)0, (int)2, null);
                if (matchResult2 == null) continue;
                matchResult = matchResult2;
                break block2;
            }
            matchResult = priorityMatch = null;
        }
        if (priorityMatch != null) {
            String string = result.getValue().substring(0, priorityMatch.getRange().getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return new TemplateToken.Word(string);
        }
        return new TemplateToken.Word(result.getValue());
    }

    static {
        TemplateTokenizer[] templateTokenizerArray = new TemplateTokenizer[]{variableTokenizer, ifTokenizer, endifTokenizer, dollarInterpolationTokenizer, linebreakTokenizer, whitespaceTokenizer, wordTokenizer};
        tokenizer = new ComposedTemplateTokenizer(templateTokenizerArray);
    }
}

