/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.InternalHotReloadApi;
import org.jetbrains.compose.reload.core.CompletableFuture;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Future;
import org.jetbrains.compose.reload.core.FutureKt;
import org.jetbrains.compose.reload.core.TryKt;

@InternalHotReloadApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001 B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0012H\u0016J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015J\b\u0010\u0016\u001a\u00020\u0012H\u0016J \u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0015\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aJ \u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0015\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aJ \u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0015\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aJ\u001f\u0010\u001d\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001a\u00a2\u0006\u0002\u0010\u001eJ4\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0015\"\u0004\b\u0000\u0010\u00182\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0002R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/compose/reload/core/WorkerThread;", "Ljava/lang/Thread;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "name", "", "isDaemon", "", "<init>", "(Ljava/lang/String;Z)V", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lorg/jetbrains/compose/reload/core/WorkerThread$Work;", "idleQueue", "isShutdown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isClosed", "Lorg/jetbrains/compose/reload/core/CompletableFuture;", "", "run", "shutdown", "Lorg/jetbrains/compose/reload/core/Future;", "close", "invokeWhenIdle", "T", "action", "Lkotlin/Function0;", "invoke", "invokeImmediate", "invokeImmediateBlocking", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "enqueue", "Work", "hot-reload-core"})
@SourceDebugExtension(value={"SMAP\nWorkerThread.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerThread.kt\norg/jetbrains/compose/reload/core/WorkerThread\n+ 2 Try.kt\norg/jetbrains/compose/reload/core/TryKt\n*L\n1#1,120:1\n16#2,4:121\n16#2,4:125\n*S KotlinDebug\n*F\n+ 1 WorkerThread.kt\norg/jetbrains/compose/reload/core/WorkerThread\n*L\n84#1:121,4\n25#1:125,4\n*E\n"})
public final class WorkerThread
extends Thread
implements AutoCloseable {
    @NotNull
    private final LinkedBlockingQueue<Work<?>> queue;
    @NotNull
    private final LinkedBlockingQueue<Work<?>> idleQueue;
    @NotNull
    private final AtomicBoolean isShutdown;
    @NotNull
    private final CompletableFuture<Unit> isClosed;

    public WorkerThread(@NotNull String name, boolean isDaemon) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.queue = new LinkedBlockingQueue();
        this.idleQueue = new LinkedBlockingQueue();
        this.isShutdown = new AtomicBoolean(false);
        this.isClosed = FutureKt.Future();
        if (isDaemon) {
            this.setDaemon(true);
        }
        this.start();
    }

    public /* synthetic */ WorkerThread(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                if (this.queue.isEmpty() && !((Collection)this.idleQueue).isEmpty()) {
                    Work<?> idleElement;
                    Work<?> work = idleElement = this.idleQueue.poll();
                    if (work != null) {
                        WorkerThread.run$execute(work);
                    }
                    continue;
                }
                Work<?> element = this.queue.take();
                Intrinsics.checkNotNull(element);
                WorkerThread.run$execute(element);
                if (element instanceof Work.Shutdown) break;
            }
            WorkerThread.run$cleanupQueues(this);
        }
        finally {
            FutureKt.complete(this.isClosed, Unit.INSTANCE);
        }
    }

    @NotNull
    public final Future<Unit> shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            this.queue.add(Work.Shutdown.INSTANCE);
        }
        return this.isClosed;
    }

    @Override
    public void close() {
        this.shutdown();
    }

    @NotNull
    public final <T> Future<T> invokeWhenIdle(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Future<? extends T> future2 = this.enqueue(this.idleQueue, action);
        this.queue.add(Work.Empty.INSTANCE);
        return future2;
    }

    @NotNull
    public final <T> Future<T> invoke(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return this.enqueue(this.queue, action);
    }

    @NotNull
    public final <T> Future<T> invokeImmediate(@NotNull Function0<? extends T> action) {
        Future<Object> future2;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (Intrinsics.areEqual((Object)Thread.currentThread(), (Object)this)) {
            Either either;
            boolean $i$f$Try = false;
            try {
                boolean bl = false;
                either = EitherKt.toLeft(action.invoke());
            }
            catch (Throwable t$iv) {
                either = EitherKt.toRight(t$iv);
            }
            future2 = FutureKt.FutureFromTry(either);
        } else {
            future2 = this.invoke(action);
        }
        return future2;
    }

    public final <T> T invokeImmediateBlocking(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return (T)(Intrinsics.areEqual((Object)Thread.currentThread(), (Object)this) ? action.invoke() : TryKt.getOrThrow(FutureKt.getBlocking(this.invoke(action))));
    }

    private final <T> Future<T> enqueue(LinkedBlockingQueue<Work<?>> queue, Function0<? extends T> action) {
        if (this.isShutdown.get()) {
            return FutureKt.FailureFuture(new RejectedExecutionException("WorkerThread '" + this.getName() + "' is shutting down"));
        }
        Work.Action work = new Work.Action(action, null, 2, null);
        queue.add(work);
        return work.getFuture();
    }

    private static final <T> void run$execute(Work<T> $this$run_u24execute) {
        if ($this$run_u24execute instanceof Work.Action) {
            Either either;
            CompletableFuture completableFuture = ((Work.Action)$this$run_u24execute).getFuture();
            boolean $i$f$Try = false;
            try {
                boolean bl = false;
                either = EitherKt.toLeft(((Work.Action)$this$run_u24execute).getAction().invoke());
            }
            catch (Throwable t$iv) {
                either = EitherKt.toRight(t$iv);
            }
            completableFuture.completeWith(either);
        }
    }

    private static final void run$cleanupQueues(WorkerThread this$0) {
        while (!((Collection)this$0.queue).isEmpty()) {
            Work<?> work = this$0.queue.poll();
            if (work == null) continue;
            WorkerThread.run$execute(work);
        }
        while (!((Collection)this$0.idleQueue).isEmpty()) {
            Work<?> work = this$0.idleQueue.poll();
            if (work == null) continue;
            WorkerThread.run$execute(work);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0003\u0005\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004\u0082\u0001\u0003\b\t\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/compose/reload/core/WorkerThread$Work;", "T", "", "<init>", "()V", "Empty", "Shutdown", "Action", "Lorg/jetbrains/compose/reload/core/WorkerThread$Work$Action;", "Lorg/jetbrains/compose/reload/core/WorkerThread$Work$Empty;", "Lorg/jetbrains/compose/reload/core/WorkerThread$Work$Shutdown;", "hot-reload-core"})
    private static abstract class Work<T> {
        private Work() {
        }

        public /* synthetic */ Work(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/compose/reload/core/WorkerThread$Work$Action;", "T", "Lorg/jetbrains/compose/reload/core/WorkerThread$Work;", "action", "Lkotlin/Function0;", "future", "Lorg/jetbrains/compose/reload/core/CompletableFuture;", "<init>", "(Lkotlin/jvm/functions/Function0;Lorg/jetbrains/compose/reload/core/CompletableFuture;)V", "getAction", "()Lkotlin/jvm/functions/Function0;", "getFuture", "()Lorg/jetbrains/compose/reload/core/CompletableFuture;", "hot-reload-core"})
        public static final class Action<T>
        extends Work<T> {
            @NotNull
            private final Function0<T> action;
            @NotNull
            private final CompletableFuture<T> future;

            public Action(@NotNull Function0<? extends T> action, @NotNull CompletableFuture<T> future2) {
                Intrinsics.checkNotNullParameter(action, (String)"action");
                Intrinsics.checkNotNullParameter(future2, (String)"future");
                super(null);
                this.action = action;
                this.future = future2;
            }

            public /* synthetic */ Action(Function0 function0, CompletableFuture completableFuture, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    completableFuture = FutureKt.Future();
                }
                this(function0, completableFuture);
            }

            @NotNull
            public final Function0<T> getAction() {
                return this.action;
            }

            @NotNull
            public final CompletableFuture<T> getFuture() {
                return this.future;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/compose/reload/core/WorkerThread$Work$Empty;", "Lorg/jetbrains/compose/reload/core/WorkerThread$Work;", "", "<init>", "()V", "hot-reload-core"})
        public static final class Empty
        extends Work<Unit> {
            @NotNull
            public static final Empty INSTANCE = new Empty();

            private Empty() {
                super(null);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/compose/reload/core/WorkerThread$Work$Shutdown;", "Lorg/jetbrains/compose/reload/core/WorkerThread$Work;", "", "<init>", "()V", "hot-reload-core"})
        public static final class Shutdown
        extends Work<Unit> {
            @NotNull
            public static final Shutdown INSTANCE = new Shutdown();

            private Shutdown() {
                super(null);
            }
        }
    }
}

