/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.core.BuildSystem;
import org.jetbrains.compose.reload.core.LaunchMode;
import org.jetbrains.compose.reload.core.Os;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u0017\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000bR\u0013\u0010\"\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000bR\u0013\u0010$\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0011R\u0013\u0010&\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0011R\u0011\u0010(\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0014R\u0013\u0010*\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0011R\u0013\u0010,\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0011R\u0011\u0010.\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0014R\u0019\u00100\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u0001018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0014R\u0013\u00106\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0007R\u0013\u00108\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u000bR\u0013\u0010:\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u000bR\u0013\u0010<\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u000bR\u0013\u0010>\u001a\u0004\u0018\u00010?8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010A\u00a8\u0006B"}, d2={"Lorg/jetbrains/compose/reload/core/HotReloadEnvironment;", "", "<init>", "()V", "orchestrationPort", "", "getOrchestrationPort", "()Ljava/lang/Integer;", "pidFile", "Ljava/nio/file/Path;", "getPidFile", "()Ljava/nio/file/Path;", "argFile", "getArgFile", "mainClass", "", "getMainClass", "()Ljava/lang/String;", "isHeadless", "", "()Z", "hotClasspath", "getHotClasspath", "virtualMethodResolveEnabled", "getVirtualMethodResolveEnabled", "dirtyResolveDepthLimit", "getDirtyResolveDepthLimit", "()I", "buildSystem", "Lorg/jetbrains/compose/reload/core/BuildSystem;", "getBuildSystem", "()Lorg/jetbrains/compose/reload/core/BuildSystem;", "gradleJavaHome", "getGradleJavaHome", "gradleBuildRoot", "getGradleBuildRoot", "gradleBuildProject", "getGradleBuildProject", "gradleBuildTask", "getGradleBuildTask", "gradleBuildContinuous", "getGradleBuildContinuous", "amperBuildRoot", "getAmperBuildRoot", "amperBuildTask", "getAmperBuildTask", "devToolsEnabled", "getDevToolsEnabled", "devToolsClasspath", "", "getDevToolsClasspath", "()Ljava/util/List;", "devToolsTransparencyEnabled", "getDevToolsTransparencyEnabled", "intelliJDebuggerDispatchPort", "getIntelliJDebuggerDispatchPort", "stdinFile", "getStdinFile", "stdoutFile", "getStdoutFile", "stderrFile", "getStderrFile", "launchMode", "Lorg/jetbrains/compose/reload/core/LaunchMode;", "getLaunchMode", "()Lorg/jetbrains/compose/reload/core/LaunchMode;", "hot-reload-core"})
@SourceDebugExtension(value={"SMAP\nHotReloadEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotReloadEnvironment.kt\norg/jetbrains/compose/reload/core/HotReloadEnvironment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,344:1\n1563#2:345\n1634#2,3:346\n*S KotlinDebug\n*F\n+ 1 HotReloadEnvironment.kt\norg/jetbrains/compose/reload/core/HotReloadEnvironment\n*L\n245#1:345\n245#1:346,3\n*E\n"})
public final class HotReloadEnvironment {
    @NotNull
    public static final HotReloadEnvironment INSTANCE = new HotReloadEnvironment();

    private HotReloadEnvironment() {
    }

    @Nullable
    public final Integer getOrchestrationPort() {
        String string = System.getProperty("compose.reload.orchestration.port");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_ORCHESTRATION_PORT")) == null) {
            return null;
        }
        String value = string;
        return Integer.parseInt(value);
    }

    @Nullable
    public final Path getPidFile() {
        String string = System.getProperty("compose.reload.pidFile");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_PIDFILE")) == null) {
            return null;
        }
        String value = string;
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final Path getArgFile() {
        String string = System.getProperty("compose.reload.argfile");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_ARGFILE")) == null) {
            return null;
        }
        String value = string;
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final String getMainClass() {
        String string = System.getProperty("compose.reload.mainClass");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_MAINCLASS")) == null) {
            return null;
        }
        String value = string;
        return value;
    }

    public final boolean isHeadless() {
        String string = System.getProperty("compose.reload.headless");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_HEADLESS")) == null) {
            string = "false";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    @Nullable
    public final String getHotClasspath() {
        String string = System.getProperty("compose.reload.hotApplicationClasspath");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_HOTAPPLICATIONCLASSPATH")) == null) {
            return null;
        }
        String value = string;
        return value;
    }

    public final boolean getVirtualMethodResolveEnabled() {
        String string = System.getProperty("compose.reload.virtualMethodResolveEnabled");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_VIRTUALMETHODRESOLVEENABLED")) == null) {
            string = "true";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    public final int getDirtyResolveDepthLimit() {
        String string = System.getProperty("compose.reload.dirtyResolveDepthLimit");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_DIRTYRESOLVEDEPTHLIMIT")) == null) {
            string = "5";
        }
        String value = string;
        return Integer.parseInt(value);
    }

    @Nullable
    public final BuildSystem getBuildSystem() {
        String string = System.getProperty("compose.reload.buildSystem");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_BUILDSYSTEM")) == null) {
            return null;
        }
        String value = string;
        return BuildSystem.valueOf(value);
    }

    @Nullable
    public final Path getGradleJavaHome() {
        String string = System.getProperty("org.gradle.java.home");
        if (string == null && (string = System.getenv("ORG_GRADLE_JAVA_HOME")) == null) {
            return null;
        }
        String value = string;
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final Path getGradleBuildRoot() {
        String string = System.getProperty("gradle.build.root");
        if (string == null && (string = System.getenv("GRADLE_BUILD_ROOT")) == null) {
            return null;
        }
        String value = string;
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final String getGradleBuildProject() {
        String string = System.getProperty("gradle.build.project");
        if (string == null && (string = System.getenv("GRADLE_BUILD_PROJECT")) == null) {
            return null;
        }
        String value = string;
        return value;
    }

    @Nullable
    public final String getGradleBuildTask() {
        String string = System.getProperty("gradle.build.task");
        if (string == null && (string = System.getenv("GRADLE_BUILD_TASK")) == null) {
            return null;
        }
        String value = string;
        return value;
    }

    public final boolean getGradleBuildContinuous() {
        String string = System.getProperty("compose.reload.build.continuous");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_BUILD_CONTINUOUS")) == null) {
            string = "true";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    @Nullable
    public final String getAmperBuildRoot() {
        String string = System.getProperty("amper.build.root");
        if (string == null && (string = System.getenv("AMPER_BUILD_ROOT")) == null) {
            return null;
        }
        String value = string;
        return value;
    }

    @Nullable
    public final String getAmperBuildTask() {
        String string = System.getProperty("amper.build.task");
        if (string == null && (string = System.getenv("AMPER_BUILD_TASK")) == null) {
            return null;
        }
        String value = string;
        return value;
    }

    public final boolean getDevToolsEnabled() {
        String string = System.getProperty("compose.reload.devToolsEnabled");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_DEVTOOLSENABLED")) == null) {
            string = "true";
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<Path> getDevToolsClasspath() {
        void $this$mapTo$iv$iv;
        String string = System.getProperty("compose.reload.devToolsClasspath");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_DEVTOOLSCLASSPATH")) == null) {
            return null;
        }
        String value = string;
        String[] stringArray = new String[]{File.pathSeparator};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = Paths.get((String)p0, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            collection.add(path);
        }
        return (List)destination$iv$iv;
    }

    public final boolean getDevToolsTransparencyEnabled() {
        String string = System.getProperty("compose.reload.devToolsTransparencyEnabled");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_DEVTOOLSTRANSPARENCYENABLED")) == null) {
            string = String.valueOf(Os.Companion.currentOrNull() != Os.Linux);
        }
        String value = string;
        return StringsKt.toBooleanStrict((String)value);
    }

    @Nullable
    public final Integer getIntelliJDebuggerDispatchPort() {
        String string = System.getProperty("compose.reload.idea.debugger.dispatch.port");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_IDEA_DEBUGGER_DISPATCH_PORT")) == null) {
            return null;
        }
        String value = string;
        return Integer.parseInt(value);
    }

    @Nullable
    public final Path getStdinFile() {
        String string = System.getProperty("compose.reload.stdinFile");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_STDINFILE")) == null) {
            return null;
        }
        String value = string;
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final Path getStdoutFile() {
        String string = System.getProperty("compose.reload.stdoutFile");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_STDOUTFILE")) == null) {
            return null;
        }
        String value = string;
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final Path getStderrFile() {
        String string = System.getProperty("compose.reload.stderrFile");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_STDERRFILE")) == null) {
            return null;
        }
        String value = string;
        Path path = Paths.get(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final LaunchMode getLaunchMode() {
        String string = System.getProperty("compose.reload.launchMode");
        if (string == null && (string = System.getenv("COMPOSE_RELOAD_LAUNCHMODE")) == null) {
            return null;
        }
        String value = string;
        return LaunchMode.valueOf(value);
    }
}

