/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis.testFixtures;

import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.analysis.JavapKt;
import org.jetbrains.compose.reload.core.FileUtilsKt;
import org.jetbrains.compose.reload.test.core.TestEnvironment;
import org.junit.jupiter.api.AssertionsKt;
import org.junit.jupiter.api.TestInfo;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0012\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"checkJavap", "", "testInfo", "Lorg/junit/jupiter/api/TestInfo;", "name", "", "code", "", "", "hot-reload-analysis_testFixtures"})
@SourceDebugExtension(value={"SMAP\ncheckJavap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 checkJavap.kt\norg/jetbrains/compose/reload/analysis/testFixtures/CheckJavapKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,75:1\n478#2:76\n424#2:77\n463#2:82\n413#2:83\n1252#3,4:78\n1252#3,4:84\n1285#3,2:88\n1299#3,4:90\n216#4,2:94\n*S KotlinDebug\n*F\n+ 1 checkJavap.kt\norg/jetbrains/compose/reload/analysis/testFixtures/CheckJavapKt\n*L\n33#1:76\n33#1:77\n34#1:82\n34#1:83\n33#1:78,4\n34#1:84,4\n55#1:88,2\n55#1:90,4\n67#1:94,2\n*E\n"})
public final class CheckJavapKt {
    /*
     * WARNING - void declaration
     */
    public static final void checkJavap(@NotNull TestInfo testInfo, @NotNull String name, @NotNull Map<String, byte[]> code) {
        Path path;
        void $this$associateWithTo$iv$iv;
        void $this$associateWith$iv;
        String string;
        Object object;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object2;
        Map.Entry entry;
        Map map;
        Map.Entry entry2;
        Iterable $this$associateByTo$iv$iv$iv;
        void $this$mapKeysTo$iv$iv;
        Map $this$mapKeys$iv;
        Intrinsics.checkNotNullParameter((Object)testInfo, (String)"testInfo");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        Path path2 = Paths.get("src/test/resources/javap", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        String string2 = ((Class)testInfo.getTestClass().get()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        Path path3 = path2.resolve(StringsKt.replace$default((String)FileUtilsKt.asFileName((String)string2), (String)".", (String)"/", (boolean)false, (int)4, null));
        String string3 = ((Method)testInfo.getTestMethod().get()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        Path directory = path3.resolve(FileUtilsKt.asFileName((String)string3)).resolve(FileUtilsKt.asFileName((String)name));
        Map<String, byte[]> map2 = code;
        boolean $i$f$mapKeys = false;
        void var7_7 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable iterable = $this$mapKeysTo$iv$iv.entrySet();
        Map map3 = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            entry2 = (Map.Entry)element$iv$iv$iv;
            map = map3;
            boolean bl = false;
            String path4 = (String)entry2.getKey();
            entry = (Map.Entry)element$iv$iv$iv;
            Path path5 = directory.resolve(path4 + ".javap.txt");
            Map map4 = map;
            boolean bl2 = false;
            object2 = it$iv$iv.getValue();
            map4.put(path5, object2);
        }
        $this$mapKeys$iv = map3;
        boolean $i$f$mapValues232 = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo232 = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        Map map5 = destination$iv$iv;
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            entry2 = (Map.Entry)element$iv$iv$iv;
            Map bl = map5;
            boolean bl3 = false;
            entry = (Map.Entry)element$iv$iv$iv;
            object = it$iv$iv.getKey();
            map = bl;
            boolean bl4 = false;
            byte[] code2 = (byte[])entry.getValue();
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)JavapKt.javap((byte[])code2))).toString();
            object2 = new Regex("/.*/Bytecode.class");
            String string4 = "<bytecode path>";
            charSequence = object2.replace(charSequence, string4);
            object2 = new Regex("Last modified.*;");
            string4 = "Last modified <Date>;";
            string = object2.replace(charSequence, string4);
            map.put(object, string);
        }
        Map actualContent = map5;
        if (TestEnvironment.INSTANCE.getUpdateTestData()) {
            Intrinsics.checkNotNull((Object)directory);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(directory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                PathsKt.deleteRecursively((Path)directory);
            }
        }
        Intrinsics.checkNotNull((Object)directory);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(directory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            actualContent.forEach((arg_0, arg_1) -> CheckJavapKt.checkJavap$lambda$3(CheckJavapKt::checkJavap$lambda$2, arg_0, arg_1));
            if (!TestEnvironment.INSTANCE.getUpdateTestData()) {
                AssertionsKt.fail$default((String)("javap directory '" + ((Object)directory).toString() + "' did not exist; Generated"), null, (int)2, null);
                throw new KotlinNothingValueException();
            }
        }
        Iterable $i$f$mapValues232 = PathsKt.listDirectoryEntries((Path)directory, (String)"*.javap.txt");
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $i$f$mapValuesTo232 = $this$associateWith$iv;
        Map destination$iv$iv2 = result$iv;
        boolean bl = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Object element$iv$iv$iv;
            element$iv$iv$iv = (Path)element$iv$iv;
            object = element$iv$iv;
            map = destination$iv$iv2;
            boolean bl2 = false;
            string = ((Object)StringsKt.trim((CharSequence)PathsKt.readText$default((Path)path, null, (int)1, null))).toString();
            map.put(object, string);
        }
        Map expectedContent = destination$iv$iv2;
        Set unexpectedActualPaths = SetsKt.minus(actualContent.keySet(), (Iterable)expectedContent.keySet());
        if (!((Collection)unexpectedActualPaths).isEmpty()) {
            AssertionsKt.fail$default((String)("Unexpected class files: " + unexpectedActualPaths), null, (int)2, null);
            throw new KotlinNothingValueException();
        }
        Set missingExpectPaths = SetsKt.minus(expectedContent.keySet(), (Iterable)actualContent.keySet());
        if (!((Collection)missingExpectPaths).isEmpty()) {
            AssertionsKt.fail$default((String)("Missing class files: " + missingExpectPaths), null, (int)2, null);
            throw new KotlinNothingValueException();
        }
        Map $this$forEach$iv = expectedContent;
        boolean $i$f$forEach = false;
        for (Map.Entry entry3 : $this$forEach$iv.entrySet()) {
            String actualCode;
            Map.Entry entry4 = entry3;
            boolean bl3 = false;
            path = (Path)entry4.getKey();
            String code3 = (String)entry4.getValue();
            if (Intrinsics.areEqual((Object)code3, (Object)(actualCode = (String)MapsKt.getValue((Map)actualContent, (Object)path)))) continue;
            Path path6 = path.resolveSibling(PathsKt.getNameWithoutExtension((Path)path) + "-actual.txt");
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolveSibling(...)");
            PathsKt.writeText$default((Path)path6, (CharSequence)actualCode, null, (OpenOption[])new OpenOption[0], (int)2, null);
            AssertionsKt.fail$default((String)("Javap '" + path.toUri() + "' does not match"), null, (int)2, null);
            throw new KotlinNothingValueException();
        }
    }

    public static /* synthetic */ void checkJavap$default(TestInfo testInfo, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        CheckJavapKt.checkJavap(testInfo, string, map);
    }

    private static final Unit checkJavap$lambda$2(Path file, String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNull((Object)file);
        PathsKt.createParentDirectories((Path)file, (FileAttribute[])new FileAttribute[0]);
        PathsKt.writeText$default((Path)file, (CharSequence)code, null, (OpenOption[])new OpenOption[0], (int)2, null);
        return Unit.INSTANCE;
    }

    private static final void checkJavap$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

