/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.analysis.AsmUtilsKt;
import org.jetbrains.compose.reload.analysis.ComposeGroupKey;
import org.jetbrains.compose.reload.analysis.FieldId;
import org.jetbrains.compose.reload.analysis.InstructionToken;
import org.jetbrains.compose.reload.analysis.InstructionTree;
import org.jetbrains.compose.reload.analysis.InstructionTreeDependenciesKt;
import org.jetbrains.compose.reload.analysis.InstructionTreeKt;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.analysis.ScopeAnalyzerExtensionKt;
import org.jetbrains.compose.reload.analysis.ScopeHashKt;
import org.jetbrains.compose.reload.analysis.ScopeInfo;
import org.jetbrains.compose.reload.analysis.ScopeType;
import org.jetbrains.compose.reload.core.Context;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a*\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\" \u0010\r\u001a\u0004\u0018\u00010\u000e*\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"ScopeInfo", "Lorg/jetbrains/compose/reload/analysis/ScopeInfo;", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "methodNode", "Lorg/objectweb/asm/tree/MethodNode;", "createScopeInfo", "methodId", "Lorg/jetbrains/compose/reload/analysis/MethodId;", "tree", "Lorg/jetbrains/compose/reload/analysis/InstructionTree;", "sourceFile", "", "firstLineNumber", "", "", "Lorg/jetbrains/compose/reload/analysis/InstructionToken;", "getFirstLineNumber", "(Ljava/util/List;)Ljava/lang/Integer;", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nScopeInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScopeInfo.kt\norg/jetbrains/compose/reload/analysis/ScopeInfoKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1563#2:75\n1634#2,3:76\n1#3:79\n*S KotlinDebug\n*F\n+ 1 ScopeInfo.kt\norg/jetbrains/compose/reload/analysis/ScopeInfoKt\n*L\n60#1:75\n60#1:76,3\n*E\n"})
public final class ScopeInfoKt {
    @NotNull
    public static final ScopeInfo ScopeInfo(@NotNull ClassNode classNode, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        MethodId methodId = AsmUtilsKt.MethodId(classNode, methodNode);
        InstructionTree runtimeInstructionTree = InstructionTreeKt.parseInstructionTreeLenient(methodId, methodNode);
        String sourceFile = classNode.sourceFile;
        return ScopeInfoKt.createScopeInfo(methodId, methodNode, runtimeInstructionTree, sourceFile);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ScopeInfo createScopeInfo(@NotNull MethodId methodId, @NotNull MethodNode methodNode, @NotNull InstructionTree tree, @Nullable String sourceFile) {
        Collection<ScopeInfo> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)methodId, (String)"methodId");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Iterable iterable = tree.getChildren();
        Set<FieldId> set = InstructionTreeDependenciesKt.fieldDependencies(tree);
        Set<MethodId> set2 = InstructionTreeDependenciesKt.methodDependencies(tree);
        ComposeGroupKey composeGroupKey = tree.getGroup-z2uEmV4();
        long l = ScopeHashKt.scopeHash(tree, methodNode);
        ScopeType scopeType = tree.getType();
        MethodId methodId2 = methodId;
        boolean $i$f$map = false;
        void var6_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void child;
            InstructionTree instructionTree = (InstructionTree)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ScopeInfoKt.createScopeInfo(methodId, methodNode, (InstructionTree)child, sourceFile));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        ScopeInfo.SourceLocation sourceLocation = new ScopeInfo.SourceLocation(sourceFile, ScopeInfoKt.getFirstLineNumber(tree.getTokens()));
        Context context = ScopeAnalyzerExtensionKt.createScopeInfoExtras(methodId, methodNode, tree);
        Collection<ScopeInfo> collection2 = collection;
        Set<FieldId> set3 = set;
        Set<MethodId> set4 = set2;
        ComposeGroupKey composeGroupKey2 = composeGroupKey;
        long l2 = l;
        ScopeType scopeType2 = scopeType;
        MethodId methodId3 = methodId2;
        return new ScopeInfo(methodId3, scopeType2, l2, composeGroupKey2, set4, set3, (List)collection2, context, sourceLocation, defaultConstructorMarker);
    }

    private static final Integer getFirstLineNumber(List<? extends InstructionToken> $this$firstLineNumber) {
        Object object;
        Iterator iterator = ((Iterable)$this$firstLineNumber).iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            int n;
            Object it = (InstructionToken)iterator.next();
            boolean bl = false;
            InstructionToken.LabelToken labelToken = it instanceof InstructionToken.LabelToken ? (InstructionToken.LabelToken)it : null;
            if (labelToken == null) {
                n = Integer.MAX_VALUE;
            } else {
                InstructionToken.LabelToken label = labelToken;
                LineNumberNode lineNumberNode = label.getLineNumberInsn();
                n = lineNumberNode != null ? lineNumberNode.line : Integer.MAX_VALUE;
            }
            it = n;
            while (iterator.hasNext()) {
                Comparable comparable;
                int n2;
                InstructionToken it2 = (InstructionToken)iterator.next();
                $i$a$-minOfOrNull-ScopeInfoKt$firstLineNumber$1 = false;
                if ((it2 instanceof InstructionToken.LabelToken ? (InstructionToken.LabelToken)it2 : null) == null) {
                    n2 = Integer.MAX_VALUE;
                } else {
                    InstructionToken.LabelToken label;
                    label = label;
                    LineNumberNode lineNumberNode = label.getLineNumberInsn();
                    n2 = lineNumberNode != null ? lineNumberNode.line : Integer.MAX_VALUE;
                }
                if (it.compareTo(comparable = (Comparable)Integer.valueOf(n2)) <= 0) continue;
                it = comparable;
            }
            object = it;
        }
        Object object2 = object;
        Integer it = (Integer)object2;
        boolean bl = false;
        Integer n = it;
        int n3 = Integer.MAX_VALUE;
        return (Integer)(n == null || n != n3 ? object2 : null);
    }
}

