/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.analysis.AsmUtilsKt;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.Ids;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.analysis.MethodType;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"MethodType", "Lorg/jetbrains/compose/reload/analysis/MethodType;", "methodNode", "Lorg/objectweb/asm/tree/MethodNode;", "COMPOSE_ENTRY_METHODS", "", "Lorg/jetbrains/compose/reload/analysis/MethodId;", "COMPOSE_FUNCTION_ANNOTATIONS", "Lorg/jetbrains/compose/reload/analysis/ClassId;", "hot-reload-analysis"})
@SourceDebugExtension(value={"SMAP\nMethodType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodType.kt\norg/jetbrains/compose/reload/analysis/MethodTypeKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n808#2,11:57\n1761#2,3:68\n1761#2,3:71\n*S KotlinDebug\n*F\n+ 1 MethodType.kt\norg/jetbrains/compose/reload/analysis/MethodTypeKt\n*L\n12#1:57,11\n13#1:68,3\n16#1:71,3\n*E\n"})
public final class MethodTypeKt {
    @NotNull
    private static final Set<MethodId> COMPOSE_ENTRY_METHODS;
    @NotNull
    private static final Set<ClassId> COMPOSE_FUNCTION_ANNOTATIONS;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MethodType MethodType(@NotNull MethodNode methodNode) {
        MethodType methodType;
        boolean bl;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block11: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
            InsnList insnList = methodNode.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            Iterable $this$filterIsInstance$iv = (Iterable)insnList;
            boolean $i$f$filterIsInstance = false;
            Iterator iterator = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MethodInsnNode)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$any$iv = (List)destination$iv$iv;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MethodInsnNode it = (MethodInsnNode)element$iv;
                    boolean bl2 = false;
                    if (!COMPOSE_ENTRY_METHODS.contains(AsmUtilsKt.MethodId(it))) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            methodType = MethodType.ComposeEntryPoint;
        } else {
            boolean bl3;
            block12: {
                $this$any$iv = AsmUtilsKt.getAllAnnotations(methodNode);
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AnnotationNode it = (AnnotationNode)element$iv;
                        boolean bl4 = false;
                        String string = it.desc;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"desc");
                        if (!COMPOSE_FUNCTION_ANNOTATIONS.contains(ClassId.box-impl(ClassId.Companion.fromDesc-DRMJc_0(string)))) continue;
                        bl3 = true;
                        break block12;
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                methodType = MethodType.Composable;
            } else {
                String string = methodNode.desc;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"desc");
                methodType = StringsKt.contains$default((CharSequence)string, (CharSequence)(ClassId.getDescriptor-impl(Ids.Composer.INSTANCE.getClassId-uSFnFHE()) + "I"), (boolean)false, (int)2, null) ? MethodType.Composable : MethodType.Regular;
            }
        }
        return methodType;
    }

    static {
        Object[] objectArray = new MethodId[]{Ids.WindowDesktopKt.INSTANCE.getSingleWindowApplication(), Ids.WindowDesktopKt.INSTANCE.getSingleWindowApplication_default(), Ids.ApplicationDesktopKt.INSTANCE.getApplication(), Ids.ApplicationDesktopKt.INSTANCE.getApplication_default(), Ids.ScreenshotTestApplicationKt.INSTANCE.getScreenshotTestApplication(), Ids.ScreenshotTestApplicationKt.INSTANCE.getScreenshotTestApplication_default()};
        COMPOSE_ENTRY_METHODS = SetsKt.setOf((Object[])objectArray);
        objectArray = new ClassId[]{ClassId.box-impl(Ids.Composable.INSTANCE.getClassId-uSFnFHE()), ClassId.box-impl(Ids.FunctionKeyMeta.INSTANCE.getClassId-uSFnFHE())};
        COMPOSE_FUNCTION_ANNOTATIONS = SetsKt.setOf((Object[])objectArray);
    }
}

