/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.analysis.InstructionToken;
import org.jetbrains.compose.reload.analysis.InstructionTokenizer;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Failure;
import org.objectweb.asm.tree.AbstractInsnNode;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B,\u0012#\u0010\u0002\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R+\u0010\u0002\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/compose/reload/analysis/SingleInstructionTokenizer;", "Lorg/jetbrains/compose/reload/analysis/InstructionTokenizer;", "token", "Lkotlin/Function1;", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/ParameterName;", "name", "instruction", "Lorg/jetbrains/compose/reload/analysis/InstructionToken;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "nextToken", "Lorg/jetbrains/compose/reload/core/Either;", "Lorg/jetbrains/compose/reload/core/Failure;", "context", "Lorg/jetbrains/compose/reload/analysis/InstructionTokenizer$TokenizerContext;", "hot-reload-analysis"})
final class SingleInstructionTokenizer
extends InstructionTokenizer {
    @NotNull
    private final Function1<AbstractInsnNode, InstructionToken> token;

    public SingleInstructionTokenizer(@NotNull Function1<? super AbstractInsnNode, ? extends InstructionToken> token) {
        Intrinsics.checkNotNullParameter(token, (String)"token");
        super(null);
        this.token = token;
    }

    @Override
    @Nullable
    public Either<InstructionToken, Failure> nextToken(@NotNull InstructionTokenizer.TokenizerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AbstractInsnNode abstractInsnNode = context.get(0);
        if (abstractInsnNode == null) {
            return null;
        }
        AbstractInsnNode instruction = abstractInsnNode;
        InstructionToken instructionToken = (InstructionToken)this.token.invoke((Object)instruction);
        if (instructionToken == null) {
            return null;
        }
        return (Either)EitherKt.toLeft((Object)instructionToken);
    }
}

