/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.analysis;

import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.analysis.UtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/compose/reload/analysis/CRCHasher;", "", "<init>", "()V", "crc", "Ljava/util/zip/CRC32;", "value", "", "getValue", "()J", "pushHash", "", "hot-reload-analysis"})
public final class CRCHasher {
    @NotNull
    private final CRC32 crc = new CRC32();

    public final long getValue() {
        return this.crc.getValue();
    }

    public final void pushHash(@Nullable Object value) {
        if (value == null) {
            return;
        }
        Object object = value;
        if (object instanceof Boolean) {
            this.crc.update((Boolean)value != false ? 1 : 0);
        } else if (object instanceof String) {
            String string = (String)value;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.crc.update(byArray);
        } else if (object instanceof Byte) {
            this.crc.update(((Number)value).byteValue());
        } else if (object instanceof Integer) {
            UtilsKt.updateInt(this.crc, ((Number)value).intValue());
        } else if (object instanceof Long) {
            UtilsKt.updateLong(this.crc, ((Number)value).longValue());
        } else if (object instanceof Float) {
            UtilsKt.updateFloat(this.crc, ((Number)value).floatValue());
        } else if (object instanceof Double) {
            UtilsKt.updateDouble(this.crc, ((Number)value).doubleValue());
        } else {
            String string = value.toString();
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.crc.update(byArray);
        }
    }
}

