/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.orchestration;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.EncodeUtilsKt;
import org.jetbrains.compose.reload.core.SerializableKt;
import org.jetbrains.compose.reload.core.TryKt;
import org.jetbrains.compose.reload.core.Type;
import org.jetbrains.compose.reload.core.TypeKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessageClassifier;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessageEncoder;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessageEncoderKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessageEncodersKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessageId;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessageKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J&\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0016R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/compose/reload/orchestration/TestEventEncoder;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessageEncoder;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage$TestEvent;", "<init>", "()V", "messageType", "Lorg/jetbrains/compose/reload/core/Type;", "getMessageType-cAobLks", "()Ljava/lang/String;", "Ljava/lang/String;", "messageClassifier", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessageClassifier;", "getMessageClassifier", "()Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessageClassifier;", "encode", "", "message", "decode", "Lorg/jetbrains/compose/reload/core/Either;", "", "Lorg/jetbrains/compose/reload/core/Try;", "data", "Companion", "hot-reload-orchestration"})
@SourceDebugExtension(value={"SMAP\norchestrationMessageEncoders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 orchestrationMessageEncoders.kt\norg/jetbrains/compose/reload/orchestration/TestEventEncoder\n+ 2 Type.kt\norg/jetbrains/compose/reload/core/TypeKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,620:1\n16#2:621\n1#3:622\n*S KotlinDebug\n*F\n+ 1 orchestrationMessageEncoders.kt\norg/jetbrains/compose/reload/orchestration/TestEventEncoder\n*L\n215#1:621\n*E\n"})
public final class TestEventEncoder
implements OrchestrationMessageEncoder<OrchestrationMessage.TestEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String messageType;
    @NotNull
    private final OrchestrationMessageClassifier messageClassifier;
    @NotNull
    public static final String PAYLOAD_ENCODING_METHOD_JIOS = "jios";
    @NotNull
    public static final String PAYLOAD_ENCODING_METHOD_ENCODED = "encoded";

    public TestEventEncoder() {
        boolean $i$f$type = false;
        this.messageType = Type.constructor-impl(TypeKt.renderReifiedTypeSignatureString(Reflection.typeOf(OrchestrationMessage.TestEvent.class)));
        this.messageClassifier = OrchestrationMessageEncodersKt.access$classifier("TestEvent");
    }

    @Override
    @NotNull
    public String getMessageType-cAobLks() {
        return this.messageType;
    }

    @Override
    @NotNull
    public OrchestrationMessageClassifier getMessageClassifier() {
        return this.messageClassifier;
    }

    @Override
    @NotNull
    public byte[] encode(@NotNull OrchestrationMessage.TestEvent message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (message.getPayload() == null) {
            return new byte[0];
        }
        String string = message.getPayload().getClass().getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        String payloadType = Type.constructor-impl(string);
        OrchestrationMessageEncoder orchestrationMessageEncoder = OrchestrationMessageEncoderKt.messageEncoderOf-MWpZpg4(payloadType);
        if (orchestrationMessageEncoder == null) {
            return EncodeUtilsKt.encodeByteArray$default(0, arg_0 -> TestEventEncoder.encode$lambda$0(message, arg_0), 1, null);
        }
        OrchestrationMessageEncoder payloadEncoder = orchestrationMessageEncoder;
        return EncodeUtilsKt.encodeByteArray$default(0, arg_0 -> TestEventEncoder.encode$lambda$1(message, payloadEncoder, arg_0), 1, null);
    }

    @Override
    @NotNull
    public Either<OrchestrationMessage.TestEvent, Throwable> decode(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.length == 0) {
            return EitherKt.toLeft(new OrchestrationMessage.TestEvent((Object)null));
        }
        return EncodeUtilsKt.tryDecode(data, TestEventEncoder::decode$lambda$0);
    }

    private static final Unit encode$lambda$0(OrchestrationMessage.TestEvent $message, DataOutputStream $this$encodeByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeByteArray, (String)"$this$encodeByteArray");
        EncodeUtilsKt.writeString($this$encodeByteArray, PAYLOAD_ENCODING_METHOD_JIOS);
        Object object = $message.getPayload();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.io.Serializable");
        EncodeUtilsKt.writeFrame($this$encodeByteArray, SerializableKt.encodeSerializableObject((Serializable)object));
        return Unit.INSTANCE;
    }

    private static final Unit encode$lambda$1(OrchestrationMessage.TestEvent $message, OrchestrationMessageEncoder $payloadEncoder, DataOutputStream $this$encodeByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeByteArray, (String)"$this$encodeByteArray");
        EncodeUtilsKt.writeString($this$encodeByteArray, PAYLOAD_ENCODING_METHOD_ENCODED);
        Object object = $message.getPayload();
        Serializable serializable = object instanceof OrchestrationMessage ? (OrchestrationMessage)object : null;
        EncodeUtilsKt.writeOptionalFrame($this$encodeByteArray, serializable != null && (serializable = ((OrchestrationMessage)serializable).getMessageId()) != null ? ((OrchestrationMessageId)serializable).encodeToByteArray() : null);
        EncodeUtilsKt.writeString($this$encodeByteArray, $payloadEncoder.getMessageClassifier().getNamespace$hot_reload_orchestration());
        EncodeUtilsKt.writeString($this$encodeByteArray, $payloadEncoder.getMessageClassifier().getType$hot_reload_orchestration());
        EncodeUtilsKt.writeFrame($this$encodeByteArray, $payloadEncoder.encode($message.getPayload()));
        return Unit.INSTANCE;
    }

    private static final OrchestrationMessage.TestEvent decode$lambda$0(DataInputStream $this$tryDecode) {
        Intrinsics.checkNotNullParameter((Object)$this$tryDecode, (String)"$this$tryDecode");
        String method = EncodeUtilsKt.readString($this$tryDecode);
        if (Intrinsics.areEqual((Object)method, (Object)PAYLOAD_ENCODING_METHOD_JIOS)) {
            Object payload = SerializableKt.decodeSerializableObject(EncodeUtilsKt.readFrame($this$tryDecode));
            return new OrchestrationMessage.TestEvent(payload);
        }
        if (Intrinsics.areEqual((Object)method, (Object)PAYLOAD_ENCODING_METHOD_ENCODED)) {
            OrchestrationMessage.TestEvent testEvent;
            OrchestrationMessageId orchestrationMessageId;
            byte[] byArray = EncodeUtilsKt.readOptionalFrame($this$tryDecode);
            if (byArray != null) {
                byte[] p0 = byArray;
                boolean bl = false;
                orchestrationMessageId = OrchestrationMessageKt.OrchestrationMessageId(p0);
            } else {
                orchestrationMessageId = null;
            }
            OrchestrationMessageId messageId = orchestrationMessageId;
            OrchestrationMessageClassifier classifier = new OrchestrationMessageClassifier(EncodeUtilsKt.readString($this$tryDecode), EncodeUtilsKt.readString($this$tryDecode));
            OrchestrationMessageEncoder<Object> orchestrationMessageEncoder = OrchestrationMessageEncoderKt.messageEncoderOf(classifier);
            if (orchestrationMessageEncoder == null) {
                throw new IllegalStateException(("Missing encoder for '" + classifier + "'").toString());
            }
            OrchestrationMessageEncoder<Object> encoder = orchestrationMessageEncoder;
            OrchestrationMessage.TestEvent message = testEvent = new OrchestrationMessage.TestEvent(TryKt.getOrThrow(encoder.decode(EncodeUtilsKt.readFrame($this$tryDecode))));
            boolean bl = false;
            if (message.getPayload() instanceof OrchestrationMessage && messageId != null) {
                ((OrchestrationMessage)message.getPayload()).setMessageId$hot_reload_orchestration(messageId);
            }
            return testEvent;
        }
        throw new IllegalStateException(("Unknown method: " + method).toString());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/compose/reload/orchestration/TestEventEncoder$Companion;", "", "<init>", "()V", "PAYLOAD_ENCODING_METHOD_JIOS", "", "PAYLOAD_ENCODING_METHOD_ENCODED", "hot-reload-orchestration"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

