/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.InternalHotReloadApi;
import org.jetbrains.compose.reload.core.ClosureKt;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0007\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0005H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "destroyWithDescendants", "", "Ljava/lang/Process;", "Ljava/lang/ProcessHandle;", "hot-reload-core"})
@SourceDebugExtension(value={"SMAP\nprocessUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 processUtils.kt\norg/jetbrains/compose/reload/core/ProcessUtilsKt\n+ 2 closure.kt\norg/jetbrains/compose/reload/core/ClosureKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,35:1\n83#2,5:36\n343#2,2:41\n88#2:43\n349#2:44\n336#2,3:45\n350#2:48\n351#2:51\n90#2,10:52\n1869#3,2:49\n2756#3:62\n1563#3:64\n1634#3,3:65\n1#4:63\n37#5:68\n36#5,3:69\n22#6:72\n*S KotlinDebug\n*F\n+ 1 processUtils.kt\norg/jetbrains/compose/reload/core/ProcessUtilsKt\n*L\n23#1:36,5\n23#1:41,2\n23#1:43\n23#1:44\n23#1:45,3\n23#1:48\n23#1:51\n23#1:52,10\n23#1:49,2\n24#1:62\n25#1:64\n25#1:65,3\n24#1:63\n28#1:68\n28#1:69,3\n14#1:72\n*E\n"})
public final class ProcessUtilsKt {
    @NotNull
    private static final Logger logger;

    @InternalHotReloadApi
    public static final boolean destroyWithDescendants(@NotNull Process $this$destroyWithDescendants) {
        Intrinsics.checkNotNullParameter((Object)$this$destroyWithDescendants, (String)"<this>");
        ProcessHandle processHandle = $this$destroyWithDescendants.toHandle();
        Intrinsics.checkNotNullExpressionValue((Object)processHandle, (String)"toHandle(...)");
        return ProcessUtilsKt.destroyWithDescendants(processHandle);
    }

    /*
     * WARNING - void declaration
     */
    @InternalHotReloadApi
    public static final boolean destroyWithDescendants(@NotNull ProcessHandle $this$destroyWithDescendants) {
        void $this$mapTo$iv$iv;
        ProcessHandle handle;
        Collection collection;
        Set set;
        Object handle2;
        block8: {
            List list;
            boolean bl;
            ProcessHandle $this$withClosure$iv;
            block9: {
                Iterable elements$iv$iv;
                Iterable initialEdges$iv;
                block6: {
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)$this$destroyWithDescendants, (String)"<this>");
                        $this$withClosure$iv = $this$destroyWithDescendants;
                        boolean $i$f$withClosure = false;
                        handle2 = $this$withClosure$iv;
                        bl = false;
                        Stream<ProcessHandle> stream = handle2.children();
                        Intrinsics.checkNotNullExpressionValue(stream, (String)"children(...)");
                        initialEdges$iv = SequencesKt.toList((Sequence)StreamsKt.asSequence(stream));
                        if (!(initialEdges$iv instanceof Collection)) break block6;
                        if (!((Collection)initialEdges$iv).isEmpty()) break block7;
                        set = SetsKt.setOf((Object)$this$withClosure$iv);
                        break block8;
                    }
                    elements$iv$iv = (Collection)initialEdges$iv;
                    boolean $i$f$createDequeue = false;
                    list = KotlinVersion.CURRENT.isAtLeast(1, 4) ? (List)new ArrayDeque((Collection)elements$iv$iv) : (List)new ArrayList(elements$iv$iv);
                    break block9;
                }
                elements$iv$iv = initialEdges$iv;
                boolean $i$f$createDequeueFromIterable = false;
                int initialSize$iv$iv$iv = 16;
                boolean $i$f$createDequeue = false;
                List $this$createDequeueFromIterable_u24lambda_u240$iv$iv = initialSize$iv$iv$iv = KotlinVersion.CURRENT.isAtLeast(1, 4) ? (List)new ArrayDeque(initialSize$iv$iv$iv) : (List)new ArrayList(initialSize$iv$iv$iv);
                boolean bl2 = false;
                Iterable $this$forEach$iv$iv$iv = elements$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    $this$createDequeueFromIterable_u24lambda_u240$iv$iv.add(element$iv$iv);
                }
                list = initialSize$iv$iv$iv;
            }
            List dequeue$iv = list;
            Set results$iv = ClosureKt.createResultSet(dequeue$iv.size());
            results$iv.add($this$withClosure$iv);
            while (!((Collection)dequeue$iv).isEmpty()) {
                Object element$iv = dequeue$iv.remove(0);
                if (!results$iv.add(element$iv)) continue;
                handle2 = (ProcessHandle)element$iv;
                collection = dequeue$iv;
                bl = false;
                Stream<ProcessHandle> stream = handle2.children();
                Intrinsics.checkNotNullExpressionValue(stream, (String)"children(...)");
                CollectionsKt.addAll((Collection)collection, (Iterable)SequencesKt.toList((Sequence)StreamsKt.asSequence(stream)));
            }
            set = results$iv;
        }
        Iterable $this$onEach$iv = CollectionsKt.reversed((Iterable)set);
        boolean $i$f$onEach = false;
        Object $this$onEach_u24lambda_u2418$iv = handle2 = $this$onEach$iv;
        boolean bl = false;
        Iterator iterator = $this$onEach_u24lambda_u2418$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            handle = (ProcessHandle)element$iv;
            boolean bl4 = false;
            if (handle.destroy()) continue;
            handle.destroyForcibly();
        }
        Object $this$map$iv = handle2;
        boolean $i$f$map = false;
        handle2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            handle = (ProcessHandle)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(it.onExit());
        }
        List exits = (List)destination$iv$iv;
        try {
            Collection $this$toTypedArray$iv = exits;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
            CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).get(5L, TimeUnit.SECONDS);
            return true;
        }
        catch (Throwable t) {
            long l = $this$destroyWithDescendants.pid();
            Optional<String> optional = $this$destroyWithDescendants.info().command();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"command(...)");
            LoggingKt.error(logger, "Process '" + l + "' (" + OptionalsKt.getOrNull(optional) + " was not destroyed within time", t);
            return false;
        }
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default(string, null, null, 6, null);
    }
}

