/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.io.ByteArrayInputStream;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.agent.JavassistKt;
import org.jetbrains.compose.reload.agent.WindowInstrumentation;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.Ids;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.shaded.javassist.CtClass;
import org.jetbrains.compose.reload.shaded.javassist.expr.ExprEditor;
import org.jetbrains.compose.reload.shaded.javassist.expr.MethodCall;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u001a\u0017\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0017\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "launchWindowInstrumentation", "", "instrumentation", "Ljava/lang/instrument/Instrumentation;", "transformSetContent", "", "loader", "Ljava/lang/ClassLoader;", "classfileBuffer", "wrapSetContent1", "", "windowClass", "Lorg/jetbrains/compose/reload/analysis/ClassId;", "wrapSetContent1-j3M2jLw", "(Ljava/lang/String;)Ljava/lang/String;", "wrapSetContent3", "wrapSetContent3-j3M2jLw", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\nwindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 window.kt\norg/jetbrains/compose/reload/agent/WindowKt\n+ 2 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,122:1\n22#2:123\n*S KotlinDebug\n*F\n+ 1 window.kt\norg/jetbrains/compose/reload/agent/WindowKt\n*L\n19#1:123\n*E\n"})
public final class WindowKt {
    @NotNull
    private static final Logger logger;

    public static final void launchWindowInstrumentation(@NotNull Instrumentation instrumentation) {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        if (!HotReloadEnvironment.INSTANCE.getDevToolsEnabled()) {
            return;
        }
        if (HotReloadEnvironment.INSTANCE.isHeadless()) {
            return;
        }
        instrumentation.addTransformer(WindowInstrumentation.INSTANCE);
    }

    private static final byte[] transformSetContent(ClassLoader loader, byte[] classfileBuffer) {
        ClassLoader classLoader = loader;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        ClassLoader classLoader2 = classLoader;
        Intrinsics.checkNotNull((Object)classLoader2);
        CtClass ctClass = JavassistKt.getClassPool(classLoader2).makeClass(new ByteArrayInputStream(classfileBuffer));
        Ref.BooleanRef transformed = new Ref.BooleanRef();
        try {
            ctClass.instrument(new ExprEditor(transformed){
                final /* synthetic */ Ref.BooleanRef $transformed;
                {
                    this.$transformed = $transformed;
                }

                public void edit(MethodCall m) {
                    Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                    try {
                        MethodId methodId = JavassistKt.getMethodId(m);
                        if (Intrinsics.areEqual((Object)methodId, (Object)Ids.ComposeWindow.INSTANCE.getSetContent_1())) {
                            m.replace(WindowKt.access$wrapSetContent1-j3M2jLw(Ids.ComposeWindow.INSTANCE.getClassId-uSFnFHE()));
                            this.$transformed.element = true;
                        } else if (Intrinsics.areEqual((Object)methodId, (Object)Ids.ComposeWindow.INSTANCE.getSetContent_3())) {
                            m.replace(WindowKt.access$wrapSetContent3-j3M2jLw(Ids.ComposeWindow.INSTANCE.getClassId-uSFnFHE()));
                            this.$transformed.element = true;
                        } else if (Intrinsics.areEqual((Object)methodId, (Object)Ids.ComposeDialog.INSTANCE.getSetContent_1())) {
                            m.replace(WindowKt.access$wrapSetContent1-j3M2jLw(Ids.ComposeDialog.INSTANCE.getClassId-uSFnFHE()));
                            this.$transformed.element = true;
                        } else if (Intrinsics.areEqual((Object)methodId, (Object)Ids.ComposeDialog.INSTANCE.getSetContent_3())) {
                            m.replace(WindowKt.access$wrapSetContent3-j3M2jLw(Ids.ComposeDialog.INSTANCE.getClassId-uSFnFHE()));
                            this.$transformed.element = true;
                        }
                    }
                    catch (Throwable t) {
                        LoggingKt.error(WindowKt.access$getLogger$p(), "Failed to transform 'setContent' method", t);
                    }
                }
            });
            return transformed.element ? ctClass.toBytecode() : null;
        }
        catch (Throwable t) {
            LoggingKt.error(logger, "Failed to transform 'WindowKt'", t);
            return null;
        }
    }

    private static final String wrapSetContent1-j3M2jLw(String string) {
        return StringsKt.trimIndent((String)("\n    {\n        // Store parameters in local variables to maintain stack\n        " + ClassId.toFqn-impl(string) + " window = $0;\n        kotlin.jvm.functions.Function3 p1= $1;\n        \n        // Call the development entry point with stored parameters\n        org.jetbrains.compose.reload.jvm.JvmDevelopmentEntryPoint.setContent(\n            window, p1\n        );\n    }\n    "));
    }

    private static final String wrapSetContent3-j3M2jLw(String string) {
        return StringsKt.trimIndent((String)("\n    {\n        // Store parameters in local variables to maintain stack\n        " + ClassId.toFqn-impl(string) + " window = $0;\n        kotlin.jvm.functions.Function1 p1 = $1;\n        kotlin.jvm.functions.Function1 p2 = $2;\n        kotlin.jvm.functions.Function3 p3 = $3;\n        \n        // Call the development entry point with stored parameters\n        org.jetbrains.compose.reload.jvm.JvmDevelopmentEntryPoint.setContent(\n            window, p1, p2, p3\n        );\n    }\n    "));
    }

    public static final /* synthetic */ byte[] access$transformSetContent(ClassLoader loader, byte[] classfileBuffer) {
        return WindowKt.transformSetContent(loader, classfileBuffer);
    }

    public static final /* synthetic */ String access$wrapSetContent1-j3M2jLw(String string) {
        return WindowKt.wrapSetContent1-j3M2jLw(string);
    }

    public static final /* synthetic */ String access$wrapSetContent3-j3M2jLw(String string) {
        return WindowKt.wrapSetContent3-j3M2jLw(string);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default(string, null, null, 6, null);
    }
}

