/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.agent.OrchestrationKt;
import org.jetbrains.compose.reload.core.FutureKt;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.jetbrains.compose.reload.core.LockFile;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.core.PidFileInfo;
import org.jetbrains.compose.reload.core.PidFileInfoKt;
import org.jetbrains.compose.reload.core.PidFileLockKt;
import org.jetbrains.compose.reload.core.TryKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "createPidfile", "", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\npidfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 pidfile.kt\norg/jetbrains/compose/reload/agent/PidfileKt\n+ 2 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,40:1\n22#2:41\n*S KotlinDebug\n*F\n+ 1 pidfile.kt\norg/jetbrains/compose/reload/agent/PidfileKt\n*L\n19#1:41\n*E\n"})
public final class PidfileKt {
    @NotNull
    private static final Logger logger;

    public static final void createPidfile() {
        Path path = HotReloadEnvironment.INSTANCE.getPidFile();
        if (path == null) {
            return;
        }
        Path pidFile = path;
        PidFileInfo myPidFileInfo = new PidFileInfo(ProcessHandle.current().pid(), TryKt.getOrThrow(FutureKt.getBlocking(OrchestrationKt.getOrchestration().getPort())));
        LockFile lockFile = PidFileLockKt.getRunDirectoryLockFile();
        if (lockFile != null) {
            lockFile.withLock(() -> PidfileKt.createPidfile$lambda$0(pidFile, myPidFileInfo));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> PidfileKt.createPidfile$lambda$1(pidFile, myPidFileInfo)));
    }

    private static final Unit createPidfile$lambda$0(Path $pidFile, PidFileInfo $myPidFileInfo) {
        PidFileInfoKt.writePidFile(PathsKt.createParentDirectories((Path)$pidFile, (FileAttribute[])new FileAttribute[0]), $myPidFileInfo);
        LoggingKt.debug(logger, "Created pid file: " + $pidFile.toUri());
        return Unit.INSTANCE;
    }

    private static final void createPidfile$lambda$1(Path $pidFile, PidFileInfo $myPidFileInfo) {
        block0: {
            LockFile lockFile = PidFileLockKt.getRunDirectoryLockFile();
            if (lockFile == null) break block0;
            lockFile.withLock(() -> PidfileKt.createPidfile$lambda$1$0($pidFile, $myPidFileInfo));
        }
    }

    private static final Unit createPidfile$lambda$1$0(Path $pidFile, PidFileInfo $myPidFileInfo) {
        PidFileInfoKt.deleteMyPidFileIfExists($pidFile, $myPidFileInfo);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default(string, null, null, 6, null);
    }
}

