/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.lang.invoke.MethodHandles;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.agent.DevToolsHandle;
import org.jetbrains.compose.reload.agent.DevToolsKt;
import org.jetbrains.compose.reload.agent.LoggingKt;
import org.jetbrains.compose.reload.core.Broadcast;
import org.jetbrains.compose.reload.core.BroadcastKt;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.Future;
import org.jetbrains.compose.reload.core.FutureKt;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.core.StoppedException;
import org.jetbrains.compose.reload.core.Task;
import org.jetbrains.compose.reload.core.TaskKt;
import org.jetbrains.compose.reload.core.TryKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationClient;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientRole;
import org.jetbrains.compose.reload.orchestration.OrchestrationHandle;
import org.jetbrains.compose.reload.orchestration.OrchestrationHandleKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationListenerKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.jetbrains.compose.reload.orchestration.OrchestrationServer;
import org.jetbrains.compose.reload.orchestration.OrchestrationServerKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\u000b\u001a\n\u0010\f\u001a\u00020\t*\u00020\n\u001a\u0010\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e*\u00020\n\u001a\b\u0010\u000f\u001a\u00020\tH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0002\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "orchestration", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationHandle;", "getOrchestration", "()Lorg/jetbrains/compose/reload/orchestration/OrchestrationHandle;", "orchestration$delegate", "Lkotlin/Lazy;", "send", "", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage;", "(Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendBlocking", "sendAsync", "Lorg/jetbrains/compose/reload/core/Future;", "startOrchestration", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\norchestration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 orchestration.kt\norg/jetbrains/compose/reload/agent/OrchestrationKt\n+ 2 Broadcast.kt\norg/jetbrains/compose/reload/core/BroadcastKt\n+ 3 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,118:1\n36#2:119\n22#3:120\n*S KotlinDebug\n*F\n+ 1 orchestration.kt\norg/jetbrains/compose/reload/agent/OrchestrationKt\n*L\n77#1:119\n36#1:120\n*E\n"})
public final class OrchestrationKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Lazy orchestration$delegate;

    @NotNull
    public static final OrchestrationHandle getOrchestration() {
        Lazy lazy = orchestration$delegate;
        return (OrchestrationHandle)lazy.getValue();
    }

    @Nullable
    public static final Object send(@NotNull OrchestrationMessage $this$send, @NotNull Continuation<? super Unit> $completion) {
        Object object = OrchestrationKt.getOrchestration().send($this$send, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final void sendBlocking(@NotNull OrchestrationMessage $this$sendBlocking) {
        Intrinsics.checkNotNullParameter((Object)$this$sendBlocking, (String)"<this>");
        TryKt.getOrThrow(FutureKt.getBlocking-HG0u8IE(TaskKt.launchTask((Function2)new Function2<Task<? extends Unit>, Continuation<? super Unit>, Object>($this$sendBlocking, null){
            int label;
            final /* synthetic */ OrchestrationMessage $this_sendBlocking;
            {
                this.$this_sendBlocking = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = OrchestrationKt.getOrchestration().send(this.$this_sendBlocking, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Task<Unit> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.SECONDS)));
    }

    @NotNull
    public static final Future<Unit> sendAsync(@NotNull OrchestrationMessage $this$sendAsync) {
        Intrinsics.checkNotNullParameter((Object)$this$sendAsync, (String)"<this>");
        return TaskKt.launchTask((Function2)new Function2<Task<? extends Unit>, Continuation<? super Unit>, Object>($this$sendAsync, null){
            int label;
            final /* synthetic */ OrchestrationMessage $this_sendAsync;
            {
                this.$this_sendAsync = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = OrchestrationKt.send(this.$this_sendAsync, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Task<Unit> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public static final void startOrchestration() {
        OrchestrationHandle orchestration = OrchestrationKt.getOrchestration();
        Broadcast<OrchestrationMessage> $this$withType$iv = orchestration.getMessages();
        boolean $i$f$withType = false;
        BroadcastKt.invokeOnValue(new Broadcast<OrchestrationMessage.ShutdownRequest>($this$withType$iv){
            final /* synthetic */ Broadcast $this_withType;
            {
                this.$this_withType = $receiver;
            }

            public Object collect(Function2<? super OrchestrationMessage.ShutdownRequest, ? super Continuation<? super Unit>, ? extends Object> action, Continuation<? super Unit> $completion) {
                Object object = this.$this_withType.collect((Function2)new Function2<Object, Continuation<? super Unit>, Object>(action, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ Function2 $action;
                    {
                        this.$action = $action;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Object it = this.L$0;
                                if (!(it instanceof OrchestrationMessage.ShutdownRequest)) return Unit.INSTANCE;
                                this.label = 1;
                                Object object3 = this.$action.invoke(it, (Object)((Object)this));
                                Object object4 = object3;
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object4 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(Object p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }, OrchestrationKt::startOrchestration$lambda$0);
        FutureKt.invokeOnCompletion(orchestration, OrchestrationKt::startOrchestration$lambda$1);
        Runtime.getRuntime().addShutdownHook(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> OrchestrationKt.startOrchestration$lambda$2(orchestration), (int)30, null));
        if (orchestration instanceof OrchestrationClient) {
            OrchestrationHandleKt.connectBlocking((OrchestrationClient)orchestration);
            org.jetbrains.compose.reload.core.LoggingKt.debug(logger, "Agent: 'Client' mode (connected to '" + orchestration.getPort().getOrNull() + "')");
        }
        if (orchestration instanceof OrchestrationServer) {
            OrchestrationHandleKt.startBlocking((OrchestrationServer)orchestration);
            OrchestrationListenerKt.connectAllOrchestrationListeners((OrchestrationServer)orchestration);
            org.jetbrains.compose.reload.core.LoggingKt.debug(logger, "Agent: Server started on port '" + orchestration.getPort().getOrNull() + "'");
        }
        LoggingKt.startDispatchingLogs(orchestration);
    }

    private static final OrchestrationHandle orchestration_delegate$lambda$0() {
        Integer n = HotReloadEnvironment.INSTANCE.getOrchestrationPort();
        if (n != null) {
            int port = ((Number)n).intValue();
            boolean bl = false;
            return OrchestrationClientKt.OrchestrationClient(OrchestrationClientRole.Application, port);
        }
        DevToolsHandle devToolsHandle = DevToolsKt.getDevTools();
        if (devToolsHandle != null) {
            int port = devToolsHandle.getOrchestrationPort();
            boolean bl = false;
            return OrchestrationClientKt.OrchestrationClient(OrchestrationClientRole.Application, port);
        }
        return OrchestrationServerKt.OrchestrationServer();
    }

    private static final Unit startOrchestration$lambda$0(OrchestrationMessage.ShutdownRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!request.isApplicable()) {
            org.jetbrains.compose.reload.core.LoggingKt.warn(logger, "ShutdownRequest(" + request.getReason() + ") ignored ('isApplicable() == false)");
            return Unit.INSTANCE;
        }
        org.jetbrains.compose.reload.core.LoggingKt.info(logger, "Received shutdown request '" + request.getReason() + "'");
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final Unit startOrchestration$lambda$1(Either it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        org.jetbrains.compose.reload.core.LoggingKt.info(logger, "Application Orchestration closed");
        if (TryKt.isFailure(it) && !(TryKt.getException((Right)it) instanceof StoppedException)) {
            System.err.println("Application Orchestration closed");
            TryKt.getException((Right)it).printStackTrace(System.err);
            System.err.flush();
        }
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final Unit startOrchestration$lambda$2(OrchestrationHandle $orchestration) {
        org.jetbrains.compose.reload.core.LoggingKt.info(logger, "Hot Reload Agent is shutting down");
        $orchestration.close();
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        logger = org.jetbrains.compose.reload.core.LoggingKt.createLogger-e0kQHLI$default(string, null, null, 6, null);
        orchestration$delegate = LazyKt.lazy(OrchestrationKt::orchestration_delegate$lambda$0);
    }
}

