/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.orchestration;

import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.core.State;
import org.jetbrains.compose.reload.core.Update;
import org.jetbrains.compose.reload.orchestration.Binary;
import org.jetbrains.compose.reload.orchestration.OrchestrationState;
import org.jetbrains.compose.reload.orchestration.OrchestrationStateId;
import org.jetbrains.compose.reload.orchestration.OrchestrationStateKey;
import org.jetbrains.compose.reload.orchestration.OrchestrationStateStorage;
import org.jetbrains.compose.reload.orchestration.OrchestrationStates;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ:\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\f\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000f2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\u00070\u0010J$\u0010\u000b\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0015J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0018\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0019J\u001a\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00182\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/compose/reload/orchestration/OrchestrationServerStates;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationStates;", "<init>", "()V", "storage", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateStorage;", "withLock", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "update", "Lorg/jetbrains/compose/reload/core/Update;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;", "key", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateKey;", "Lkotlin/Function1;", "", "id", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateId;", "expectedValue", "Lorg/jetbrains/compose/reload/orchestration/Binary;", "newValue", "get", "Lorg/jetbrains/compose/reload/core/State;", "(Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateKey;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getEncodedState", "StateUpdate", "hot-reload-orchestration"})
@SourceDebugExtension(value={"SMAP\nOrchestrationStates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrchestrationStates.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationServerStates\n+ 2 OrchestrationStateStorage.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationStateStorage\n*L\n1#1,122:1\n36#2:123\n36#2:124\n*S KotlinDebug\n*F\n+ 1 OrchestrationStates.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationServerStates\n*L\n34#1:123\n40#1:124\n*E\n"})
public final class OrchestrationServerStates
implements OrchestrationStates {
    @NotNull
    private final OrchestrationStateStorage storage = new OrchestrationStateStorage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withLock(@NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$withLock = false;
        OrchestrationStateStorage this_$iv = this.storage;
        boolean $i$f$withLock2 = false;
        Lock lock = OrchestrationStateStorage.access$getLock$p(this_$iv);
        lock.lock();
        try {
            boolean bl = false;
            object = action.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            lock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final <T extends OrchestrationState> Update<T> update(@NotNull OrchestrationStateKey<T> key, @NotNull Function1<? super T, ? extends T> update2) {
        Update<OrchestrationState> update3;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(update2, (String)"update");
        OrchestrationStateStorage this_$iv = this.storage;
        boolean $i$f$withLock = false;
        Lock lock = OrchestrationStateStorage.access$getLock$p(this_$iv);
        lock.lock();
        try {
            boolean bl = false;
            OrchestrationState currentState = (OrchestrationState)this.storage.getDecodedState(key).getValue();
            OrchestrationState nextState = (OrchestrationState)update2.invoke((Object)currentState);
            this.storage.update(key, nextState);
            update3 = new Update<OrchestrationState>(currentState, nextState);
        }
        finally {
            lock.unlock();
        }
        return update3;
    }

    public final boolean update(@NotNull OrchestrationStateId<?> id, @Nullable Binary expectedValue, @NotNull Binary newValue) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        return this.storage.update(id, expectedValue, newValue);
    }

    @Override
    @Nullable
    public <T extends OrchestrationState> Object get(@NotNull OrchestrationStateKey<T> key, @NotNull Continuation<? super State<T>> $completion) {
        return this.storage.getDecodedState(key);
    }

    @NotNull
    public final State<Binary> getEncodedState(@NotNull OrchestrationStateId<?> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return this.storage.getEncodedState(id);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B7\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000e\u0010\u0017\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0018\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003JN\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\b\b\u0002\u0010\u0006\u001a\u00028\u00002\b\b\u0002\u0010\u0007\u001a\u00028\u00002\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006$"}, d2={"Lorg/jetbrains/compose/reload/orchestration/OrchestrationServerStates$StateUpdate;", "T", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;", "", "id", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateId;", "previousState", "updatedState", "previousStateEncoded", "Lorg/jetbrains/compose/reload/orchestration/Binary;", "updatedStateEncoded", "<init>", "(Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateId;Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;Lorg/jetbrains/compose/reload/orchestration/Binary;Lorg/jetbrains/compose/reload/orchestration/Binary;)V", "getId", "()Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateId;", "getPreviousState", "()Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;", "getUpdatedState", "getPreviousStateEncoded", "()Lorg/jetbrains/compose/reload/orchestration/Binary;", "getUpdatedStateEncoded", "component1", "component2", "component3", "component4", "component5", "copy", "(Lorg/jetbrains/compose/reload/orchestration/OrchestrationStateId;Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;Lorg/jetbrains/compose/reload/orchestration/OrchestrationState;Lorg/jetbrains/compose/reload/orchestration/Binary;Lorg/jetbrains/compose/reload/orchestration/Binary;)Lorg/jetbrains/compose/reload/orchestration/OrchestrationServerStates$StateUpdate;", "equals", "", "other", "hashCode", "", "toString", "", "hot-reload-orchestration"})
    public static final class StateUpdate<T extends OrchestrationState> {
        @NotNull
        private final OrchestrationStateId<T> id;
        private final T previousState;
        private final T updatedState;
        @Nullable
        private final Binary previousStateEncoded;
        @NotNull
        private final Binary updatedStateEncoded;

        public StateUpdate(@NotNull OrchestrationStateId<T> id, T previousState, T updatedState, @Nullable Binary previousStateEncoded, @NotNull Binary updatedStateEncoded) {
            Intrinsics.checkNotNullParameter(id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)updatedStateEncoded, (String)"updatedStateEncoded");
            this.id = id;
            this.previousState = previousState;
            this.updatedState = updatedState;
            this.previousStateEncoded = previousStateEncoded;
            this.updatedStateEncoded = updatedStateEncoded;
        }

        @NotNull
        public final OrchestrationStateId<T> getId() {
            return this.id;
        }

        public final T getPreviousState() {
            return this.previousState;
        }

        public final T getUpdatedState() {
            return this.updatedState;
        }

        @Nullable
        public final Binary getPreviousStateEncoded() {
            return this.previousStateEncoded;
        }

        @NotNull
        public final Binary getUpdatedStateEncoded() {
            return this.updatedStateEncoded;
        }

        @NotNull
        public final OrchestrationStateId<T> component1() {
            return this.id;
        }

        public final T component2() {
            return this.previousState;
        }

        public final T component3() {
            return this.updatedState;
        }

        @Nullable
        public final Binary component4() {
            return this.previousStateEncoded;
        }

        @NotNull
        public final Binary component5() {
            return this.updatedStateEncoded;
        }

        @NotNull
        public final StateUpdate<T> copy(@NotNull OrchestrationStateId<T> id, T previousState, T updatedState, @Nullable Binary previousStateEncoded, @NotNull Binary updatedStateEncoded) {
            Intrinsics.checkNotNullParameter(id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)updatedStateEncoded, (String)"updatedStateEncoded");
            return new StateUpdate<T>(id, previousState, updatedState, previousStateEncoded, updatedStateEncoded);
        }

        public static /* synthetic */ StateUpdate copy$default(StateUpdate stateUpdate, OrchestrationStateId orchestrationStateId, OrchestrationState orchestrationState, OrchestrationState orchestrationState2, Binary binary, Binary binary2, int n, Object object) {
            if ((n & 1) != 0) {
                orchestrationStateId = stateUpdate.id;
            }
            if ((n & 2) != 0) {
                orchestrationState = stateUpdate.previousState;
            }
            if ((n & 4) != 0) {
                orchestrationState2 = stateUpdate.updatedState;
            }
            if ((n & 8) != 0) {
                binary = stateUpdate.previousStateEncoded;
            }
            if ((n & 0x10) != 0) {
                binary2 = stateUpdate.updatedStateEncoded;
            }
            return stateUpdate.copy(orchestrationStateId, orchestrationState, orchestrationState2, binary, binary2);
        }

        @NotNull
        public String toString() {
            return "StateUpdate(id=" + this.id + ", previousState=" + this.previousState + ", updatedState=" + this.updatedState + ", previousStateEncoded=" + this.previousStateEncoded + ", updatedStateEncoded=" + this.updatedStateEncoded + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + (this.previousState == null ? 0 : this.previousState.hashCode());
            result = result * 31 + (this.updatedState == null ? 0 : this.updatedState.hashCode());
            result = result * 31 + (this.previousStateEncoded == null ? 0 : this.previousStateEncoded.hashCode());
            result = result * 31 + this.updatedStateEncoded.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StateUpdate)) {
                return false;
            }
            StateUpdate stateUpdate = (StateUpdate)other;
            if (!Intrinsics.areEqual(this.id, stateUpdate.id)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.previousState, stateUpdate.previousState)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.updatedState, stateUpdate.updatedState)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.previousStateEncoded, (Object)stateUpdate.previousStateEncoded)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.updatedStateEncoded, (Object)stateUpdate.updatedStateEncoded);
        }
    }
}

