/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.InternalHotReloadApi;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u001e\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"copyRecursivelyToZip", "", "Ljava/nio/file/Path;", "target", "overwrite", "", "unzipTo", "openOptions", "", "Ljava/nio/file/OpenOption;", "(Z)[Ljava/nio/file/OpenOption;", "hot-reload-core"})
@SourceDebugExtension(value={"SMAP\nzip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 zip.kt\norg/jetbrains/compose/reload/core/ZipKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1321#2:89\n1322#2:91\n1#3:90\n*S KotlinDebug\n*F\n+ 1 zip.kt\norg/jetbrains/compose/reload/core/ZipKt\n*L\n36#1:89\n36#1:91\n*E\n"})
public final class ZipKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InternalHotReloadApi
    public static final void copyRecursivelyToZip(@NotNull Path $this$copyRecursivelyToZip, @NotNull Path target, boolean overwrite) {
        Intrinsics.checkNotNullParameter((Object)$this$copyRecursivelyToZip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory($this$copyRecursivelyToZip, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IllegalStateException(($this$copyRecursivelyToZip.toUri().toURL() + ": Not a directory").toString());
        }
        Object object = target;
        Object object2 = ZipKt.openOptions(overwrite);
        object2 = Arrays.copyOf(object2, ((OpenOption[])object2).length);
        OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        object = new ZipOutputStream(outputStream);
        object2 = null;
        try {
            ZipOutputStream zip = (ZipOutputStream)object;
            boolean bl = false;
            PathWalkOption[] pathWalkOptionArray = new PathWalkOption[]{PathWalkOption.INCLUDE_DIRECTORIES};
            Sequence $this$forEach$iv = PathsKt.walk((Path)$this$copyRecursivelyToZip, (PathWalkOption[])pathWalkOptionArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object3;
                Object object4;
                Path path = (Path)element$iv;
                boolean bl2 = false;
                Object object5 = PathsKt.relativeToOrNull((Path)path, (Path)$this$copyRecursivelyToZip);
                if (object5 == null || (object5 = PathsKt.getInvariantSeparatorsPathString((Path)object5)) == null) continue;
                Object name = object5;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    void $this$copyRecursivelyToZip_u24lambda_u240_u240_u240;
                    object3 = object4 = new ZipEntry((String)name + "/");
                    ZipOutputStream zipOutputStream = zip;
                    boolean bl3 = false;
                    $this$copyRecursivelyToZip_u24lambda_u240_u240_u240.setMethod(0);
                    $this$copyRecursivelyToZip_u24lambda_u240_u240_u240.setSize(0L);
                    $this$copyRecursivelyToZip_u24lambda_u240_u240_u240.setCrc(0L);
                    zipOutputStream.putNextEntry((ZipEntry)object4);
                }
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                if (!Files.isRegularFile(path, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) continue;
                zip.putNextEntry(new ZipEntry((String)name));
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                object4 = inputStream;
                object3 = null;
                try {
                    InputStream input = (InputStream)object4;
                    boolean bl4 = false;
                    long l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)zip, (int)0, (int)2, null);
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object4, (Throwable)object3);
                }
                zip.closeEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    public static /* synthetic */ void copyRecursivelyToZip$default(Path path, Path path2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        ZipKt.copyRecursivelyToZip(path, path2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InternalHotReloadApi
    public static final void unzipTo(@NotNull Path $this$unzipTo, @NotNull Path target, boolean overwrite) {
        Intrinsics.checkNotNullParameter((Object)$this$unzipTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        OpenOption[] openOptions = ZipKt.openOptions(overwrite);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile($this$unzipTo, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IllegalStateException(($this$unzipTo.toUri().toURL() + ": Not a file").toString());
        }
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream($this$unzipTo, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = new ZipInputStream(inputStream);
        Throwable throwable = null;
        try {
            ZipInputStream zipInputStream = (ZipInputStream)closeable;
            boolean bl = false;
            while (zipInputStream.getNextEntry() != null) {
                ZipEntry entry;
                if (Intrinsics.areEqual((Object)entry.getName(), (Object)"/")) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                Path targetFile = target.resolve(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"/"), (CharSequence)"/"));
                if (CollectionsKt.contains((Iterable)$this$unzipTo, (Object)targetFile)) {
                    throw new IllegalStateException((entry.getName() + ": Escapes the current directory").toString());
                }
                if (entry.isDirectory()) {
                    Intrinsics.checkNotNull((Object)targetFile);
                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(targetFile, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                }
                if (!entry.isDirectory()) {
                    Intrinsics.checkNotNull((Object)targetFile);
                    OpenOption[] openOptionArray2 = Arrays.copyOf(openOptions, openOptions.length);
                    OutputStream outputStream = Files.newOutputStream(PathsKt.createParentDirectories((Path)targetFile, (FileAttribute[])new FileAttribute[0]), Arrays.copyOf(openOptionArray2, openOptionArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                    Closeable closeable2 = outputStream;
                    Throwable throwable2 = null;
                    try {
                        OutputStream out = (OutputStream)closeable2;
                        boolean bl2 = false;
                        long l = ByteStreamsKt.copyTo$default((InputStream)zipInputStream, (OutputStream)out, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                zipInputStream.closeEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void unzipTo$default(Path path, Path path2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        ZipKt.unzipTo(path, path2, bl);
    }

    private static final OpenOption[] openOptions(boolean overwrite) {
        OpenOption[] openOptionArray;
        if (overwrite) {
            OpenOption[] openOptionArray2 = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            openOptionArray = openOptionArray2;
        } else {
            OpenOption[] openOptionArray3 = new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE};
            openOptionArray = openOptionArray3;
        }
        return openOptionArray;
    }
}

