/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.core;

import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.InternalHotReloadApi;

@InternalHotReloadApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/compose/reload/core/LockFile;", "", "lock", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "internalLock", "Ljava/util/concurrent/locks/ReentrantLock;", "withLock", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "hot-reload-core"})
@SourceDebugExtension(value={"SMAP\nLockFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LockFile.kt\norg/jetbrains/compose/reload/core/LockFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1#2:32\n*E\n"})
public final class LockFile {
    @NotNull
    private final Path lock;
    @NotNull
    private final ReentrantLock internalLock;

    public LockFile(@NotNull Path lock) {
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        this.lock = lock;
        this.internalLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withLock(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (this.internalLock.isHeldByCurrentThread()) {
            return (T)action.invoke();
        }
        Lock lock = this.internalLock;
        lock.lock();
        try {
            Object object;
            boolean bl = false;
            Object object2 = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
            FileChannel lockFileChannel = FileChannel.open(this.lock, object2);
            object2 = lockFileChannel.lock();
            Throwable throwable = null;
            try {
                FileLock it = (FileLock)object2;
                boolean bl2 = false;
                object = action.invoke();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)throwable);
            }
            Object object3 = object;
            return (T)object3;
        }
        finally {
            lock.unlock();
        }
    }
}

