/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.agent.RuntimeTrackingKt;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.Ids;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.core.Context;
import org.jetbrains.compose.reload.core.FileUtilsKt;
import org.jetbrains.compose.reload.core.Logger;
import org.jetbrains.compose.reload.core.LoggingKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a'\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\b\u0010\f\u001a\u00020\u0003H\u0002\u001a\b\u0010\r\u001a\u00020\u0003H\u0002\u001a\f\u0010\u000e\u001a\u00020\u0003*\u00020\u000fH\u0000\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"logger", "Lorg/jetbrains/compose/reload/core/Logger;", "cleanResourceCache", "", "classId", "Lorg/jetbrains/compose/reload/analysis/ClassId;", "cleanMethod", "Lorg/jetbrains/compose/reload/analysis/MethodId;", "resourceCacheType", "", "cleanResourceCache-uEB1Bto", "(Ljava/lang/String;Lorg/jetbrains/compose/reload/analysis/MethodId;Ljava/lang/String;)V", "tryCleanResourceCaches", "tryCleanResourceCachesForOldCompose", "cleanResourceCacheIfNecessary", "Lorg/jetbrains/compose/reload/core/Context;", "hasChangedResources", "", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\nresources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 resources.kt\norg/jetbrains/compose/reload/agent/ResourcesKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,84:1\n188#2,3:85\n22#3:88\n*S KotlinDebug\n*F\n+ 1 resources.kt\norg/jetbrains/compose/reload/agent/ResourcesKt\n*L\n80#1:85,3\n18#1:88\n*E\n"})
public final class ResourcesKt {
    @NotNull
    private static final Logger logger;

    private static final void cleanResourceCache-uEB1Bto(String string, MethodId cleanMethod, String resourceCacheType) {
        try {
            ClassLoader loader = RuntimeTrackingKt.findClassLoader-j3M2jLw(string).get();
            if (loader == null) {
                LoggingKt.info(logger, resourceCacheType + " resource cache cleaning skipped: '" + ClassId.toString-impl(string) + "' is not loaded yet.");
                return;
            }
            loader.loadClass(ClassId.toFqn-impl(string)).getDeclaredMethod(cleanMethod.getMethodName(), new Class[0]).invoke(null, new Object[0]);
            LoggingKt.info(logger, resourceCacheType + " resource cache cleared");
        }
        catch (Throwable t) {
            LoggingKt.error(logger, resourceCacheType + " resource cache cleaning failed", t);
        }
    }

    private static final void tryCleanResourceCaches() {
        try {
            String classId = Ids.ResourceCaches.INSTANCE.getClassId-uSFnFHE();
            ClassLoader loader = RuntimeTrackingKt.findClassLoader-j3M2jLw(classId).get();
            if (loader == null) {
                ResourcesKt.tryCleanResourceCachesForOldCompose();
                return;
            }
            Class<?> resourceCachesClass = loader.loadClass(ClassId.toFqn-impl(classId));
            Object instance = resourceCachesClass.getDeclaredField(Ids.ResourceCaches.INSTANCE.getInstance().getFieldName()).get(null);
            Class<?> resourceCachesDesktopKtClass = loader.loadClass(ClassId.toFqn-impl(Ids.ResourceCaches_desktopKt.INSTANCE.getClassId-uSFnFHE()));
            Object[] objectArray = new Class[]{resourceCachesClass};
            Method method = resourceCachesDesktopKtClass.getDeclaredMethod(Ids.ResourceCaches_desktopKt.INSTANCE.getClearBlocking().getMethodName(), (Class<?>[])objectArray);
            objectArray = new Object[]{instance};
            method.invoke(null, objectArray);
            LoggingKt.info(logger, "Resource caches cleared");
        }
        catch (Throwable t) {
            LoggingKt.error(logger, "Failed to clean resource caches", t);
        }
    }

    private static final void tryCleanResourceCachesForOldCompose() {
        ResourcesKt.cleanResourceCache-uEB1Bto(Ids.ImageResourcesKt.INSTANCE.getClassId-uSFnFHE(), Ids.ImageResourcesKt.INSTANCE.getDropImageCache(), "Images");
        ResourcesKt.cleanResourceCache-uEB1Bto(Ids.StringResourcesUtilsKt.INSTANCE.getClassId-uSFnFHE(), Ids.StringResourcesUtilsKt.INSTANCE.getDropStringItemsCache(), "Strings");
    }

    public static final void cleanResourceCacheIfNecessary(@NotNull Context $this$cleanResourceCacheIfNecessary) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanResourceCacheIfNecessary, (String)"<this>");
        if (ResourcesKt.hasChangedResources($this$cleanResourceCacheIfNecessary)) {
            ResourcesKt.tryCleanResourceCaches();
        }
    }

    private static final boolean hasChangedResources(Context $this$hasChangedResources) {
        boolean bl;
        block4: {
            OrchestrationMessage.ReloadClassesRequest reloadClassesRequest = (OrchestrationMessage.ReloadClassesRequest)$this$hasChangedResources.get(OrchestrationMessage.ReloadClassesRequest.Key);
            Map map2 = reloadClassesRequest != null ? reloadClassesRequest.getChangedClassFiles() : null;
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map $this$any$iv = map2;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    File file = (File)entry.getKey();
                    if (!(file.isFile() && !FileUtilsKt.isClass(file))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        String string = MethodHandles.lookup().lookupClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        logger = LoggingKt.createLogger-e0kQHLI$default(string, null, null, 6, null);
    }
}

